/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterLeadershipPriorityRequestData
implements ApiMessage {
    List<Integer> brokerIds;
    String reason;
    byte priorityOperationCode;
    boolean force;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The list of brokers to alter leadership priority."), new Field("reason", Type.COMPACT_STRING, "An explanation for altering leadership priority."), new Field("priority_operation_code", Type.INT8, "Whether to alter leadership priority by demoting (0) or promoting (1)."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The list of brokers to alter leadership priority."), new Field("reason", Type.COMPACT_STRING, "An explanation for altering leadership priority."), new Field("priority_operation_code", Type.INT8, "Whether to alter leadership priority by demoting (0) or promoting (1)."), new Field("force", Type.BOOLEAN, "Whether to force the demotion if the configured limit has already been reached."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public AlterLeadershipPriorityRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterLeadershipPriorityRequestData() {
        this.brokerIds = new ArrayList<Integer>(0);
        this.reason = "";
        this.priorityOperationCode = 0;
        this.force = false;
    }

    @Override
    public short apiKey() {
        return 10019;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokerIds was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.brokerIds = newCollection;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field reason was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field reason had invalid length " + length);
        }
        this.reason = _readable.readString(length);
        this.priorityOperationCode = _readable.readByte();
        this.force = _version >= 1 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
        for (Integer brokerIdsElement : this.brokerIds) {
            _writable.writeInt(brokerIdsElement);
        }
        byte[] _stringBytes = _cache.getSerializedValue(this.reason);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeByte(this.priorityOperationCode);
        if (_version >= 1) {
            _writable.writeByte(this.force ? (byte)1 : 0);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1));
        _size.addBytes(this.brokerIds.size() * 4);
        byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'reason' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.reason, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(1);
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterLeadershipPriorityRequestData)) {
            return false;
        }
        AlterLeadershipPriorityRequestData other = (AlterLeadershipPriorityRequestData)obj;
        if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        if (this.priorityOperationCode != other.priorityOperationCode) {
            return false;
        }
        if (this.force != other.force) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
        hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
        hashCode = 31 * hashCode + this.priorityOperationCode;
        hashCode = 31 * hashCode + (this.force ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public AlterLeadershipPriorityRequestData duplicate() {
        AlterLeadershipPriorityRequestData _duplicate = new AlterLeadershipPriorityRequestData();
        ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
        for (Integer _element : this.brokerIds) {
            newBrokerIds.add(_element);
        }
        _duplicate.brokerIds = newBrokerIds;
        _duplicate.reason = this.reason;
        _duplicate.priorityOperationCode = this.priorityOperationCode;
        _duplicate.force = this.force;
        return _duplicate;
    }

    public String toString() {
        return "AlterLeadershipPriorityRequestData(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ", reason=" + (this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ", priorityOperationCode=" + this.priorityOperationCode + ", force=" + (this.force ? "true" : "false") + ")";
    }

    public List<Integer> brokerIds() {
        return this.brokerIds;
    }

    public String reason() {
        return this.reason;
    }

    public byte priorityOperationCode() {
        return this.priorityOperationCode;
    }

    public boolean force() {
        return this.force;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterLeadershipPriorityRequestData setBrokerIds(List<Integer> v) {
        this.brokerIds = v;
        return this;
    }

    public AlterLeadershipPriorityRequestData setReason(String v) {
        this.reason = v;
        return this;
    }

    public AlterLeadershipPriorityRequestData setPriorityOperationCode(byte v) {
        this.priorityOperationCode = v;
        return this;
    }

    public AlterLeadershipPriorityRequestData setForce(boolean v) {
        this.force = v;
        return this;
    }
}

