/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.link;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;
import org.apache.kafka.server.metrics.ApiSensors;

public class ClusterLinkRequestContext
extends RequestContext {
    private final ClusterLinkSourceMetrics linkMetrics;
    private final Time time;
    private final long startNanos;

    public ClusterLinkRequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, Time time, ClusterLinkSourceMetrics linkMetrics, boolean fromPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext) {
        super(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, principalSerde, authenticationContext);
        this.time = time;
        this.startNanos = time.nanoseconds();
        this.linkMetrics = linkMetrics;
    }

    @Override
    public RequestAndSize parseRequest(ByteBuffer buffer) {
        long totalSize = ApiSensors.calculateRequestSize(this.header, buffer);
        this.linkMetrics.recordRequest(this.header.apiKey(), totalSize, this.time.milliseconds());
        return super.parseRequest(buffer);
    }

    @Override
    public Send buildResponseSend(AbstractResponse body) {
        Send send = super.buildResponseSend(body);
        this.linkMetrics.recordResponse(this.header.apiKey(), send.size(), this.time.nanoseconds() - this.startNanos, body.errorCounts(), this.time.milliseconds());
        return send;
    }
}

