/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.util.Objects;

public class PathAwareSniHostName {
    private final String routingPathPrefix;
    private final String strippedHostName;
    private final String logicalClusterId;

    public PathAwareSniHostName(String rawHostName) {
        int endPos;
        Objects.requireNonNull(rawHostName);
        if (rawHostName.length() > 3 && rawHostName.charAt(2) == '-' && (rawHostName.startsWith("lkc-", 3) || rawHostName.startsWith("e-", 3))) {
            this.routingPathPrefix = rawHostName.substring(0, 2);
            this.strippedHostName = rawHostName.substring(3);
        } else {
            this.routingPathPrefix = null;
            this.strippedHostName = rawHostName;
        }
        this.logicalClusterId = this.strippedHostName.startsWith("lkc-") ? ((endPos = this.strippedHostName.indexOf(45, 4)) != -1 ? this.strippedHostName.substring(0, endPos) : null) : null;
    }

    public String routingPathPrefix() {
        return this.routingPathPrefix;
    }

    public String strippedHostname() {
        return this.strippedHostName;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAwareSniHostName that = (PathAwareSniHostName)o;
        return Objects.equals(this.routingPathPrefix, that.routingPathPrefix) && this.strippedHostName.equals(that.strippedHostName) && Objects.equals(this.logicalClusterId, that.logicalClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.routingPathPrefix, this.strippedHostName, this.logicalClusterId);
    }
}

