/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.SendBuilder;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeBalancerStatusRequest;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsRequest;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeMirrorsRequest;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListClusterLinksRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListMirrorsRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.ReplicaStatusRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ReverseConnectionRequest;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;

public abstract class AbstractRequest
implements AbstractRequestResponse {
    private final short version;
    private final ApiKeys apiKey;

    public AbstractRequest(ApiKeys apiKey, short version) {
        if (!apiKey.isVersionSupported(version)) {
            throw new UnsupportedVersionException("The " + (Object)((Object)apiKey) + " protocol does not support version " + version);
        }
        this.version = version;
        this.apiKey = apiKey;
    }

    public short version() {
        return this.version;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public final Send toSend(RequestHeader header) {
        return SendBuilder.buildRequestSend(header, this.data());
    }

    public final Send toSend(RequestHeader header, MessageContext context) {
        return SendBuilder.buildRequestSend(header, this.data(), context);
    }

    public final ByteBuffer serializeWithHeader(RequestHeader header) {
        if (header.apiKey() != this.apiKey) {
            throw new IllegalArgumentException("Could not build request " + (Object)((Object)this.apiKey) + " with header api key " + (Object)((Object)header.apiKey()));
        }
        if (header.apiVersion() != this.version) {
            throw new IllegalArgumentException("Could not build request version " + this.version + " with header version " + header.apiVersion());
        }
        return RequestUtils.serialize(header.data(), header.headerVersion(), this.data(), this.version);
    }

    public final ByteBuffer serialize() {
        return MessageUtil.toByteBuffer(this.data(), this.version);
    }

    final int sizeInBytes() {
        return this.data().size(new ObjectSerializationCache(), this.version);
    }

    public String toString(boolean verbose) {
        return this.data().toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public AbstractResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public abstract AbstractResponse getErrorResponse(int var1, Throwable var2);

    public Map<Errors, Integer> errorCounts(Throwable e) {
        AbstractResponse response = this.getErrorResponse(0, e);
        if (response == null) {
            throw new IllegalStateException("Error counts could not be obtained for request " + this);
        }
        return response.errorCounts();
    }

    public static RequestAndSize parseRequest(ApiKeys apiKey, short apiVersion, ByteBuffer buffer, MessageContext context) {
        int bufferSize = buffer.remaining();
        return new RequestAndSize(AbstractRequest.doParseRequest(apiKey, apiVersion, buffer, context), bufferSize);
    }

    private static AbstractRequest doParseRequest(ApiKeys apiKey, short apiVersion, ByteBuffer buffer, MessageContext context) {
        switch (apiKey) {
            case PRODUCE: {
                return ProduceRequest.parse(buffer, apiVersion, context);
            }
            case FETCH: {
                return FetchRequest.parse(buffer, apiVersion, context);
            }
            case LIST_OFFSETS: {
                return ListOffsetsRequest.parse(buffer, apiVersion, context);
            }
            case METADATA: {
                return MetadataRequest.parse(buffer, apiVersion, context);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(buffer, apiVersion, context);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(buffer, apiVersion, context);
            }
            case FIND_COORDINATOR: {
                return FindCoordinatorRequest.parse(buffer, apiVersion, context);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(buffer, apiVersion, context);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(buffer, apiVersion, context);
            }
            case LEAVE_GROUP: {
                return LeaveGroupRequest.parse(buffer, apiVersion, context);
            }
            case SYNC_GROUP: {
                return SyncGroupRequest.parse(buffer, apiVersion, context);
            }
            case STOP_REPLICA: {
                return StopReplicaRequest.parse(buffer, apiVersion, context);
            }
            case CONTROLLED_SHUTDOWN: {
                return ControlledShutdownRequest.parse(buffer, apiVersion, context);
            }
            case UPDATE_METADATA: {
                return UpdateMetadataRequest.parse(buffer, apiVersion, context);
            }
            case LEADER_AND_ISR: {
                return LeaderAndIsrRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsRequest.parse(buffer, apiVersion, context);
            }
            case LIST_GROUPS: {
                return ListGroupsRequest.parse(buffer, apiVersion, context);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeRequest.parse(buffer, apiVersion, context);
            }
            case API_VERSIONS: {
                return ApiVersionsRequest.parse(buffer, apiVersion, context);
            }
            case CREATE_TOPICS: {
                return CreateTopicsRequest.parse(buffer, apiVersion, context);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsRequest.parse(buffer, apiVersion, context);
            }
            case DELETE_RECORDS: {
                return DeleteRecordsRequest.parse(buffer, apiVersion, context);
            }
            case INIT_PRODUCER_ID: {
                return InitProducerIdRequest.parse(buffer, apiVersion, context);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return OffsetsForLeaderEpochRequest.parse(buffer, apiVersion, context);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return AddPartitionsToTxnRequest.parse(buffer, apiVersion, context);
            }
            case ADD_OFFSETS_TO_TXN: {
                return AddOffsetsToTxnRequest.parse(buffer, apiVersion, context);
            }
            case END_TXN: {
                return EndTxnRequest.parse(buffer, apiVersion, context);
            }
            case WRITE_TXN_MARKERS: {
                return WriteTxnMarkersRequest.parse(buffer, apiVersion, context);
            }
            case TXN_OFFSET_COMMIT: {
                return TxnOffsetCommitRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_ACLS: {
                return DescribeAclsRequest.parse(buffer, apiVersion, context);
            }
            case CREATE_ACLS: {
                return CreateAclsRequest.parse(buffer, apiVersion, context);
            }
            case DELETE_ACLS: {
                return DeleteAclsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_CONFIGS: {
                return DescribeConfigsRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return AlterReplicaLogDirsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_LOG_DIRS: {
                return DescribeLogDirsRequest.parse(buffer, apiVersion, context);
            }
            case SASL_AUTHENTICATE: {
                return SaslAuthenticateRequest.parse(buffer, apiVersion, context);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsRequest.parse(buffer, apiVersion, context);
            }
            case CREATE_DELEGATION_TOKEN: {
                return CreateDelegationTokenRequest.parse(buffer, apiVersion, context);
            }
            case RENEW_DELEGATION_TOKEN: {
                return RenewDelegationTokenRequest.parse(buffer, apiVersion, context);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return ExpireDelegationTokenRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return DescribeDelegationTokenRequest.parse(buffer, apiVersion, context);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsRequest.parse(buffer, apiVersion, context);
            }
            case ELECT_LEADERS: {
                return ElectLeadersRequest.parse(buffer, apiVersion, context);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterConfigsRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return AlterPartitionReassignmentsRequest.parse(buffer, apiVersion, context);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return ListPartitionReassignmentsRequest.parse(buffer, apiVersion, context);
            }
            case OFFSET_DELETE: {
                return OffsetDeleteRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return DescribeClientQuotasRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_CLIENT_QUOTAS: {
                return AlterClientQuotasRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return DescribeUserScramCredentialsRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return AlterUserScramCredentialsRequest.parse(buffer, apiVersion, context);
            }
            case VOTE: {
                return VoteRequest.parse(buffer, apiVersion, context);
            }
            case BEGIN_QUORUM_EPOCH: {
                return BeginQuorumEpochRequest.parse(buffer, apiVersion, context);
            }
            case END_QUORUM_EPOCH: {
                return EndQuorumEpochRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_QUORUM: {
                return DescribeQuorumRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_PARTITION: {
                return AlterPartitionRequest.parse(buffer, apiVersion, context);
            }
            case UPDATE_FEATURES: {
                return UpdateFeaturesRequest.parse(buffer, apiVersion, context);
            }
            case ENVELOPE: {
                return EnvelopeRequest.parse(buffer, apiVersion, context);
            }
            case FETCH_SNAPSHOT: {
                return FetchSnapshotRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_CLUSTER: {
                return DescribeClusterRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_PRODUCERS: {
                return DescribeProducersRequest.parse(buffer, apiVersion, context);
            }
            case BROKER_REGISTRATION: {
                return BrokerRegistrationRequest.parse(buffer, apiVersion, context);
            }
            case BROKER_HEARTBEAT: {
                return BrokerHeartbeatRequest.parse(buffer, apiVersion, context);
            }
            case UNREGISTER_BROKER: {
                return UnregisterBrokerRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_TRANSACTIONS: {
                return DescribeTransactionsRequest.parse(buffer, apiVersion, context);
            }
            case LIST_TRANSACTIONS: {
                return ListTransactionsRequest.parse(buffer, apiVersion, context);
            }
            case ALLOCATE_PRODUCER_IDS: {
                return AllocateProducerIdsRequest.parse(buffer, apiVersion, context);
            }
        }
        return AbstractRequest.maybeParseInternalRequest(apiKey, apiVersion, buffer, context);
    }

    private static AbstractRequest maybeParseInternalRequest(ApiKeys apiKey, short apiVersion, ByteBuffer buffer, MessageContext context) {
        switch (apiKey) {
            case REMOVE_BROKERS: {
                return RemoveBrokersRequest.parse(buffer, apiVersion, context);
            }
            case INITIATE_SHUTDOWN: {
                return InitiateShutdownRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_BROKER_REMOVALS: {
                return DescribeBrokerRemovalsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_BROKER_ADDITIONS: {
                return DescribeBrokerAdditionsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_BALANCER_STATUS: {
                return DescribeBalancerStatusRequest.parse(buffer, apiVersion, context);
            }
            case REPLICA_STATUS: {
                return ReplicaStatusRequest.parse(buffer, apiVersion, context);
            }
            case CREATE_CLUSTER_LINKS: {
                return CreateClusterLinksRequest.parse(buffer, apiVersion, context);
            }
            case LIST_CLUSTER_LINKS: {
                return ListClusterLinksRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_CLUSTER_LINKS: {
                return DescribeClusterLinksRequest.parse(buffer, apiVersion, context);
            }
            case DELETE_CLUSTER_LINKS: {
                return DeleteClusterLinksRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_MIRRORS: {
                return AlterMirrorsRequest.parse(buffer, apiVersion, context);
            }
            case LIST_MIRRORS: {
                return ListMirrorsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_MIRRORS: {
                return DescribeMirrorsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: {
                return DescribeEvenClusterLoadStatusRequest.parse(buffer, apiVersion, context);
            }
            case INITIATE_REVERSE_CONNECTIONS: {
                return InitiateReverseConnectionsRequest.parse(buffer, apiVersion, context);
            }
            case REVERSE_CONNECTION: {
                return ReverseConnectionRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_LEADERSHIP_PRIORITY: {
                return AlterLeadershipPriorityRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_LEADERSHIP_PRIORITY: {
                return DescribeLeadershipPriorityRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_BROKER_REPLICA_EXCLUSIONS: {
                return AlterBrokerReplicaExclusionsRequest.parse(buffer, apiVersion, context);
            }
            case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: {
                return DescribeBrokerReplicaExclusionsRequest.parse(buffer, apiVersion, context);
            }
            case REPORT_QUOTA_CONSUMPTION: {
                return ReportQuotaConsumptionRequest.parse(buffer, apiVersion, context);
            }
            case PUBLISH_QUOTA_TARGET: {
                return PublishQuotaTargetRequest.parse(buffer, apiVersion, context);
            }
            case TRIGGER_EVEN_CLUSTER_LOAD: {
                return TriggerEvenClusterLoadRequest.parse(buffer, apiVersion, context);
            }
            case ALTER_MIRROR_TOPICS: {
                return AlterMirrorTopicsRequest.parse(buffer, apiVersion, context);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseRequest`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private final short oldestAllowedVersion;
        private final short latestAllowedVersion;

        public Builder(ApiKeys apiKey) {
            this(apiKey, apiKey.oldestVersion(), apiKey.latestVersion());
        }

        public Builder(ApiKeys apiKey, short allowedVersion) {
            this(apiKey, allowedVersion, allowedVersion);
        }

        public Builder(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
            this.apiKey = apiKey;
            this.oldestAllowedVersion = oldestAllowedVersion;
            this.latestAllowedVersion = latestAllowedVersion;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public short oldestAllowedVersion() {
            return this.oldestAllowedVersion;
        }

        public short latestAllowedVersion() {
            return this.latestAllowedVersion;
        }

        public T build() {
            return this.build(this.latestAllowedVersion());
        }

        public abstract T build(short var1);
    }
}

