/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SNIHostName;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.DelayedResponseAuthenticationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.network.ReauthenticationContext;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;

public class KafkaChannel
implements AutoCloseable {
    private static final long MIN_REAUTH_INTERVAL_ONE_SECOND_NANOS = 1000000000L;
    private final String id;
    private final TransportLayer transportLayer;
    private final Supplier<Authenticator> authenticatorCreator;
    private final BrokerInterceptor interceptor;
    private Authenticator authenticator;
    private KafkaChannelMetrics metrics;
    private final int maxReceiveSize;
    private final MemoryPool memoryPool;
    private final ChannelMetadataRegistry metadataRegistry;
    private NetworkReceive receive;
    private NetworkSend send;
    private boolean disconnected;
    private ChannelMuteState muteState;
    private ChannelState state;
    private SocketAddress remoteAddress;
    private boolean midWrite;
    private long lastReauthenticationStartNanos;
    private final boolean shouldParseSNIHostName;
    private long handshakeStartTimeNanos;
    private long authenticationStartTimeNanos;
    private PathAwareSniHostName sniHostName;
    private Consumer<KafkaChannel> closeListener;
    private final Time time;
    private ChannelProxyState proxyState;

    public KafkaChannel(String id, TransportLayer transportLayer, Supplier<Authenticator> authenticatorCreator, int maxReceiveSize, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, BrokerInterceptor interceptor, Time time) {
        this(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool, metadataRegistry, interceptor, time, false);
    }

    public KafkaChannel(String id, TransportLayer transportLayer, Supplier<Authenticator> authenticatorCreator, int maxReceiveSize, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, BrokerInterceptor interceptor, Time time, boolean shouldParseSNI) {
        this.id = id;
        this.transportLayer = transportLayer;
        this.authenticatorCreator = authenticatorCreator;
        this.authenticator = authenticatorCreator.get();
        this.metrics = new KafkaChannelMetrics();
        this.maxReceiveSize = maxReceiveSize;
        this.memoryPool = memoryPool;
        this.metadataRegistry = metadataRegistry;
        this.disconnected = false;
        this.muteState = ChannelMuteState.NOT_MUTED;
        this.state = ChannelState.NOT_CONNECTED;
        this.interceptor = interceptor;
        this.shouldParseSNIHostName = shouldParseSNI;
        this.time = time;
        this.proxyState = transportLayer.proxyProtocolReady() ? ChannelProxyState.PROXY_PROCESSED : ChannelProxyState.PROXY_PENDING;
    }

    @Override
    public void close() throws IOException {
        this.disconnected = true;
        Utils.closeAll(this.transportLayer, this.authenticator, this.receive, this.metadataRegistry);
        if (this.closeListener != null) {
            this.closeListener.accept(this);
            this.closeListener = null;
        }
    }

    public KafkaChannelMetrics metrics() {
        return this.metrics;
    }

    public KafkaPrincipal principal() {
        return this.authenticator.principal();
    }

    public PublicCredential publicCredential() {
        KafkaPrincipal principal = this.principal();
        if (principal == null) {
            return null;
        }
        String authenticationId = principal instanceof ConfluentPrincipal ? ((ConfluentPrincipal)principal).authenticationId() : principal.getName();
        AuthenticationContext authenticationContext = this.authenticator.authenticationContext();
        SecurityProtocol securityProtocol = authenticationContext.securityProtocol();
        String saslMechanism = null;
        if (authenticationContext instanceof SaslAuthenticationContext) {
            saslMechanism = ((SaslAuthenticationContext)authenticationContext).server().getMechanismName();
        }
        return PublicCredential.authenticatedCredential(authenticationId, securityProtocol, saslMechanism);
    }

    public BrokerInterceptor interceptor() {
        return this.interceptor;
    }

    public Optional<KafkaPrincipalSerde> principalSerde() {
        return this.authenticator.principalSerde();
    }

    private void maybeMarkHandshakeStartTime() {
        if (this.handshakeStartTimeNanos == 0L) {
            this.handshakeStartTimeNanos = this.time.nanoseconds();
        }
    }

    private void maybeMarkHandshakeEndTime() {
        if (this.handshakeStartTimeNanos != 0L) {
            this.metrics.transportHandshakeTimeNanos = this.time.nanoseconds() - this.handshakeStartTimeNanos;
            this.handshakeStartTimeNanos = 0L;
        }
    }

    private void maybeMarkAuthenticationStartTime() {
        if (this.authenticationStartTimeNanos == 0L) {
            this.authenticationStartTimeNanos = this.time.nanoseconds();
        }
    }

    private void maybeMarkAuthenticationEndTime() {
        if (this.authenticationStartTimeNanos != 0L) {
            this.metrics.authenticationTimeNanos = this.time.nanoseconds() - this.authenticationStartTimeNanos;
            this.authenticationStartTimeNanos = 0L;
        }
    }

    public void setConnectionRegistrationTime(long timeNanos) {
        this.metrics.registrationTimeNanos = timeNanos;
    }

    public void prepare() throws AuthenticationException, IOException {
        boolean authenticating = false;
        try {
            if (this.proxyState == ChannelProxyState.PROXY_PENDING) {
                this.transportLayer.handleProxyProtocol();
                if (this.transportLayer.proxyProtocolReady()) {
                    this.proxyState = ChannelProxyState.PROXY_READY;
                }
            }
            if (this.transportLayer.proxyProtocolReady() && !this.transportLayer.ready()) {
                this.maybeMarkHandshakeStartTime();
                this.transportLayer.handshake();
            }
            if (this.shouldParseSNIHostName && this.transportLayer instanceof SslTransportLayer && this.authenticator instanceof SaslServerAuthenticator) {
                Optional<SNIHostName> hostName = ((SslTransportLayer)this.transportLayer).sniHostName();
                hostName.ifPresent(name -> {
                    this.sniHostName = new PathAwareSniHostName(name.getAsciiName());
                    ((SaslServerAuthenticator)this.authenticator).setSniHostName(this.sniHostName);
                });
            }
            if (this.transportLayer.proxyProtocolReady() && this.transportLayer.ready()) {
                this.maybeMarkHandshakeEndTime();
                if (!this.authenticator.complete()) {
                    this.maybeMarkAuthenticationStartTime();
                    authenticating = true;
                    this.authenticator.authenticate();
                }
            }
            if (this.ready()) {
                this.maybeMarkAuthenticationEndTime();
                ++this.metrics.successfulAuthentications;
                this.state = ChannelState.READY;
            }
        }
        catch (AuthenticationException e) {
            String remoteDesc = this.remoteAddress != null ? this.remoteAddress.toString() : null;
            this.state = new ChannelState(ChannelState.State.AUTHENTICATION_FAILED, e, remoteDesc);
            this.maybeMarkHandshakeEndTime();
            if (authenticating) {
                this.maybeMarkAuthenticationEndTime();
                this.delayCloseOnAuthenticationFailure();
                throw new DelayedResponseAuthenticationException(e);
            }
            throw e;
        }
    }

    public void disconnect() {
        this.disconnected = true;
        if (this.state == ChannelState.NOT_CONNECTED && this.remoteAddress != null) {
            this.state = new ChannelState(ChannelState.State.NOT_CONNECTED, this.remoteAddress.toString());
        }
        this.transportLayer.disconnect();
    }

    public void state(ChannelState state) {
        this.state = state;
    }

    public ChannelState state() {
        return this.state;
    }

    public boolean finishConnect() throws IOException {
        boolean connected;
        SocketChannel socketChannel = this.transportLayer.socketChannel();
        if (socketChannel != null) {
            this.remoteAddress = socketChannel.getRemoteAddress();
        }
        if (connected = this.transportLayer.finishConnect()) {
            this.state = this.ready() ? ChannelState.READY : (this.remoteAddress != null ? new ChannelState(ChannelState.State.AUTHENTICATE, this.remoteAddress.toString()) : ChannelState.AUTHENTICATE);
        }
        return connected;
    }

    public boolean isConnected() {
        return this.transportLayer.isConnected();
    }

    public String id() {
        return this.id;
    }

    public KafkaChannel reverse(String newChannelId, Consumer<KafkaChannel> closeListener) {
        return this.reverse(newChannelId, null, null, Optional.empty(), this.authenticationContext(), closeListener);
    }

    public KafkaChannel reverse(String newChannelId, BrokerInterceptor interceptor, KafkaPrincipal localPrincipal, Optional<KafkaPrincipalSerde> localPrincipalSerde, AuthenticationContext authenticationContext, Consumer<KafkaChannel> closeListener) {
        if (!this.authenticator.complete()) {
            throw new IllegalStateException("Cannot reverse channel before completing authentication");
        }
        ReverseChannelAuthenticator reverseAuthenticator = new ReverseChannelAuthenticator(authenticationContext, localPrincipal, localPrincipalSerde);
        KafkaChannel reverseChannel = new KafkaChannel(newChannelId, this.transportLayer, () -> reverseAuthenticator, this.maxReceiveSize, this.memoryPool, this.metadataRegistry, interceptor, this.time, this.shouldParseSNIHostName);
        reverseChannel.closeListener = closeListener;
        if (this.metadataRegistry.clientInformation() == null) {
            this.metadataRegistry.registerClientInformation(ClientInformation.EMPTY);
        }
        return reverseChannel;
    }

    public KafkaChannel proxyChannel(String newChannelId) {
        if (!this.transportLayer.proxyProtocolReady()) {
            throw new IllegalStateException("Cannot create proxy channel before proxy protocol handled");
        }
        KafkaChannel proxyChannel = new KafkaChannel(newChannelId, this.transportLayer, () -> this.authenticator, this.maxReceiveSize, this.memoryPool, this.metadataRegistry, this.interceptor, this.time, this.shouldParseSNIHostName);
        if (this.metadataRegistry.clientInformation() == null) {
            this.metadataRegistry.registerClientInformation(ClientInformation.EMPTY);
        }
        return proxyChannel;
    }

    public SelectionKey selectionKey() {
        return this.transportLayer.selectionKey();
    }

    void selectionKey(SelectionKey newKey) {
        this.transportLayer.selectionKey(newKey);
    }

    void mute() {
        if (this.muteState == ChannelMuteState.NOT_MUTED) {
            if (!this.disconnected) {
                this.transportLayer.removeInterestOps(1);
            }
            this.muteState = ChannelMuteState.MUTED;
        }
    }

    boolean maybeUnmute() {
        if (this.muteState == ChannelMuteState.MUTED) {
            if (!this.disconnected) {
                this.transportLayer.addInterestOps(1);
            }
            this.muteState = ChannelMuteState.NOT_MUTED;
        }
        return this.muteState == ChannelMuteState.NOT_MUTED;
    }

    public void handleChannelMuteEvent(ChannelMuteEvent event) {
        boolean stateChanged = false;
        switch (event) {
            case REQUEST_RECEIVED: {
                if (this.muteState != ChannelMuteState.MUTED) break;
                this.muteState = ChannelMuteState.MUTED_AND_RESPONSE_PENDING;
                stateChanged = true;
                break;
            }
            case RESPONSE_SENT: {
                if (this.muteState == ChannelMuteState.MUTED_AND_RESPONSE_PENDING) {
                    this.muteState = ChannelMuteState.MUTED;
                    stateChanged = true;
                }
                if (this.muteState != ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_THROTTLED;
                stateChanged = true;
                break;
            }
            case THROTTLE_STARTED: {
                if (this.muteState != ChannelMuteState.MUTED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING;
                stateChanged = true;
                break;
            }
            case THROTTLE_ENDED: {
                if (this.muteState == ChannelMuteState.MUTED_AND_THROTTLED) {
                    this.muteState = ChannelMuteState.MUTED;
                    stateChanged = true;
                }
                if (this.muteState != ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_RESPONSE_PENDING;
                stateChanged = true;
            }
        }
        if (!stateChanged) {
            throw new IllegalStateException("Cannot transition from " + this.muteState.name() + " for " + event.name());
        }
    }

    public ChannelMuteState muteState() {
        return this.muteState;
    }

    private void delayCloseOnAuthenticationFailure() {
        this.transportLayer.removeInterestOps(4);
    }

    void completeCloseOnAuthenticationFailure() throws IOException {
        this.transportLayer.addInterestOps(4);
        this.authenticator.handleAuthenticationFailure();
    }

    public boolean isMuted() {
        return this.muteState != ChannelMuteState.NOT_MUTED;
    }

    public boolean isInMutableState() {
        if (this.receive == null || this.receive.memoryAllocated()) {
            return false;
        }
        return this.transportLayer.ready();
    }

    public boolean ready() {
        return this.transportLayer.proxyProtocolReady() && this.transportLayer.ready() && this.authenticator.complete();
    }

    public boolean hasSend() {
        return this.send != null;
    }

    public ChannelProxyState proxyState() {
        return this.proxyState;
    }

    public void proxyState(ChannelProxyState proxyState) {
        this.proxyState = proxyState;
    }

    public InetAddress socketAddress() {
        return this.transportLayer.socketAddress();
    }

    public String socketDescription() {
        Socket socket = this.transportLayer.socketChannel().socket();
        if (socket.getInetAddress() == null) {
            return socket.getLocalAddress().toString();
        }
        return socket.getInetAddress().toString();
    }

    public SocketChannel socketChannel() {
        return this.transportLayer.socketChannel();
    }

    public void setSend(NetworkSend send) {
        if (this.send != null) {
            throw new IllegalStateException("Attempt to begin a send operation with prior send operation still in progress, connection id is " + this.id);
        }
        this.send = send;
        this.transportLayer.addInterestOps(4);
    }

    public NetworkSend maybeCompleteSend() {
        if (this.send != null && this.send.completed()) {
            this.midWrite = false;
            this.transportLayer.removeInterestOps(4);
            NetworkSend result = this.send;
            this.send = null;
            return result;
        }
        return null;
    }

    public long read() throws IOException {
        if (this.receive == null) {
            this.receive = new NetworkReceive(this.maxReceiveSize, this.id, this.memoryPool);
        }
        long bytesReceived = this.receive(this.receive);
        if (this.receive.requiredMemoryAmountKnown() && !this.receive.memoryAllocated() && this.isInMutableState()) {
            this.mute();
        }
        return bytesReceived;
    }

    public NetworkReceive currentReceive() {
        return this.receive;
    }

    public NetworkReceive maybeCompleteReceive() {
        if (this.receive != null && this.receive.complete()) {
            this.receive.payload().rewind();
            NetworkReceive result = this.receive;
            this.receive = null;
            return result;
        }
        return null;
    }

    public long write() throws IOException {
        if (this.send == null) {
            return 0L;
        }
        this.midWrite = true;
        return this.send.writeTo(this.transportLayer);
    }

    public void addNetworkIoTimeNanos(long nanos, boolean hasWrite) {
        KafkaChannelMetrics kafkaChannelMetrics = this.metrics;
        kafkaChannelMetrics.networkIoTimeNanos = kafkaChannelMetrics.networkIoTimeNanos + nanos;
        if (hasWrite) {
            kafkaChannelMetrics = this.metrics;
            kafkaChannelMetrics.writeIoTimeNanos = kafkaChannelMetrics.writeIoTimeNanos + nanos;
        }
    }

    public void resetNetworkIoTimes() {
        this.metrics.networkIoTimeNanos = 0L;
        this.metrics.writeIoTimeNanos = 0L;
    }

    public void resetRegisterTime() {
        this.metrics.registrationTimeNanos = 0L;
    }

    public void maybeRecordRegisterTime(Sensor registerTime) {
        if (this.metrics.registrationTimeNanos != 0L) {
            registerTime.record(this.metrics.registrationTimeNanos);
            this.resetRegisterTime();
        }
    }

    public void maybeRecordHandshakeTime(Sensor transportHandshakeTime) {
        if (this.metrics.transportHandshakeTimeNanos != 0L) {
            transportHandshakeTime.record(this.metrics.transportHandshakeTimeNanos);
            this.metrics.transportHandshakeTimeNanos = 0L;
        }
    }

    public void maybeRecordAuthenticationTime(Sensor authenticationTime) {
        if (this.metrics.authenticationTimeNanos > 0L) {
            authenticationTime.record(this.metrics.authenticationTimeNanos);
            this.metrics.authenticationTimeNanos = 0L;
        }
    }

    private long receive(NetworkReceive receive) throws IOException {
        try {
            return receive.readFrom(this.transportLayer);
        }
        catch (SslAuthenticationException e) {
            String remoteDesc = this.remoteAddress != null ? this.remoteAddress.toString() : null;
            this.state = new ChannelState(ChannelState.State.AUTHENTICATION_FAILED, e, remoteDesc);
            throw e;
        }
    }

    public boolean hasBytesBuffered() {
        return this.transportLayer.hasBytesBuffered();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaChannel that = (KafkaChannel)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return super.toString() + " id=" + this.id;
    }

    public RequestContext newRequestContext(RequestHeader header, ListenerName listenerName, SecurityProtocol protocol, ClientInformation clientInformation, Metrics metrics, boolean isPrivilegedListener) {
        return this.interceptor.newContext(header, this.id, this.socketAddress(), this.principal(), listenerName, protocol, clientInformation, metrics, this.sniHostName, isPrivilegedListener, this.principalSerde(), this.authenticationContext());
    }

    public RequestContext newRequestContext(RequestHeader header, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaPrincipal principal, InetAddress clientAddress, ClientInformation clientInformation, Metrics metrics, boolean isPrivilegedListener) {
        return this.interceptor.newContext(header, this.id, clientAddress, principal, listenerName, securityProtocol, clientInformation, metrics, this.sniHostName, isPrivilegedListener, this.principalSerde(), this.authenticationContext());
    }

    public boolean maybeBeginServerReauthentication(NetworkReceive saslHandshakeNetworkReceive, Supplier<Long> nowNanosSupplier) throws AuthenticationException, IOException {
        if (!this.ready()) {
            throw new IllegalStateException("KafkaChannel should be \"ready\" when processing SASL Handshake for potential re-authentication");
        }
        if (this.authenticator.serverSessionExpirationTimeNanos() == null) {
            return false;
        }
        long nowNanos = nowNanosSupplier.get();
        if (this.lastReauthenticationStartNanos != 0L && nowNanos - this.lastReauthenticationStartNanos < 1000000000L) {
            return false;
        }
        this.lastReauthenticationStartNanos = nowNanos;
        this.swapAuthenticatorsAndBeginReauthentication(new ReauthenticationContext(this.authenticator, saslHandshakeNetworkReceive, nowNanos));
        return true;
    }

    public boolean maybeBeginClientReauthentication(Supplier<Long> nowNanosSupplier) throws AuthenticationException, IOException {
        if (!this.ready()) {
            throw new IllegalStateException("KafkaChannel should always be \"ready\" when it is checked for possible re-authentication");
        }
        if (this.muteState != ChannelMuteState.NOT_MUTED || this.midWrite || this.authenticator.clientSessionReauthenticationTimeNanos() == null) {
            return false;
        }
        long nowNanos = nowNanosSupplier.get();
        if (nowNanos < this.authenticator.clientSessionReauthenticationTimeNanos()) {
            return false;
        }
        this.swapAuthenticatorsAndBeginReauthentication(new ReauthenticationContext(this.authenticator, this.receive, nowNanos));
        this.receive = null;
        return true;
    }

    public Long reauthenticationLatencyMs() {
        return this.authenticator.reauthenticationLatencyMs();
    }

    public boolean serverAuthenticationSessionExpired(long nowNanos) {
        Long serverSessionExpirationTimeNanos = this.authenticator.serverSessionExpirationTimeNanos();
        return serverSessionExpirationTimeNanos != null && nowNanos - serverSessionExpirationTimeNanos > 0L;
    }

    public Optional<NetworkReceive> pollResponseReceivedDuringReauthentication() {
        return this.authenticator.pollResponseReceivedDuringReauthentication();
    }

    boolean connectedClientSupportsReauthentication() {
        return this.authenticator.connectedClientSupportsReauthentication();
    }

    private void swapAuthenticatorsAndBeginReauthentication(ReauthenticationContext reauthenticationContext) throws IOException {
        this.authenticator = this.authenticatorCreator.get();
        this.authenticator.reauthenticate(reauthenticationContext);
    }

    public ChannelMetadataRegistry channelMetadataRegistry() {
        return this.metadataRegistry;
    }

    public AuthenticationContext authenticationContext() {
        return this.authenticator.authenticationContext();
    }

    private static class ReverseChannelAuthenticator
    implements Authenticator {
        private final AuthenticationContext authenticationContext;
        private final KafkaPrincipal principal;
        private final Optional<KafkaPrincipalSerde> principalSerde;

        ReverseChannelAuthenticator(AuthenticationContext authenticationContext, KafkaPrincipal principal, Optional<KafkaPrincipalSerde> principalSerde) {
            this.authenticationContext = authenticationContext;
            this.principal = principal;
            this.principalSerde = principalSerde;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            return this.principal;
        }

        @Override
        public Optional<KafkaPrincipalSerde> principalSerde() {
            return this.principalSerde;
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public AuthenticationContext authenticationContext() {
            return this.authenticationContext;
        }

        @Override
        public void close() {
        }
    }

    public static class KafkaChannelMetrics {
        private long networkIoTimeNanos = 0L;
        private long writeIoTimeNanos = 0L;
        private long registrationTimeNanos = 0L;
        private int successfulAuthentications = 0;
        private long transportHandshakeTimeNanos = 0L;
        private long authenticationTimeNanos = 0L;

        public long networkIoTimeNanos() {
            return this.networkIoTimeNanos;
        }

        public long writeIoTimeNanos() {
            return this.writeIoTimeNanos;
        }

        public int successfulAuthentications() {
            return this.successfulAuthentications;
        }

        public long transportHandshakeTimeNanos() {
            return this.transportHandshakeTimeNanos;
        }

        public long authenticationTimeNanos() {
            return this.authenticationTimeNanos;
        }

        public long computeConnectionLocalServiceTimeNanos() {
            return this.registrationTimeNanos + this.transportHandshakeTimeNanos + this.authenticationTimeNanos;
        }
    }

    public static enum ChannelProxyState {
        PROXY_PENDING,
        PROXY_READY,
        PROXY_PROCESSED;

    }

    public static enum ChannelMuteEvent {
        REQUEST_RECEIVED,
        RESPONSE_SENT,
        THROTTLE_STARTED,
        THROTTLE_ENDED;

    }

    public static enum ChannelMuteState {
        NOT_MUTED,
        MUTED,
        MUTED_AND_RESPONSE_PENDING,
        MUTED_AND_THROTTLED,
        MUTED_AND_THROTTLED_AND_RESPONSE_PENDING;

    }
}

