/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ImplicitLinkedHashCollection<E extends Element>
extends AbstractCollection<E> {
    private static final int HEAD_INDEX = -1;
    public static final int INVALID_INDEX = -2;
    private static final int MIN_NONEMPTY_CAPACITY = 5;
    private static final Element[] EMPTY_ELEMENTS = new Element[0];
    private Element head;
    Element[] elements;
    private int size;

    private static Element indexToElement(Element head, Element[] elements, int index) {
        if (index == -1) {
            return head;
        }
        return elements[index];
    }

    private static void addToListTail(Element head, Element[] elements, int elementIdx) {
        int oldTailIdx = head.prev();
        Element element = ImplicitLinkedHashCollection.indexToElement(head, elements, elementIdx);
        Element oldTail = ImplicitLinkedHashCollection.indexToElement(head, elements, oldTailIdx);
        head.setPrev(elementIdx);
        oldTail.setNext(elementIdx);
        element.setPrev(oldTailIdx);
        element.setNext(-1);
    }

    private static void removeFromList(Element head, Element[] elements, int elementIdx) {
        Element element = ImplicitLinkedHashCollection.indexToElement(head, elements, elementIdx);
        elements[elementIdx] = null;
        int prevIdx = element.prev();
        int nextIdx = element.next();
        Element prev = ImplicitLinkedHashCollection.indexToElement(head, elements, prevIdx);
        Element next = ImplicitLinkedHashCollection.indexToElement(head, elements, nextIdx);
        prev.setNext(nextIdx);
        next.setPrev(prevIdx);
        element.setNext(-2);
        element.setPrev(-2);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator(0);
    }

    private ListIterator<E> listIterator(int index) {
        return new ImplicitLinkedHashCollectionIterator(index);
    }

    final int slot(Element[] curElements, Object e) {
        return (e.hashCode() & Integer.MAX_VALUE) % curElements.length;
    }

    private final int findIndexOfEqualElement(Object key) {
        if (key == null || this.size == 0) {
            return -2;
        }
        int slot = this.slot(this.elements, key);
        for (int seen = 0; seen < this.elements.length; ++seen) {
            Element element = this.elements[slot];
            if (element == null) {
                return -2;
            }
            if (element.elementKeysAreEqual(key)) {
                return slot;
            }
            slot = (slot + 1) % this.elements.length;
        }
        return -2;
    }

    public final E find(E key) {
        int index = this.findIndexOfEqualElement(key);
        if (index == -2) {
            return null;
        }
        Element result = this.elements[index];
        return (E)result;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean contains(Object key) {
        return this.findIndexOfEqualElement(key) != -2;
    }

    private static int calculateCapacity(int expectedNumElements) {
        int newCapacity = 2 * expectedNumElements + 1;
        return Math.max(newCapacity, 5);
    }

    @Override
    public final boolean add(E newElement) {
        int slot;
        if (newElement == null) {
            return false;
        }
        if (newElement.prev() != -2 || newElement.next() != -2) {
            return false;
        }
        if (this.size + 1 >= this.elements.length / 2) {
            this.changeCapacity(ImplicitLinkedHashCollection.calculateCapacity(this.elements.length));
        }
        if ((slot = this.addInternal((Element)newElement, this.elements)) >= 0) {
            ImplicitLinkedHashCollection.addToListTail(this.head, this.elements, slot);
            ++this.size;
            return true;
        }
        return false;
    }

    public final void mustAdd(E newElement) {
        if (!this.add(newElement)) {
            throw new RuntimeException("Unable to add " + newElement);
        }
    }

    public final void moveToTail(E element) {
        if (element.prev() == -2 || element.next() == -2) {
            throw new RuntimeException("Element " + element + " is not in the collection.");
        }
        Element prevElement = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.prev());
        Element nextElement = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.next());
        int slot = prevElement.next();
        prevElement.setNext(element.next());
        nextElement.setPrev(element.prev());
        ImplicitLinkedHashCollection.addToListTail(this.head, this.elements, slot);
    }

    int addInternal(Element newElement, Element[] addElements) {
        int slot = this.slot(addElements, newElement);
        for (int seen = 0; seen < addElements.length; ++seen) {
            Element element = addElements[slot];
            if (element == null) {
                addElements[slot] = newElement;
                return slot;
            }
            if (element.elementKeysAreEqual(newElement)) {
                return -2;
            }
            slot = (slot + 1) % addElements.length;
        }
        throw new RuntimeException("Not enough hash table slots to add a new element.");
    }

    private void changeCapacity(int newCapacity) {
        Element[] newElements = new Element[newCapacity];
        HeadElement newHead = new HeadElement();
        int oldSize = this.size;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            iter.remove();
            int newSlot = this.addInternal(element, newElements);
            ImplicitLinkedHashCollection.addToListTail(newHead, newElements, newSlot);
        }
        this.elements = newElements;
        this.head = newHead;
        this.size = oldSize;
    }

    @Override
    public final boolean remove(Object key) {
        int slot = this.findElementToRemove(key);
        if (slot == -2) {
            return false;
        }
        this.removeElementAtSlot(slot);
        return true;
    }

    int findElementToRemove(Object key) {
        return this.findIndexOfEqualElement(key);
    }

    private boolean removeElementAtSlot(int slot) {
        Element element;
        --this.size;
        ImplicitLinkedHashCollection.removeFromList(this.head, this.elements, slot);
        int endSlot = slot = (slot + 1) % this.elements.length;
        for (int seen = 0; seen < this.elements.length && (element = this.elements[endSlot]) != null; ++seen) {
            endSlot = (endSlot + 1) % this.elements.length;
        }
        while (slot != endSlot) {
            this.reseat(slot);
            slot = (slot + 1) % this.elements.length;
        }
        return true;
    }

    private void reseat(int prevSlot) {
        Element e;
        Element element = this.elements[prevSlot];
        int newSlot = this.slot(this.elements, element);
        for (int seen = 0; seen < this.elements.length && (e = this.elements[newSlot]) != null && e != element; ++seen) {
            newSlot = (newSlot + 1) % this.elements.length;
        }
        if (newSlot == prevSlot) {
            return;
        }
        Element prev = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.prev());
        prev.setNext(newSlot);
        Element next = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.next());
        next.setPrev(newSlot);
        this.elements[prevSlot] = null;
        this.elements[newSlot] = element;
    }

    public ImplicitLinkedHashCollection() {
        this(0);
    }

    public ImplicitLinkedHashCollection(int expectedNumElements) {
        this.clear(expectedNumElements);
    }

    public ImplicitLinkedHashCollection(Iterator<E> iter) {
        this.clear(0);
        while (iter.hasNext()) {
            this.mustAdd((Element)iter.next());
        }
    }

    @Override
    public final void clear() {
        this.clear(this.elements.length);
    }

    public final void moveToEnd(E element) {
        if (element.prev() == -2 || element.next() == -2) {
            throw new RuntimeException("Element " + element + " is not in the collection.");
        }
        Element prevElement = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.prev());
        Element nextElement = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.next());
        int slot = prevElement.next();
        prevElement.setNext(element.next());
        nextElement.setPrev(element.prev());
        ImplicitLinkedHashCollection.addToListTail(this.head, this.elements, slot);
    }

    public final void clear(int expectedNumElements) {
        if (expectedNumElements == 0) {
            this.head = HeadElement.EMPTY;
            this.elements = EMPTY_ELEMENTS;
            this.size = 0;
        } else {
            this.head = new HeadElement();
            this.elements = new Element[ImplicitLinkedHashCollection.calculateCapacity(expectedNumElements)];
            this.size = 0;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplicitLinkedHashCollection)) {
            return false;
        }
        ImplicitLinkedHashCollection ilhs = (ImplicitLinkedHashCollection)o;
        return this.valuesList().equals(ilhs.valuesList());
    }

    @Override
    public int hashCode() {
        return this.valuesList().hashCode();
    }

    final int numSlots() {
        return this.elements.length;
    }

    public List<E> valuesList() {
        return new ImplicitLinkedHashCollectionListView();
    }

    public Set<E> valuesSet() {
        return new ImplicitLinkedHashCollectionSetView();
    }

    public void sort(Comparator<E> comparator) {
        ArrayList<Element> array = new ArrayList<Element>(this.size);
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            iterator.remove();
            array.add(e);
        }
        array.sort(comparator);
        for (Element e : array) {
            this.add((E)e);
        }
    }

    private class ImplicitLinkedHashCollectionSetView
    extends AbstractSet<E> {
        private ImplicitLinkedHashCollectionSetView() {
        }

        @Override
        public Iterator<E> iterator() {
            return ImplicitLinkedHashCollection.this.iterator();
        }

        @Override
        public int size() {
            return ImplicitLinkedHashCollection.this.size;
        }

        @Override
        public boolean add(E newElement) {
            return ImplicitLinkedHashCollection.this.add(newElement);
        }

        @Override
        public boolean remove(Object key) {
            return ImplicitLinkedHashCollection.this.remove(key);
        }

        @Override
        public boolean contains(Object key) {
            return ImplicitLinkedHashCollection.this.contains(key);
        }

        @Override
        public void clear() {
            ImplicitLinkedHashCollection.this.clear();
        }
    }

    private class ImplicitLinkedHashCollectionListView
    extends AbstractSequentialList<E> {
        private ImplicitLinkedHashCollectionListView() {
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index < 0 || index > ImplicitLinkedHashCollection.this.size) {
                throw new IndexOutOfBoundsException();
            }
            return ImplicitLinkedHashCollection.this.listIterator(index);
        }

        @Override
        public int size() {
            return ImplicitLinkedHashCollection.this.size;
        }
    }

    private class ImplicitLinkedHashCollectionIterator
    implements ListIterator<E> {
        private int index = 0;
        private Element cur;
        private Element lastReturned;

        ImplicitLinkedHashCollectionIterator(int index) {
            this.cur = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, ImplicitLinkedHashCollection.this.head.next());
            for (int i = 0; i < index; ++i) {
                this.next();
            }
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            return this.cur != ImplicitLinkedHashCollection.this.head;
        }

        @Override
        public boolean hasPrevious() {
            return ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.prev()) != ImplicitLinkedHashCollection.this.head;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Element returnValue = this.cur;
            this.lastReturned = this.cur;
            this.cur = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.next());
            ++this.index;
            return returnValue;
        }

        @Override
        public E previous() {
            Element prev = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.prev());
            if (prev == ImplicitLinkedHashCollection.this.head) {
                throw new NoSuchElementException();
            }
            this.cur = prev;
            --this.index;
            this.lastReturned = this.cur;
            Element returnValue = this.cur;
            return returnValue;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Element nextElement = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.lastReturned.next());
            ImplicitLinkedHashCollection.this.removeElementAtSlot(nextElement.prev());
            if (this.lastReturned == this.cur) {
                this.cur = nextElement;
            } else {
                --this.index;
            }
            this.lastReturned = null;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class HeadElement
    implements Element {
        static final HeadElement EMPTY = new HeadElement();
        private int prev = -1;
        private int next = -1;

        private HeadElement() {
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public void setPrev(int prev) {
            this.prev = prev;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public void setNext(int next) {
            this.next = next;
        }
    }

    public static interface Element {
        public int prev();

        public void setPrev(int var1);

        public int next();

        public void setNext(int var1);

        default public boolean elementKeysAreEqual(Object other) {
            return this.equals(other);
        }
    }
}

