/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.InitiateShutdownResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class InitiateShutdownResponse
extends AbstractResponse {
    private final InitiateShutdownResponseData data;

    public InitiateShutdownResponse(InitiateShutdownResponseData responseData) {
        super(ApiKeys.INITIATE_SHUTDOWN);
        this.data = responseData;
    }

    @Override
    public InitiateShutdownResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static InitiateShutdownResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new InitiateShutdownResponse(new InitiateShutdownResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

