/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeBalancerStatusResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    BalancerStatusResponse balancerStatus;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code for the confluent balancer component"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("balancer_status", BalancerStatusResponse.SCHEMA_0, "Status of Confluent Balancer."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code for the confluent balancer component"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("balancer_status", BalancerStatusResponse.SCHEMA_1, "Status of Confluent Balancer."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public DescribeBalancerStatusResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeBalancerStatusResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.balancerStatus = new BalancerStatusResponse();
    }

    @Override
    public short apiKey() {
        return 10011;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        this.balancerStatus = new BalancerStatusResponse(_readable, _version, _context);
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        this.balancerStatus.write(_writable, _cache, _version, _context);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        int _sizeBeforeStruct = _size.totalSize();
        this.balancerStatus.addSize(_size, _cache, _version, _context);
        int n = _size.totalSize() - _sizeBeforeStruct;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeBalancerStatusResponseData)) {
            return false;
        }
        DescribeBalancerStatusResponseData other = (DescribeBalancerStatusResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.balancerStatus == null ? other.balancerStatus != null : !this.balancerStatus.equals(other.balancerStatus)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.balancerStatus == null ? 0 : this.balancerStatus.hashCode());
        return hashCode;
    }

    @Override
    public DescribeBalancerStatusResponseData duplicate() {
        DescribeBalancerStatusResponseData _duplicate = new DescribeBalancerStatusResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.balancerStatus = this.balancerStatus.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "DescribeBalancerStatusResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", balancerStatus=" + this.balancerStatus.toString() + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public BalancerStatusResponse balancerStatus() {
        return this.balancerStatus;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeBalancerStatusResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeBalancerStatusResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeBalancerStatusResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeBalancerStatusResponseData setBalancerStatus(BalancerStatusResponse v) {
        this.balancerStatus = v;
        return this;
    }

    public static class BalancerStatusResponse
    implements Message {
        String generalBalancerStatus;
        List<Integer> brokerIds;
        short balancerStatusErrorCode;
        String balancerStatusErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("general_balancer_status", Type.STRING, "The status of the confluent balancer component."), new Field("balancer_status_error_code", Type.INT16, "The error code for the confluent balancer component."), new Field("balancer_status_error_message", Type.NULLABLE_STRING, "The error message for the confluent balancer component status, or null if there was no error."));
        public static final Schema SCHEMA_1 = new Schema(new Field("general_balancer_status", Type.STRING, "The status of the confluent balancer component."), new Field("broker_ids", new ArrayOf(Type.INT32), "Unique IDs of the brokers where confluent balancer component is running."), new Field("balancer_status_error_code", Type.INT16, "The error code for the confluent balancer component."), new Field("balancer_status_error_message", Type.NULLABLE_STRING, "The error message for the confluent balancer component status, or null if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public BalancerStatusResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BalancerStatusResponse() {
            this.generalBalancerStatus = "";
            this.brokerIds = new ArrayList<Integer>(0);
            this.balancerStatusErrorCode = 0;
            this.balancerStatusErrorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BalancerStatusResponse");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field generalBalancerStatus was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field generalBalancerStatus had invalid length " + length);
            }
            this.generalBalancerStatus = _readable.readString(length);
            if (_version >= 1) {
                int arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field brokerIds was serialized as null");
                }
                ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.brokerIds = newCollection;
            } else {
                this.brokerIds = new ArrayList<Integer>(0);
            }
            this.balancerStatusErrorCode = _readable.readShort();
            length = _readable.readShort();
            if (length < 0) {
                this.balancerStatusErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field balancerStatusErrorMessage had invalid length " + length);
                }
                this.balancerStatusErrorMessage = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.generalBalancerStatus);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 1) {
                _writable.writeInt(this.brokerIds.size());
                _stringBytes = this.brokerIds.iterator();
                while (_stringBytes.hasNext()) {
                    Integer brokerIdsElement = (Integer)_stringBytes.next();
                    _writable.writeInt(brokerIdsElement);
                }
            } else if (!this.brokerIds.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default brokerIds at version " + _version);
            }
            _writable.writeShort(this.balancerStatusErrorCode);
            if (this.balancerStatusErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.balancerStatusErrorMessage);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BalancerStatusResponse");
            }
            byte[] _stringBytes = this.generalBalancerStatus.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'generalBalancerStatus' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.generalBalancerStatus, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (_version >= 1) {
                _size.addBytes(4);
                _size.addBytes(this.brokerIds.size() * 4);
            }
            _size.addBytes(2);
            if (this.balancerStatusErrorMessage == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = this.balancerStatusErrorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'balancerStatusErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.balancerStatusErrorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BalancerStatusResponse)) {
                return false;
            }
            BalancerStatusResponse other = (BalancerStatusResponse)obj;
            if (this.generalBalancerStatus == null ? other.generalBalancerStatus != null : !this.generalBalancerStatus.equals(other.generalBalancerStatus)) {
                return false;
            }
            if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
                return false;
            }
            if (this.balancerStatusErrorCode != other.balancerStatusErrorCode) {
                return false;
            }
            if (this.balancerStatusErrorMessage == null ? other.balancerStatusErrorMessage != null : !this.balancerStatusErrorMessage.equals(other.balancerStatusErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.generalBalancerStatus == null ? 0 : this.generalBalancerStatus.hashCode());
            hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
            hashCode = 31 * hashCode + this.balancerStatusErrorCode;
            hashCode = 31 * hashCode + (this.balancerStatusErrorMessage == null ? 0 : this.balancerStatusErrorMessage.hashCode());
            return hashCode;
        }

        @Override
        public BalancerStatusResponse duplicate() {
            BalancerStatusResponse _duplicate = new BalancerStatusResponse();
            _duplicate.generalBalancerStatus = this.generalBalancerStatus;
            ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
            for (Integer _element : this.brokerIds) {
                newBrokerIds.add(_element);
            }
            _duplicate.brokerIds = newBrokerIds;
            _duplicate.balancerStatusErrorCode = this.balancerStatusErrorCode;
            _duplicate.balancerStatusErrorMessage = this.balancerStatusErrorMessage == null ? null : this.balancerStatusErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "BalancerStatusResponse(generalBalancerStatus=" + (this.generalBalancerStatus == null ? "null" : "'" + this.generalBalancerStatus.toString() + "'") + ", brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ", balancerStatusErrorCode=" + this.balancerStatusErrorCode + ", balancerStatusErrorMessage=" + (this.balancerStatusErrorMessage == null ? "null" : "'" + this.balancerStatusErrorMessage.toString() + "'") + ")";
        }

        public String generalBalancerStatus() {
            return this.generalBalancerStatus;
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        public short balancerStatusErrorCode() {
            return this.balancerStatusErrorCode;
        }

        public String balancerStatusErrorMessage() {
            return this.balancerStatusErrorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BalancerStatusResponse setGeneralBalancerStatus(String v) {
            this.generalBalancerStatus = v;
            return this;
        }

        public BalancerStatusResponse setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        public BalancerStatusResponse setBalancerStatusErrorCode(short v) {
            this.balancerStatusErrorCode = v;
            return this;
        }

        public BalancerStatusResponse setBalancerStatusErrorMessage(String v) {
            this.balancerStatusErrorMessage = v;
            return this;
        }
    }
}

