/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.utils.Utils;

public class Topic {
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final String TRANSACTION_STATE_TOPIC_NAME = "__transaction_state";
    public static final String TIER_TOPIC_NAME = "_confluent-tier-state";
    public static final String CLUSTER_LINK_METADATA_TOPIC = "_confluent-link-metadata";
    public static final String QUOTA_TOPIC_NAME = "_confluent-quotas";
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    private static final Set<String> INTERNAL_TOPICS = Collections.unmodifiableSet(Utils.mkSet("__consumer_offsets", "__transaction_state", "_confluent-tier-state", "_confluent-link-metadata", "_confluent-quotas"));
    private static final int MAX_NAME_LENGTH = 249;

    public static void validate(String topic) {
        Topic.validate(topic, "Topic name", message -> {
            throw new InvalidTopicException((String)message);
        });
    }

    public static void validate(String name, String logPrefix, Consumer<String> throwableConsumer) {
        if (name.isEmpty()) {
            throwableConsumer.accept(logPrefix + " is illegal, it can't be empty");
        }
        if (".".equals(name) || "..".equals(name)) {
            throwableConsumer.accept(logPrefix + " cannot be \".\" or \"..\"");
        }
        if (name.length() > 249) {
            throwableConsumer.accept(logPrefix + " is illegal, it can't be longer than " + 249 + " characters, " + logPrefix + ": " + name);
        }
        if (!Topic.containsValidPattern(name)) {
            throwableConsumer.accept(logPrefix + " \"" + name + "\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
        }
    }

    public static boolean isInternal(String topic) {
        return INTERNAL_TOPICS.contains(topic) || topic.startsWith(TIER_TOPIC_NAME);
    }

    public static boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public static String unifyCollisionChars(String topic) {
        return topic.replace('.', '_');
    }

    public static boolean hasCollision(String topicA, String topicB) {
        return Topic.unifyCollisionChars(topicA).equals(Topic.unifyCollisionChars(topicB));
    }

    public static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

