/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;

public class ClusterLinkDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String remoteClusterId;
    private final String localClusterId;
    private final Collection<String> topics;
    private final LinkState linkState;
    private final LinkMode linkMode;
    private final ConnectionMode connectionMode;

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode) {
        this.linkName = Objects.requireNonNull(linkName, "linkName");
        this.linkId = Objects.requireNonNull(linkId, "linkId");
        this.remoteClusterId = remoteClusterId;
        this.localClusterId = localClusterId;
        this.topics = topics;
        this.linkState = linkState;
        this.linkMode = linkMode;
        this.connectionMode = connectionMode;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid clusterLinkId() {
        return this.linkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public Optional<Collection<String>> topics() {
        return Optional.ofNullable(this.topics);
    }

    public LinkState linkState() {
        return this.linkState;
    }

    public LinkMode linkMode() {
        return this.linkMode;
    }

    public ConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkDescription that = (ClusterLinkDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.remoteClusterId, that.remoteClusterId) && Objects.equals(this.localClusterId, that.localClusterId) && Objects.equals(this.topics, that.topics) && Objects.equals((Object)this.linkState, (Object)that.linkState) && Objects.equals((Object)this.linkMode, (Object)that.linkMode) && Objects.equals((Object)this.connectionMode, (Object)that.connectionMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.remoteClusterId, this.localClusterId, this.topics, this.linkState, this.linkMode, this.connectionMode});
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterLinkListing(linkName=").append(this.linkName).append(", linkId=").append(this.linkId).append(", remoteClusterId=").append(this.remoteClusterId).append(", localClusterId=").append(this.localClusterId).append(", linkState=").append((Object)this.linkState).append(", linkMode=").append((Object)this.linkMode).append(", connectionMode=").append((Object)this.connectionMode).append(", topics=").append(this.topics);
        return str.toString();
    }

    public static enum ConnectionMode {
        UNKNOWN(0),
        INBOUND(1),
        OUTBOUND(2);

        private short value;

        private ConnectionMode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static ConnectionMode fromShort(short x) {
            switch (x) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return INBOUND;
                }
                case 2: {
                    return OUTBOUND;
                }
            }
            throw new IllegalStateException("Unhandled connection mode value " + x);
        }
    }

    public static enum LinkMode {
        UNKNOWN(0),
        DESTINATION(1),
        SOURCE(2);

        private short value;

        private LinkMode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static LinkMode fromShort(short x) {
            switch (x) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return DESTINATION;
                }
                case 2: {
                    return SOURCE;
                }
            }
            throw new IllegalStateException("Unhandled link mode value " + x);
        }
    }

    public static enum LinkState {
        ACTIVE(0),
        FAILED(1),
        UNAVAILABLE(2),
        PAUSED(3);

        private short value;

        private LinkState(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static LinkState fromShort(short x) {
            switch (x) {
                case 0: {
                    return ACTIVE;
                }
                case 1: {
                    return FAILED;
                }
                case 2: {
                    return UNAVAILABLE;
                }
                case 3: {
                    return PAUSED;
                }
            }
            throw new IllegalStateException("Unhandled link state value " + x);
        }
    }
}

