/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Set;

public class AlterLeadershipPrioritySpec {
    private final String reason;
    private final Set<Integer> brokerIds;
    private final PriorityOperationEnum priorityOperationEnum;

    public AlterLeadershipPrioritySpec(Set<Integer> brokerIds, PriorityOperationEnum priorityOperationEnum, String reason) {
        this.reason = reason;
        this.brokerIds = brokerIds;
        this.priorityOperationEnum = priorityOperationEnum;
    }

    public String reason() {
        return this.reason;
    }

    public Set<Integer> brokerIds() {
        return this.brokerIds;
    }

    public PriorityOperationEnum priorityOperation() {
        return this.priorityOperationEnum;
    }

    public String toString() {
        return "AlterLeadershipPrioritySpec (reason=" + this.reason + ", brokerIds=" + this.brokerIds + ", priorityOperation=" + (Object)((Object)this.priorityOperationEnum) + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlterLeadershipPrioritySpec)) {
            return false;
        }
        AlterLeadershipPrioritySpec alterLeadershipPrioritySpec = (AlterLeadershipPrioritySpec)o;
        return Objects.equals(this.brokerIds, alterLeadershipPrioritySpec.brokerIds) && Objects.equals(this.reason, alterLeadershipPrioritySpec.reason) && Objects.equals((Object)this.priorityOperationEnum, (Object)alterLeadershipPrioritySpec.priorityOperationEnum);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brokerIds, this.reason, this.priorityOperationEnum});
    }

    public static enum PriorityOperationEnum {
        DEMOTE(0),
        PROMOTE(1);

        private final byte id;

        private PriorityOperationEnum(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }
}

