/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.AbstractSensorBuilder;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class ApiSensorBuilder
extends AbstractSensorBuilder<MetricsBuilderContext, ApiSensors> {
    public static final long EXPIRY_SECONDS = TimeUnit.DAYS.toSeconds(7L);
    private static final String REQUEST_TAG = "request";
    private static final String ERROR_TAG = "error";
    private final ApiKeys apiKey;
    private static final String REQUEST_RATE = "request";
    private static final String REQUEST_BYTE_RATE = "request-byte";
    private static final String RESPONSE_BYTE_RATE = "response-byte";
    private static final String RESPONSE_TIME_NANOS = "response-time-ns";
    private static final String ERROR_COUNT = "error";
    private static final Map<Errors, ErrorCountSensorCreator> ERROR_SENSOR_CREATORS;
    private static final Map<String, AbstractApiSensorCreator> REQUEST_RESPONSE_SENSOR_CREATORS;

    public ApiSensorBuilder(Metrics metrics, MetricsBuilderContext context, ApiKeys apiKey) {
        super(metrics, context);
        this.apiKey = apiKey;
    }

    @Override
    public ApiSensors build() {
        Map<String, Sensor> sensors = this.getOrCreateSuffixedSensors();
        return new ApiSensors(sensors.get("request"), sensors.get(REQUEST_BYTE_RATE), sensors.get(RESPONSE_BYTE_RATE), sensors.get(RESPONSE_TIME_NANOS));
    }

    @Override
    protected String sensorSuffix(String unused, MetricsBuilderContext context) {
        return String.format(":%s-%s%s", "request", this.apiKey.name, context.sensorSuffix());
    }

    @Override
    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        return REQUEST_RESPONSE_SENSOR_CREATORS;
    }

    @Override
    protected <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> sensorCreators, T sensorKey, String sensorName) {
        AbstractApiSensorCreator sensorCreator = (AbstractApiSensorCreator)sensorCreators.get(sensorKey);
        return sensorCreator.createSensor(this.metrics, sensorName, this.context, this.apiKey);
    }

    public void addErrorSensors(ApiSensors apiSensors, Set<Errors> errors) {
        apiSensors.addErrorSensors(this.getOrCreateErrorSensors(errors));
    }

    public Map<Errors, Sensor> getOrCreateErrorSensors(Set<Errors> errors) {
        String sensorSuffix = this.sensorSuffix("", this.context);
        HashMap<Errors, String> sensorsToFind = new HashMap<Errors, String>();
        for (Errors error : errors) {
            String sensorName = String.format("%s:%s-%s%s", "error", "error", error.name(), sensorSuffix);
            sensorsToFind.put(error, sensorName);
        }
        return this.getOrCreateSensors(sensorsToFind, ERROR_SENSOR_CREATORS);
    }

    static {
        REQUEST_RESPONSE_SENSOR_CREATORS = new HashMap<String, AbstractApiSensorCreator>();
        REQUEST_RESPONSE_SENSOR_CREATORS.put("request", new RequestMeterSensorCreator("request", "requests"));
        REQUEST_RESPONSE_SENSOR_CREATORS.put(REQUEST_BYTE_RATE, new RequestSensorCreator(REQUEST_BYTE_RATE, "request bytes", true, true));
        REQUEST_RESPONSE_SENSOR_CREATORS.put(RESPONSE_BYTE_RATE, new RequestSensorCreator(RESPONSE_BYTE_RATE, "response bytes", true, true));
        REQUEST_RESPONSE_SENSOR_CREATORS.put(RESPONSE_TIME_NANOS, new RequestMinMaxAvgSensorCreator(RESPONSE_TIME_NANOS, "request processing time in nanos"));
        ERROR_SENSOR_CREATORS = new EnumMap<Errors, ErrorCountSensorCreator>(Errors.class);
        for (Errors error : Errors.values()) {
            ERROR_SENSOR_CREATORS.put(error, new ErrorCountSensorCreator(error));
        }
    }

    private static class ErrorCountSensorCreator
    extends AbstractApiSensorCreator {
        private final Errors error;

        ErrorCountSensorCreator(Errors error) {
            super("error", "errors");
            this.error = error;
        }

        @Override
        Sensor createSensor(Metrics metrics, String sensorName, MetricsBuilderContext context, ApiKeys apiKey) {
            Sensor sensor = super.createSensor(metrics, sensorName);
            Map<String, String> metricTags = this.metricTags(context, apiKey);
            metricTags.put("error", this.error.name());
            sensor.add(this.createMeter(metrics, context.metricsGroup(), metricTags, this.name, this.descriptiveName));
            return sensor;
        }
    }

    private static class RequestMinMaxAvgSensorCreator
    extends RequestSensorCreator {
        RequestMinMaxAvgSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName, true, false);
        }
    }

    private static class RequestMeterSensorCreator
    extends RequestSensorCreator {
        RequestMeterSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName, false, true);
        }
    }

    private static class RequestSensorCreator
    extends AbstractApiSensorCreator {
        private final boolean toCreateMinMaxAvgMetrics;
        private final boolean toCreateMeterMetrics;

        RequestSensorCreator(String name, String descriptiveName, boolean createMinMaxAvgMetrics, boolean createMeterMetrics) {
            super(name, descriptiveName);
            this.toCreateMinMaxAvgMetrics = createMinMaxAvgMetrics;
            this.toCreateMeterMetrics = createMeterMetrics;
        }

        @Override
        Sensor createSensor(Metrics metrics, String sensorName, MetricsBuilderContext context, ApiKeys apiKey) {
            Sensor sensor = super.createSensor(metrics, sensorName);
            Map<String, String> metricTags = this.metricTags(context, apiKey);
            String group = context.metricsGroup();
            if (this.toCreateMeterMetrics) {
                sensor.add(this.createMeter(metrics, group, metricTags, this.name, this.descriptiveName));
            }
            if (this.toCreateMinMaxAvgMetrics) {
                sensor.add(metrics.metricName(this.name + "-min", group, "The minimum time taken for " + this.descriptiveName, metricTags), new Min());
                sensor.add(metrics.metricName(this.name + "-avg", group, "The average time taken for " + this.descriptiveName, metricTags), new Avg());
                sensor.add(metrics.metricName(this.name + "-max", group, "The maximum time taken for " + this.descriptiveName, metricTags), new Max());
            }
            return sensor;
        }
    }

    private static abstract class AbstractApiSensorCreator
    extends AbstractSensorCreator {
        AbstractApiSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        abstract Sensor createSensor(Metrics var1, String var2, MetricsBuilderContext var3, ApiKeys var4);

        Map<String, String> metricTags(MetricsBuilderContext context, ApiKeys apiKey) {
            Map<String, String> tags = context.metricTags();
            tags.put("request", apiKey.name);
            return tags;
        }
    }
}

