/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetFetchRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(OffsetFetchRequest.class);
    private static final List<OffsetFetchRequestData.OffsetFetchRequestTopic> ALL_TOPIC_PARTITIONS = null;
    private static final List<OffsetFetchRequestData.OffsetFetchRequestTopics> ALL_TOPIC_PARTITIONS_BATCH = null;
    private final OffsetFetchRequestData data;

    public List<TopicPartition> partitions() {
        if (this.isAllPartitions()) {
            return null;
        }
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (OffsetFetchRequestData.OffsetFetchRequestTopic topic : this.data.topics()) {
            for (Integer partitionIndex : topic.partitionIndexes()) {
                partitions.add(new TopicPartition(topic.name(), partitionIndex));
            }
        }
        return partitions;
    }

    public String groupId() {
        return this.data.groupId();
    }

    public boolean requireStable() {
        return this.data.requireStable();
    }

    public Map<String, List<TopicPartition>> groupIdsToPartitions() {
        HashMap<String, List<TopicPartition>> groupIdsToPartitions = new HashMap<String, List<TopicPartition>>();
        for (OffsetFetchRequestData.OffsetFetchRequestGroup group : this.data.groups()) {
            ArrayList<TopicPartition> tpList = null;
            if (group.topics() != ALL_TOPIC_PARTITIONS_BATCH) {
                tpList = new ArrayList<TopicPartition>();
                for (OffsetFetchRequestData.OffsetFetchRequestTopics topic : group.topics()) {
                    for (Integer partitionIndex : topic.partitionIndexes()) {
                        tpList.add(new TopicPartition(topic.name(), partitionIndex));
                    }
                }
            }
            groupIdsToPartitions.put(group.groupId(), tpList);
        }
        return groupIdsToPartitions;
    }

    public Map<String, List<OffsetFetchRequestData.OffsetFetchRequestTopics>> groupIdsToTopics() {
        HashMap<String, List<OffsetFetchRequestData.OffsetFetchRequestTopics>> groupIdsToTopics = new HashMap<String, List<OffsetFetchRequestData.OffsetFetchRequestTopics>>(this.data.groups().size());
        this.data.groups().forEach(g -> groupIdsToTopics.put(g.groupId(), g.topics()));
        return groupIdsToTopics;
    }

    public List<String> groupIds() {
        return this.data.groups().stream().map(OffsetFetchRequestData.OffsetFetchRequestGroup::groupId).collect(Collectors.toList());
    }

    private OffsetFetchRequest(OffsetFetchRequestData data, short version) {
        super(ApiKeys.OFFSET_FETCH, version);
        this.data = data;
    }

    public OffsetFetchResponse getErrorResponse(Errors error) {
        return this.getErrorResponse(0, error);
    }

    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responsePartitions = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        if (this.version() < 2) {
            OffsetFetchResponse.PartitionData partitionError = new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", error);
            for (OffsetFetchRequestData.OffsetFetchRequestTopic topic : this.data.topics()) {
                for (int partitionIndex : topic.partitionIndexes()) {
                    responsePartitions.put(new TopicPartition(topic.name(), partitionIndex), partitionError);
                }
            }
            return new OffsetFetchResponse(error, responsePartitions);
        }
        if (this.version() == 2) {
            return new OffsetFetchResponse(error, responsePartitions);
        }
        if (this.version() >= 3 && this.version() < 8) {
            return new OffsetFetchResponse(throttleTimeMs, error, responsePartitions);
        }
        List<String> groupIds = this.groupIds();
        HashMap<String, Errors> errorsMap = new HashMap<String, Errors>(groupIds.size());
        HashMap<String, Map<TopicPartition, OffsetFetchResponse.PartitionData>> partitionMap = new HashMap<String, Map<TopicPartition, OffsetFetchResponse.PartitionData>>(groupIds.size());
        for (String g : groupIds) {
            errorsMap.put(g, error);
            partitionMap.put(g, responsePartitions);
        }
        return new OffsetFetchResponse(throttleTimeMs, errorsMap, partitionMap);
    }

    @Override
    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(throttleTimeMs, Errors.forException(e));
    }

    public static OffsetFetchRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new OffsetFetchRequest(new OffsetFetchRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public boolean isAllPartitions() {
        return this.data.topics() == ALL_TOPIC_PARTITIONS;
    }

    public boolean isAllPartitionsForGroup(String groupId) {
        OffsetFetchRequestData.OffsetFetchRequestGroup group = (OffsetFetchRequestData.OffsetFetchRequestGroup)this.data.groups().stream().filter(g -> g.groupId().equals(groupId)).collect(Collectors.toList()).get(0);
        return group.topics() == ALL_TOPIC_PARTITIONS_BATCH;
    }

    @Override
    public OffsetFetchRequestData data() {
        return this.data;
    }

    public static class NoBatchedOffsetFetchRequestException
    extends UnsupportedVersionException {
        private static final long serialVersionUID = 1L;

        public NoBatchedOffsetFetchRequestException(String message) {
            super(message);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetFetchRequest> {
        public final OffsetFetchRequestData data;
        private final boolean throwOnFetchStableOffsetsUnsupported;

        public Builder(String groupId, boolean requireStable, List<TopicPartition> partitions, boolean throwOnFetchStableOffsetsUnsupported) {
            super(ApiKeys.OFFSET_FETCH);
            ArrayList topics;
            if (partitions != null) {
                HashMap<String, OffsetFetchRequestData.OffsetFetchRequestTopic> offsetFetchRequestTopicMap = new HashMap<String, OffsetFetchRequestData.OffsetFetchRequestTopic>();
                for (TopicPartition topicPartition : partitions) {
                    String topicName = topicPartition.topic();
                    OffsetFetchRequestData.OffsetFetchRequestTopic topic = offsetFetchRequestTopicMap.getOrDefault(topicName, new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(topicName));
                    topic.partitionIndexes().add(topicPartition.partition());
                    offsetFetchRequestTopicMap.put(topicName, topic);
                }
                topics = new ArrayList(offsetFetchRequestTopicMap.values());
            } else {
                topics = ALL_TOPIC_PARTITIONS;
            }
            this.data = new OffsetFetchRequestData().setGroupId(groupId).setRequireStable(requireStable).setTopics(topics);
            this.throwOnFetchStableOffsetsUnsupported = throwOnFetchStableOffsetsUnsupported;
        }

        boolean isAllTopicPartitions() {
            return this.data.topics() == ALL_TOPIC_PARTITIONS;
        }

        public Builder(Map<String, List<TopicPartition>> groupIdToTopicPartitionMap, boolean requireStable, boolean throwOnFetchStableOffsetsUnsupported) {
            super(ApiKeys.OFFSET_FETCH);
            ArrayList<OffsetFetchRequestData.OffsetFetchRequestGroup> groups = new ArrayList<OffsetFetchRequestData.OffsetFetchRequestGroup>();
            for (Map.Entry<String, List<TopicPartition>> entry : groupIdToTopicPartitionMap.entrySet()) {
                ArrayList topics;
                String groupName = entry.getKey();
                List<TopicPartition> tpList = entry.getValue();
                if (tpList != null) {
                    HashMap<String, OffsetFetchRequestData.OffsetFetchRequestTopics> offsetFetchRequestTopicMap = new HashMap<String, OffsetFetchRequestData.OffsetFetchRequestTopics>();
                    for (TopicPartition topicPartition : tpList) {
                        String topicName = topicPartition.topic();
                        OffsetFetchRequestData.OffsetFetchRequestTopics topic = offsetFetchRequestTopicMap.getOrDefault(topicName, new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topicName));
                        topic.partitionIndexes().add(topicPartition.partition());
                        offsetFetchRequestTopicMap.put(topicName, topic);
                    }
                    topics = new ArrayList(offsetFetchRequestTopicMap.values());
                } else {
                    topics = ALL_TOPIC_PARTITIONS_BATCH;
                }
                groups.add(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupName).setTopics(topics));
            }
            this.data = new OffsetFetchRequestData().setGroups(groups).setRequireStable(requireStable);
            this.throwOnFetchStableOffsetsUnsupported = throwOnFetchStableOffsetsUnsupported;
        }

        @Override
        public OffsetFetchRequest build(short version) {
            if (this.isAllTopicPartitions() && version < 2) {
                throw new UnsupportedVersionException("The broker only supports OffsetFetchRequest v" + version + ", but we need v2 or newer to request all topic partitions.");
            }
            if (this.data.groups().size() > 1 && version < 8) {
                throw new NoBatchedOffsetFetchRequestException("Broker does not support batching groups for fetch offset request on version " + version);
            }
            if (this.data.requireStable() && version < 7) {
                if (this.throwOnFetchStableOffsetsUnsupported) {
                    throw new UnsupportedVersionException("Broker unexpectedly doesn't support requireStable flag on version " + version);
                }
                log.trace("Fallback the requireStable flag to false as broker only supports OffsetFetchRequest version {}. Need v7 or newer to enable this feature", (Object)version);
                this.data.setRequireStable(false);
            }
            if (version < 8) {
                OffsetFetchRequestData oldDataFormat = null;
                if (!this.data.groups().isEmpty()) {
                    OffsetFetchRequestData.OffsetFetchRequestGroup group = this.data.groups().get(0);
                    String groupName = group.groupId();
                    List<OffsetFetchRequestData.OffsetFetchRequestTopics> topics = group.topics();
                    List oldFormatTopics = null;
                    if (topics != null) {
                        oldFormatTopics = topics.stream().map(t -> new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(t.name()).setPartitionIndexes(t.partitionIndexes())).collect(Collectors.toList());
                    }
                    oldDataFormat = new OffsetFetchRequestData().setGroupId(groupName).setTopics(oldFormatTopics).setRequireStable(this.data.requireStable());
                }
                return new OffsetFetchRequest(oldDataFormat == null ? this.data : oldDataFormat, version);
            }
            if (this.data.groups().isEmpty()) {
                String groupName = this.data.groupId();
                List<OffsetFetchRequestData.OffsetFetchRequestTopic> oldFormatTopics = this.data.topics();
                List<OffsetFetchRequestData.OffsetFetchRequestTopics> topics = null;
                if (oldFormatTopics != null) {
                    topics = oldFormatTopics.stream().map(t -> new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(t.name()).setPartitionIndexes(t.partitionIndexes())).collect(Collectors.toList());
                }
                OffsetFetchRequestData convertedDataFormat = new OffsetFetchRequestData().setGroups(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupName).setTopics(topics))).setRequireStable(this.data.requireStable());
                return new OffsetFetchRequest(convertedDataFormat, version);
            }
            return new OffsetFetchRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

