/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreateClusterLinksResponse
extends AbstractResponse {
    private final CreateClusterLinksResponseData data;

    public CreateClusterLinksResponse(Map<String, ApiError> results, int throttleTimeMs) {
        super(ApiKeys.CREATE_CLUSTER_LINKS);
        ArrayList<CreateClusterLinksResponseData.EntryData> entryDatas = new ArrayList<CreateClusterLinksResponseData.EntryData>(results.size());
        for (Map.Entry<String, ApiError> resultsEntry : results.entrySet()) {
            ApiError e = resultsEntry.getValue();
            entryDatas.add(new CreateClusterLinksResponseData.EntryData().setErrorCode(e.error().code()).setErrorMessage(e.message()).setLinkName(resultsEntry.getKey()));
        }
        this.data = new CreateClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public CreateClusterLinksResponse(Collection<String> linkNames, int throttleTimeMs, Throwable e) {
        super(ApiKeys.CREATE_CLUSTER_LINKS);
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        ArrayList<CreateClusterLinksResponseData.EntryData> entryDatas = new ArrayList<CreateClusterLinksResponseData.EntryData>(linkNames.size());
        for (String linkName : linkNames) {
            entryDatas.add(new CreateClusterLinksResponseData.EntryData().setErrorCode(errorCode).setErrorMessage(errorMessage).setLinkName(linkName));
        }
        this.data = new CreateClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public CreateClusterLinksResponse(CreateClusterLinksResponseData data) {
        super(ApiKeys.CREATE_CLUSTER_LINKS);
        this.data = data;
    }

    public void complete(Map<String, KafkaFutureImpl<Void>> results) {
        for (CreateClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            String linkName = entryData.linkName();
            KafkaFutureImpl<Void> future = results.get(linkName);
            if (future == null) {
                throw new IllegalArgumentException("Result must contain link with name: " + linkName);
            }
            Errors error = Errors.forCode(entryData.errorCode());
            if (error == Errors.NONE) {
                future.complete(null);
                continue;
            }
            future.completeExceptionally(error.exception(entryData.errorMessage()));
        }
    }

    @Override
    public CreateClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (CreateClusterLinksResponseData.EntryData entry : this.data.entries()) {
            Errors error = Errors.forCode(entry.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    public static CreateClusterLinksResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new CreateClusterLinksResponse(new CreateClusterLinksResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

