/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ReportQuotaConsumptionRequestData
implements ApiMessage {
    int brokerId;
    List<EntryData> entries;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID that is reporting quota consumption."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_0), "The quota consumption entries to report. Can be null if no traffic."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ReportQuotaConsumptionRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ReportQuotaConsumptionRequestData() {
        this.brokerId = 0;
        this.entries = new ArrayList<EntryData>(0);
    }

    @Override
    public short apiKey() {
        return 10017;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.brokerId = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.entries = null;
        } else {
            ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new EntryData(_readable, _version, _context));
            }
            this.entries = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        if (this.entries == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.entries.size() + 1);
            for (EntryData entriesElement : this.entries) {
                entriesElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (this.entries == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.entries.size() + 1));
            for (EntryData entriesElement : this.entries) {
                entriesElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReportQuotaConsumptionRequestData)) {
            return false;
        }
        ReportQuotaConsumptionRequestData other = (ReportQuotaConsumptionRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        return hashCode;
    }

    @Override
    public ReportQuotaConsumptionRequestData duplicate() {
        ReportQuotaConsumptionRequestData _duplicate = new ReportQuotaConsumptionRequestData();
        _duplicate.brokerId = this.brokerId;
        if (this.entries == null) {
            _duplicate.entries = null;
        } else {
            ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
            for (EntryData _element : this.entries) {
                newEntries.add(_element.duplicate());
            }
            _duplicate.entries = newEntries;
        }
        return _duplicate;
    }

    public String toString() {
        return "ReportQuotaConsumptionRequestData(brokerId=" + this.brokerId + ", entries=" + (this.entries == null ? "null" : MessageUtil.deepToString(this.entries.iterator())) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ReportQuotaConsumptionRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public ReportQuotaConsumptionRequestData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    public static class ConsumptionData
    implements Message {
        String quotaType;
        double usage;
        boolean throttled;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("quota_type", Type.COMPACT_STRING, "The quota type."), new Field("usage", Type.FLOAT64, "Consumption Rate."), new Field("throttled", Type.BOOLEAN, "Whether it's being throttled by a computed quota."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ConsumptionData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ConsumptionData() {
            this.quotaType = "";
            this.usage = 0.0;
            this.throttled = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ConsumptionData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field quotaType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field quotaType had invalid length " + length);
            }
            this.quotaType = _readable.readString(length);
            this.usage = _readable.readDouble();
            this.throttled = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.quotaType);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeDouble(this.usage);
            _writable.writeByte(this.throttled ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ConsumptionData");
            }
            byte[] _stringBytes = this.quotaType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'quotaType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.quotaType, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(8);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConsumptionData)) {
                return false;
            }
            ConsumptionData other = (ConsumptionData)obj;
            if (this.quotaType == null ? other.quotaType != null : !this.quotaType.equals(other.quotaType)) {
                return false;
            }
            if (this.usage != other.usage) {
                return false;
            }
            if (this.throttled != other.throttled) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.quotaType == null ? 0 : this.quotaType.hashCode());
            hashCode = 31 * hashCode + Double.hashCode(this.usage);
            hashCode = 31 * hashCode + (this.throttled ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public ConsumptionData duplicate() {
            ConsumptionData _duplicate = new ConsumptionData();
            _duplicate.quotaType = this.quotaType;
            _duplicate.usage = this.usage;
            _duplicate.throttled = this.throttled;
            return _duplicate;
        }

        public String toString() {
            return "ConsumptionData(quotaType=" + (this.quotaType == null ? "null" : "'" + this.quotaType.toString() + "'") + ", usage=" + this.usage + ", throttled=" + (this.throttled ? "true" : "false") + ")";
        }

        public String quotaType() {
            return this.quotaType;
        }

        public double usage() {
            return this.usage;
        }

        public boolean throttled() {
            return this.throttled;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ConsumptionData setQuotaType(String v) {
            this.quotaType = v;
            return this;
        }

        public ConsumptionData setUsage(double v) {
            this.usage = v;
            return this;
        }

        public ConsumptionData setThrottled(boolean v) {
            this.throttled = v;
            return this;
        }
    }

    public static class EntityData
    implements Message {
        String entityType;
        String entityName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("entity_type", Type.COMPACT_STRING, "The entity type."), new Field("entity_name", Type.COMPACT_STRING, "The name of the entity"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntityData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EntityData() {
            this.entityType = "";
            this.entityName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntityData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field entityType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field entityType had invalid length " + length);
            }
            this.entityType = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field entityName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field entityName had invalid length " + length);
            }
            this.entityName = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.entityType);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.entityName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntityData");
            }
            byte[] _stringBytes = this.entityType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'entityType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.entityType, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.entityName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'entityName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.entityName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityData)) {
                return false;
            }
            EntityData other = (EntityData)obj;
            if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
                return false;
            }
            if (this.entityName == null ? other.entityName != null : !this.entityName.equals(other.entityName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entityType == null ? 0 : this.entityType.hashCode());
            hashCode = 31 * hashCode + (this.entityName == null ? 0 : this.entityName.hashCode());
            return hashCode;
        }

        @Override
        public EntityData duplicate() {
            EntityData _duplicate = new EntityData();
            _duplicate.entityType = this.entityType;
            _duplicate.entityName = this.entityName;
            return _duplicate;
        }

        public String toString() {
            return "EntityData(entityType=" + (this.entityType == null ? "null" : "'" + this.entityType.toString() + "'") + ", entityName=" + (this.entityName == null ? "null" : "'" + this.entityName.toString() + "'") + ")";
        }

        public String entityType() {
            return this.entityType;
        }

        public String entityName() {
            return this.entityName;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntityData setEntityType(String v) {
            this.entityType = v;
            return this;
        }

        public EntityData setEntityName(String v) {
            this.entityName = v;
            return this;
        }
    }

    public static class EntryData
    implements Message {
        List<EntityData> entity;
        List<ConsumptionData> consumptions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("entity", new CompactArrayOf(EntityData.SCHEMA_0), "The quota entity to report usage."), new Field("consumptions", new CompactArrayOf(ConsumptionData.SCHEMA_0), "An individual quota consumption entry to report."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntryData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EntryData() {
            this.entity = new ArrayList<EntityData>(0);
            this.consumptions = new ArrayList<ConsumptionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field entity was serialized as null");
            }
            ArrayList<EntityData> newCollection = new ArrayList<EntityData>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new EntityData(_readable, _version, _context));
            }
            this.entity = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field consumptions was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((EntityData)((Object)new ConsumptionData(_readable, _version, _context)));
            }
            this.consumptions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUnsignedVarint(this.entity.size() + 1);
            for (EntityData entityElement : this.entity) {
                entityElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeUnsignedVarint(this.consumptions.size() + 1);
            for (ConsumptionData consumptionsElement : this.consumptions) {
                consumptionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.entity.size() + 1));
            for (EntityData entityElement : this.entity) {
                entityElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.consumptions.size() + 1));
            for (ConsumptionData consumptionsElement : this.consumptions) {
                consumptionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
                return false;
            }
            if (this.consumptions == null ? other.consumptions != null : !this.consumptions.equals(other.consumptions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entity == null ? 0 : this.entity.hashCode());
            hashCode = 31 * hashCode + (this.consumptions == null ? 0 : this.consumptions.hashCode());
            return hashCode;
        }

        @Override
        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            ArrayList<EntityData> newEntity = new ArrayList<EntityData>(this.entity.size());
            for (EntityData _element : this.entity) {
                newEntity.add(_element.duplicate());
            }
            _duplicate.entity = newEntity;
            ArrayList<ConsumptionData> newConsumptions = new ArrayList<ConsumptionData>(this.consumptions.size());
            for (ConsumptionData _element : this.consumptions) {
                newConsumptions.add(_element.duplicate());
            }
            _duplicate.consumptions = newConsumptions;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(entity=" + MessageUtil.deepToString(this.entity.iterator()) + ", consumptions=" + MessageUtil.deepToString(this.consumptions.iterator()) + ")";
        }

        public List<EntityData> entity() {
            return this.entity;
        }

        public List<ConsumptionData> consumptions() {
            return this.consumptions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setEntity(List<EntityData> v) {
            this.entity = v;
            return this;
        }

        public EntryData setConsumptions(List<ConsumptionData> v) {
            this.consumptions = v;
            return this;
        }
    }
}

