/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DeleteClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class DeleteClusterLinksResponse
extends AbstractResponse {
    private final DeleteClusterLinksResponseData data;

    public DeleteClusterLinksResponse(Map<String, ApiError> results, int throttleTimeMs) {
        super(ApiKeys.DELETE_CLUSTER_LINKS);
        ArrayList<DeleteClusterLinksResponseData.EntryData> entryDatas = new ArrayList<DeleteClusterLinksResponseData.EntryData>(results.size());
        for (Map.Entry<String, ApiError> resultsEntry : results.entrySet()) {
            ApiError e = resultsEntry.getValue();
            entryDatas.add(new DeleteClusterLinksResponseData.EntryData().setErrorCode(e.error().code()).setErrorMessage(e.message()).setLinkName(resultsEntry.getKey()));
        }
        this.data = new DeleteClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public DeleteClusterLinksResponse(Collection<String> linkNames, int throttleTimeMs, Throwable e) {
        super(ApiKeys.DELETE_CLUSTER_LINKS);
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        ArrayList<DeleteClusterLinksResponseData.EntryData> entryDatas = new ArrayList<DeleteClusterLinksResponseData.EntryData>(linkNames.size());
        for (String linkName : linkNames) {
            entryDatas.add(new DeleteClusterLinksResponseData.EntryData().setErrorCode(errorCode).setErrorMessage(errorMessage).setLinkName(linkName));
        }
        this.data = new DeleteClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public DeleteClusterLinksResponse(DeleteClusterLinksResponseData data) {
        super(ApiKeys.DELETE_CLUSTER_LINKS);
        this.data = data;
    }

    public void complete(Map<String, KafkaFutureImpl<Void>> results) {
        for (DeleteClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            String linkName = entryData.linkName();
            KafkaFutureImpl<Void> future = results.get(linkName);
            if (future == null) {
                throw new IllegalArgumentException("Result must contain link with name: " + linkName);
            }
            Errors error = Errors.forCode(entryData.errorCode());
            if (error == Errors.NONE) {
                future.complete(null);
                continue;
            }
            future.completeExceptionally(error.exception(entryData.errorMessage()));
        }
    }

    @Override
    public DeleteClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (DeleteClusterLinksResponseData.EntryData entry : this.data.entries()) {
            Errors error = Errors.forCode(entry.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    public static DeleteClusterLinksResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DeleteClusterLinksResponse(new DeleteClusterLinksResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

