/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StopReplicaRequestData
implements ApiMessage {
    int controllerId;
    int controllerEpoch;
    long brokerEpoch;
    boolean deletePartitions;
    List<StopReplicaPartitionV0> ungroupedPartitions;
    List<StopReplicaTopicV1> topics;
    List<StopReplicaTopicState> topicStates;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("delete_partitions", Type.BOOLEAN, "Whether these partitions should be deleted."), new Field("ungrouped_partitions", new ArrayOf(StopReplicaPartitionV0.SCHEMA_0), "The partitions to stop."));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("delete_partitions", Type.BOOLEAN, "Whether these partitions should be deleted."), new Field("topics", new ArrayOf(StopReplicaTopicV1.SCHEMA_1), "The topics to stop."));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("delete_partitions", Type.BOOLEAN, "Whether these partitions should be deleted."), new Field("topics", new CompactArrayOf(StopReplicaTopicV1.SCHEMA_2), "The topics to stop."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new CompactArrayOf(StopReplicaTopicState.SCHEMA_3), "Each topic."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public StopReplicaRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public StopReplicaRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.deletePartitions = false;
        this.ungroupedPartitions = new ArrayList<StopReplicaPartitionV0>(0);
        this.topics = new ArrayList<StopReplicaTopicV1>(0);
        this.topicStates = new ArrayList<StopReplicaTopicState>(0);
    }

    @Override
    public short apiKey() {
        return 5;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<StopReplicaPartitionV0> newCollection;
        int arrayLength;
        this.controllerId = _readable.readInt();
        this.controllerEpoch = _readable.readInt();
        this.brokerEpoch = _version >= 1 ? _readable.readLong() : -1L;
        this.deletePartitions = _version <= 2 ? _readable.readByte() != 0 : false;
        if (_version <= 0) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ungroupedPartitions was serialized as null");
            }
            newCollection = new ArrayList<StopReplicaPartitionV0>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new StopReplicaPartitionV0(_readable, _version, _context));
            }
            this.ungroupedPartitions = newCollection;
        } else {
            this.ungroupedPartitions = new ArrayList<StopReplicaPartitionV0>(0);
        }
        if (_version >= 1 && _version <= 2) {
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((StopReplicaPartitionV0)((Object)new StopReplicaTopicV1(_readable, _version, _context)));
                }
                this.topics = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((StopReplicaPartitionV0)((Object)new StopReplicaTopicV1(_readable, _version, _context)));
                }
                this.topics = newCollection;
            }
        } else {
            this.topics = new ArrayList<StopReplicaTopicV1>(0);
        }
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicStates was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((StopReplicaPartitionV0)((Object)new StopReplicaTopicState(_readable, _version, _context)));
            }
            this.topicStates = newCollection;
        } else {
            this.topicStates = new ArrayList<StopReplicaTopicState>(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        _writable.writeInt(this.controllerEpoch);
        if (_version >= 1) {
            _writable.writeLong(this.brokerEpoch);
        }
        if (_version <= 2) {
            _writable.writeByte(this.deletePartitions ? (byte)1 : 0);
        } else if (this.deletePartitions) {
            throw new UnsupportedVersionException("Attempted to write a non-default deletePartitions at version " + _version);
        }
        if (_version <= 0) {
            _writable.writeInt(this.ungroupedPartitions.size());
            for (StopReplicaPartitionV0 ungroupedPartitionsElement : this.ungroupedPartitions) {
                ungroupedPartitionsElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.ungroupedPartitions.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitions at version " + _version);
        }
        if (_version >= 1 && _version <= 2) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                for (StopReplicaTopicV1 topicsElement : this.topics) {
                    topicsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.topics.size());
                for (StopReplicaTopicV1 topicsElement : this.topics) {
                    topicsElement.write(_writable, _cache, _version, _context);
                }
            }
        } else if (!this.topics.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topics at version " + _version);
        }
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.topicStates.size() + 1);
            for (StopReplicaTopicState topicStatesElement : this.topicStates) {
                topicStatesElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        if (_version >= 1) {
            _size.addBytes(8);
        }
        if (_version <= 2) {
            _size.addBytes(1);
        }
        if (_version <= 0) {
            _size.addBytes(4);
            for (StopReplicaPartitionV0 ungroupedPartitionsElement : this.ungroupedPartitions) {
                ungroupedPartitionsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (_version >= 1 && _version <= 2) {
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (StopReplicaTopicV1 topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicStates.size() + 1));
            for (StopReplicaTopicState topicStatesElement : this.topicStates) {
                topicStatesElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StopReplicaRequestData)) {
            return false;
        }
        StopReplicaRequestData other = (StopReplicaRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.deletePartitions != other.deletePartitions) {
            return false;
        }
        if (this.ungroupedPartitions == null ? other.ungroupedPartitions != null : !this.ungroupedPartitions.equals(other.ungroupedPartitions)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.deletePartitions ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.ungroupedPartitions == null ? 0 : this.ungroupedPartitions.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        return hashCode;
    }

    @Override
    public StopReplicaRequestData duplicate() {
        StopReplicaRequestData _duplicate = new StopReplicaRequestData();
        _duplicate.controllerId = this.controllerId;
        _duplicate.controllerEpoch = this.controllerEpoch;
        _duplicate.brokerEpoch = this.brokerEpoch;
        _duplicate.deletePartitions = this.deletePartitions;
        ArrayList<StopReplicaPartitionV0> newUngroupedPartitions = new ArrayList<StopReplicaPartitionV0>(this.ungroupedPartitions.size());
        for (StopReplicaPartitionV0 stopReplicaPartitionV0 : this.ungroupedPartitions) {
            newUngroupedPartitions.add(stopReplicaPartitionV0.duplicate());
        }
        _duplicate.ungroupedPartitions = newUngroupedPartitions;
        ArrayList<StopReplicaTopicV1> newTopics = new ArrayList<StopReplicaTopicV1>(this.topics.size());
        for (StopReplicaTopicV1 _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        ArrayList<StopReplicaTopicState> arrayList = new ArrayList<StopReplicaTopicState>(this.topicStates.size());
        for (StopReplicaTopicState _element : this.topicStates) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.topicStates = arrayList;
        return _duplicate;
    }

    public String toString() {
        return "StopReplicaRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", deletePartitions=" + (this.deletePartitions ? "true" : "false") + ", ungroupedPartitions=" + MessageUtil.deepToString(this.ungroupedPartitions.iterator()) + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public boolean deletePartitions() {
        return this.deletePartitions;
    }

    public List<StopReplicaPartitionV0> ungroupedPartitions() {
        return this.ungroupedPartitions;
    }

    public List<StopReplicaTopicV1> topics() {
        return this.topics;
    }

    public List<StopReplicaTopicState> topicStates() {
        return this.topicStates;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StopReplicaRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public StopReplicaRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public StopReplicaRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public StopReplicaRequestData setDeletePartitions(boolean v) {
        this.deletePartitions = v;
        return this;
    }

    public StopReplicaRequestData setUngroupedPartitions(List<StopReplicaPartitionV0> v) {
        this.ungroupedPartitions = v;
        return this;
    }

    public StopReplicaRequestData setTopics(List<StopReplicaTopicV1> v) {
        this.topics = v;
        return this;
    }

    public StopReplicaRequestData setTopicStates(List<StopReplicaTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public static class StopReplicaPartitionState
    implements Message {
        int partitionIndex;
        int leaderEpoch;
        boolean deletePartition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("delete_partition", Type.BOOLEAN, "Whether this partition should be deleted."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public StopReplicaPartitionState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopReplicaPartitionState() {
            this.partitionIndex = 0;
            this.leaderEpoch = -1;
            this.deletePartition = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 3;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopReplicaPartitionState");
            }
            this.partitionIndex = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this.deletePartition = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.leaderEpoch);
            _writable.writeByte(this.deletePartition ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StopReplicaPartitionState");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaPartitionState)) {
                return false;
            }
            StopReplicaPartitionState other = (StopReplicaPartitionState)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.deletePartition != other.deletePartition) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.deletePartition ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public StopReplicaPartitionState duplicate() {
            StopReplicaPartitionState _duplicate = new StopReplicaPartitionState();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.deletePartition = this.deletePartition;
            return _duplicate;
        }

        public String toString() {
            return "StopReplicaPartitionState(partitionIndex=" + this.partitionIndex + ", leaderEpoch=" + this.leaderEpoch + ", deletePartition=" + (this.deletePartition ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public boolean deletePartition() {
            return this.deletePartition;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopReplicaPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public StopReplicaPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public StopReplicaPartitionState setDeletePartition(boolean v) {
            this.deletePartition = v;
            return this;
        }
    }

    public static class StopReplicaTopicState
    implements Message {
        String topicName;
        List<StopReplicaPartitionState> partitionStates;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_3 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_states", new CompactArrayOf(StopReplicaPartitionState.SCHEMA_3), "The state of each partition"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public StopReplicaTopicState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopReplicaTopicState() {
            this.topicName = "";
            this.partitionStates = new ArrayList<StopReplicaPartitionState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopReplicaTopicState");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionStates was serialized as null");
            }
            ArrayList<StopReplicaPartitionState> newCollection = new ArrayList<StopReplicaPartitionState>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new StopReplicaPartitionState(_readable, _version, _context));
            }
            this.partitionStates = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopReplicaTopicState");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitionStates.size() + 1);
            _stringBytes = this.partitionStates.iterator();
            while (_stringBytes.hasNext()) {
                StopReplicaPartitionState partitionStatesElement = (StopReplicaPartitionState)_stringBytes.next();
                partitionStatesElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StopReplicaTopicState");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionStates.size() + 1));
            for (StopReplicaPartitionState partitionStatesElement : this.partitionStates) {
                partitionStatesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaTopicState)) {
                return false;
            }
            StopReplicaTopicState other = (StopReplicaTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        @Override
        public StopReplicaTopicState duplicate() {
            StopReplicaTopicState _duplicate = new StopReplicaTopicState();
            _duplicate.topicName = this.topicName;
            ArrayList<StopReplicaPartitionState> newPartitionStates = new ArrayList<StopReplicaPartitionState>(this.partitionStates.size());
            for (StopReplicaPartitionState _element : this.partitionStates) {
                newPartitionStates.add(_element.duplicate());
            }
            _duplicate.partitionStates = newPartitionStates;
            return _duplicate;
        }

        public String toString() {
            return "StopReplicaTopicState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<StopReplicaPartitionState> partitionStates() {
            return this.partitionStates;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopReplicaTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public StopReplicaTopicState setPartitionStates(List<StopReplicaPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }

    public static class StopReplicaTopicV1
    implements Message {
        String name;
        List<Integer> partitionIndexes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partition_indexes", new ArrayOf(Type.INT32), "The partition indexes."));
        public static final Schema SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partition_indexes", new CompactArrayOf(Type.INT32), "The partition indexes."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public StopReplicaTopicV1(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopReplicaTopicV1() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndexes was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndexes = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1 || _version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopReplicaTopicV1");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitionIndexes.size() + 1);
            } else {
                _writable.writeInt(this.partitionIndexes.size());
            }
            _stringBytes = this.partitionIndexes.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexesElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionIndexes.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitionIndexes.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaTopicV1)) {
                return false;
            }
            StopReplicaTopicV1 other = (StopReplicaTopicV1)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        @Override
        public StopReplicaTopicV1 duplicate() {
            StopReplicaTopicV1 _duplicate = new StopReplicaTopicV1();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitionIndexes = new ArrayList<Integer>(this.partitionIndexes.size());
            for (Integer _element : this.partitionIndexes) {
                newPartitionIndexes.add(_element);
            }
            _duplicate.partitionIndexes = newPartitionIndexes;
            return _duplicate;
        }

        public String toString() {
            return "StopReplicaTopicV1(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopReplicaTopicV1 setName(String v) {
            this.name = v;
            return this;
        }

        public StopReplicaTopicV1 setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }
    }

    public static class StopReplicaPartitionV0
    implements Message {
        String topicName;
        int partitionIndex;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public StopReplicaPartitionV0(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopReplicaPartitionV0() {
            this.topicName = "";
            this.partitionIndex = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.partitionIndex = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopReplicaPartitionV0");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.partitionIndex);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaPartitionV0)) {
                return false;
            }
            StopReplicaPartitionV0 other = (StopReplicaPartitionV0)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public StopReplicaPartitionV0 duplicate() {
            StopReplicaPartitionV0 _duplicate = new StopReplicaPartitionV0();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            return _duplicate;
        }

        public String toString() {
            return "StopReplicaPartitionV0(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopReplicaPartitionV0 setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public StopReplicaPartitionV0 setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }
    }
}

