/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.authenticator.FileBasedDynamicCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedDynamicPlainLoginCallbackHandler
extends DynamicPlainLoginCallbackHandler
implements FileBasedDynamicCallbackHandler {
    private static final String DEFAULT_USERNAME_CONFIG = "username";
    private static final String DEFAULT_PASSWORD_CONFIG = "password";
    public static final String CREDENTIALS_PATH = "credentials_path";
    private static final Logger log = LoggerFactory.getLogger(FileBasedDynamicPlainLoginCallbackHandler.class);
    private File configFile;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        log.debug("Configuring file-based SASL/PLAIN login callback handler");
        if (!"PLAIN".equals(saslMechanism)) {
            throw new InvalidConfigurationException("Unexpected configuration with SASL mechanism " + saslMechanism);
        }
        if (jaasConfigEntries.size() != 1) {
            throw new InvalidConfigurationException("Only one JAAS configuration entry supported by this callback handler");
        }
        Map<String, ?> options = jaasConfigEntries.get(0).getOptions();
        this.usernameConfig = (String)options.get("username_config");
        this.passwordConfig = (String)options.get("password_config");
        if (this.usernameConfig == null || this.usernameConfig.isEmpty()) {
            this.usernameConfig = DEFAULT_USERNAME_CONFIG;
        }
        if (this.passwordConfig == null || this.passwordConfig.isEmpty()) {
            this.passwordConfig = DEFAULT_PASSWORD_CONFIG;
        }
        if (!options.containsKey(CREDENTIALS_PATH)) {
            throw new InvalidConfigurationException("JAAS option 'credentials_path' must be specified for FileBasedDynamicPlainLoginCallbackHandler");
        }
        this.configFile = new File((String)options.get(CREDENTIALS_PATH));
    }

    @Override
    public File configFile() {
        return this.configFile;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.validateReconfiguration(configs);
        this.configureCredential(configs);
    }
}

