/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeMirrorsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeMirrorsResponse
extends AbstractResponse {
    private final DescribeMirrorsResponseData data;

    public DescribeMirrorsResponse(DescribeMirrorsResponseData data) {
        super(ApiKeys.DESCRIBE_MIRRORS);
        this.data = data;
    }

    public DescribeMirrorsResponse(Collection<String> topics, int throttleTimeMs, Throwable e) {
        super(ApiKeys.DESCRIBE_MIRRORS);
        Errors error = Errors.forException(e);
        ArrayList<DescribeMirrorsResponseData.TopicData> topicDatas = new ArrayList<DescribeMirrorsResponseData.TopicData>(topics.size());
        for (String topic : topics) {
            topicDatas.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setErrorCode(error.code()).setErrorMessage(e.getMessage()));
        }
        this.data = new DescribeMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setErrorMessage(e.getMessage()).setTopics(topicDatas);
    }

    public void complete(Map<String, KafkaFutureImpl<MirrorTopicDescription>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            ApiException e = error.exception(this.data.errorMessage());
            for (KafkaFutureImpl<MirrorTopicDescription> future : result.values()) {
                future.completeExceptionally(e);
            }
            return;
        }
        for (DescribeMirrorsResponseData.TopicData topicData : this.data.topics()) {
            KafkaFutureImpl<MirrorTopicDescription> future = result.get(topicData.topic());
            if (future == null) {
                throw new IllegalArgumentException("Result must contain topic with name: " + topicData.topic());
            }
            Errors topicError = Errors.forCode(topicData.errorCode());
            if (topicError == Errors.NONE) {
                future.complete(new MirrorTopicDescription(topicData.linkName(), UUID.fromString(topicData.linkId()), topicData.mirrorTopic(), topicData.numPartitions(), this.toState(topicData.state()), topicData.stateTimeMs(), topicData.stoppedLogEndOffsets()));
                continue;
            }
            future.completeExceptionally(topicError.exception(this.data.errorMessage()));
        }
    }

    @Override
    public DescribeMirrorsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.incrementErrorCount(this.data.errorCode(), errorCounts);
        for (DescribeMirrorsResponseData.TopicData topicData : this.data.topics()) {
            this.incrementErrorCount(topicData.errorCode(), errorCounts);
        }
        return errorCounts;
    }

    private MirrorTopicDescription.State toState(String state) {
        try {
            return MirrorTopicDescription.State.valueOf(state);
        }
        catch (IllegalArgumentException e) {
            return MirrorTopicDescription.State.UNKNOWN;
        }
    }

    private void incrementErrorCount(short errorCode, Map<Errors, Integer> errorCounts) {
        Errors error = Errors.forCode(errorCode);
        errorCounts.put(error, errorCounts.getOrDefault((Object)error, 0) + 1);
    }

    public static DescribeMirrorsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeMirrorsResponse(new DescribeMirrorsResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

