/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;

public enum ApiKeys {
    PRODUCE(ApiMessageType.PRODUCE),
    FETCH(ApiMessageType.FETCH),
    LIST_OFFSETS(ApiMessageType.LIST_OFFSETS),
    METADATA(ApiMessageType.METADATA),
    LEADER_AND_ISR(ApiMessageType.LEADER_AND_ISR, true),
    STOP_REPLICA(ApiMessageType.STOP_REPLICA, true),
    UPDATE_METADATA(ApiMessageType.UPDATE_METADATA, true),
    CONTROLLED_SHUTDOWN(ApiMessageType.CONTROLLED_SHUTDOWN, true),
    OFFSET_COMMIT(ApiMessageType.OFFSET_COMMIT),
    OFFSET_FETCH(ApiMessageType.OFFSET_FETCH),
    FIND_COORDINATOR(ApiMessageType.FIND_COORDINATOR),
    JOIN_GROUP(ApiMessageType.JOIN_GROUP),
    HEARTBEAT(ApiMessageType.HEARTBEAT),
    LEAVE_GROUP(ApiMessageType.LEAVE_GROUP),
    SYNC_GROUP(ApiMessageType.SYNC_GROUP),
    DESCRIBE_GROUPS(ApiMessageType.DESCRIBE_GROUPS),
    LIST_GROUPS(ApiMessageType.LIST_GROUPS),
    SASL_HANDSHAKE(ApiMessageType.SASL_HANDSHAKE),
    API_VERSIONS(ApiMessageType.API_VERSIONS),
    CREATE_TOPICS(ApiMessageType.CREATE_TOPICS, false, true),
    DELETE_TOPICS(ApiMessageType.DELETE_TOPICS, false, true),
    DELETE_RECORDS(ApiMessageType.DELETE_RECORDS),
    INIT_PRODUCER_ID(ApiMessageType.INIT_PRODUCER_ID),
    OFFSET_FOR_LEADER_EPOCH(ApiMessageType.OFFSET_FOR_LEADER_EPOCH),
    ADD_PARTITIONS_TO_TXN(ApiMessageType.ADD_PARTITIONS_TO_TXN, false, 2, false),
    ADD_OFFSETS_TO_TXN(ApiMessageType.ADD_OFFSETS_TO_TXN, false, 2, false),
    END_TXN(ApiMessageType.END_TXN, false, 2, false),
    WRITE_TXN_MARKERS(ApiMessageType.WRITE_TXN_MARKERS, true, 2, false),
    TXN_OFFSET_COMMIT(ApiMessageType.TXN_OFFSET_COMMIT, false, 2, false),
    DESCRIBE_ACLS(ApiMessageType.DESCRIBE_ACLS),
    CREATE_ACLS(ApiMessageType.CREATE_ACLS, false, true),
    DELETE_ACLS(ApiMessageType.DELETE_ACLS, false, true),
    DESCRIBE_CONFIGS(ApiMessageType.DESCRIBE_CONFIGS),
    ALTER_CONFIGS(ApiMessageType.ALTER_CONFIGS, false, true),
    ALTER_REPLICA_LOG_DIRS(ApiMessageType.ALTER_REPLICA_LOG_DIRS),
    DESCRIBE_LOG_DIRS(ApiMessageType.DESCRIBE_LOG_DIRS),
    SASL_AUTHENTICATE(ApiMessageType.SASL_AUTHENTICATE),
    CREATE_PARTITIONS(ApiMessageType.CREATE_PARTITIONS, false, true),
    CREATE_DELEGATION_TOKEN(ApiMessageType.CREATE_DELEGATION_TOKEN, false, true),
    RENEW_DELEGATION_TOKEN(ApiMessageType.RENEW_DELEGATION_TOKEN, false, true),
    EXPIRE_DELEGATION_TOKEN(ApiMessageType.EXPIRE_DELEGATION_TOKEN, false, true),
    DESCRIBE_DELEGATION_TOKEN(ApiMessageType.DESCRIBE_DELEGATION_TOKEN),
    DELETE_GROUPS(ApiMessageType.DELETE_GROUPS),
    ELECT_LEADERS(ApiMessageType.ELECT_LEADERS),
    INCREMENTAL_ALTER_CONFIGS(ApiMessageType.INCREMENTAL_ALTER_CONFIGS, false, true),
    ALTER_PARTITION_REASSIGNMENTS(ApiMessageType.ALTER_PARTITION_REASSIGNMENTS, false, true),
    LIST_PARTITION_REASSIGNMENTS(ApiMessageType.LIST_PARTITION_REASSIGNMENTS, false, true),
    OFFSET_DELETE(ApiMessageType.OFFSET_DELETE),
    DESCRIBE_CLIENT_QUOTAS(ApiMessageType.DESCRIBE_CLIENT_QUOTAS),
    ALTER_CLIENT_QUOTAS(ApiMessageType.ALTER_CLIENT_QUOTAS, false, true),
    DESCRIBE_USER_SCRAM_CREDENTIALS(ApiMessageType.DESCRIBE_USER_SCRAM_CREDENTIALS),
    ALTER_USER_SCRAM_CREDENTIALS(ApiMessageType.ALTER_USER_SCRAM_CREDENTIALS, false, true),
    VOTE(ApiMessageType.VOTE, true, 0, false),
    BEGIN_QUORUM_EPOCH(ApiMessageType.BEGIN_QUORUM_EPOCH, true, 0, false),
    END_QUORUM_EPOCH(ApiMessageType.END_QUORUM_EPOCH, true, 0, false),
    DESCRIBE_QUORUM(ApiMessageType.DESCRIBE_QUORUM, true, 0, true),
    ALTER_ISR(ApiMessageType.ALTER_ISR, true),
    UPDATE_FEATURES(ApiMessageType.UPDATE_FEATURES, false, true),
    ENVELOPE(ApiMessageType.ENVELOPE, true, 0, false),
    FETCH_SNAPSHOT(ApiMessageType.FETCH_SNAPSHOT, false, 0, false),
    DESCRIBE_CLUSTER(ApiMessageType.DESCRIBE_CLUSTER),
    DESCRIBE_PRODUCERS(ApiMessageType.DESCRIBE_PRODUCERS),
    BROKER_REGISTRATION(ApiMessageType.BROKER_REGISTRATION, true, 0, false),
    BROKER_HEARTBEAT(ApiMessageType.BROKER_HEARTBEAT, true, 0, false),
    UNREGISTER_BROKER(ApiMessageType.UNREGISTER_BROKER, false, 0, true),
    DESCRIBE_TRANSACTIONS(ApiMessageType.DESCRIBE_TRANSACTIONS),
    LIST_TRANSACTIONS(ApiMessageType.LIST_TRANSACTIONS),
    ALLOCATE_PRODUCER_IDS(ApiMessageType.ALLOCATE_PRODUCER_IDS, true, true),
    REPLICA_STATUS(ApiMessageType.REPLICA_STATUS),
    REMOVE_BROKERS(ApiMessageType.REMOVE_BROKERS),
    CREATE_CLUSTER_LINKS(ApiMessageType.CREATE_CLUSTER_LINKS),
    LIST_CLUSTER_LINKS(ApiMessageType.LIST_CLUSTER_LINKS),
    DELETE_CLUSTER_LINKS(ApiMessageType.DELETE_CLUSTER_LINKS),
    INITIATE_SHUTDOWN(ApiMessageType.INITIATE_SHUTDOWN),
    ALTER_MIRRORS(ApiMessageType.ALTER_MIRRORS),
    DESCRIBE_BROKER_REMOVALS(ApiMessageType.DESCRIBE_BROKER_REMOVALS),
    LIST_MIRRORS(ApiMessageType.LIST_MIRRORS),
    DESCRIBE_MIRRORS(ApiMessageType.DESCRIBE_MIRRORS),
    DESCRIBE_BROKER_ADDITIONS(ApiMessageType.DESCRIBE_BROKER_ADDITIONS),
    DESCRIBE_BALANCER_STATUS(ApiMessageType.DESCRIBE_BALANCER_STATUS),
    DESCRIBE_EVEN_CLUSTER_LOAD_STATUS(ApiMessageType.DESCRIBE_EVEN_CLUSTER_LOAD_STATUS),
    INITIATE_REVERSE_CONNECTIONS(ApiMessageType.INITIATE_REVERSE_CONNECTIONS),
    REVERSE_CONNECTION(ApiMessageType.REVERSE_CONNECTION),
    ALTER_BROKER_REPLICA_EXCLUSIONS(ApiMessageType.ALTER_BROKER_REPLICA_EXCLUSIONS),
    DESCRIBE_BROKER_REPLICA_EXCLUSIONS(ApiMessageType.DESCRIBE_BROKER_REPLICA_EXCLUSIONS);

    private static final Map<ApiMessageType.ListenerType, EnumSet<ApiKeys>> APIS_BY_LISTENER;
    private static final Map<Integer, ApiKeys> ID_TO_TYPE;
    public final short id;
    public final String name;
    public final boolean clusterAction;
    public final byte minRequiredInterBrokerMagic;
    public final boolean forwardable;
    public final boolean requiresDelayedAllocation;
    public final ApiMessageType messageType;

    private ApiKeys(ApiMessageType messageType) {
        this(messageType, false);
    }

    private ApiKeys(ApiMessageType messageType, boolean clusterAction) {
        this(messageType, clusterAction, 0, false);
    }

    private ApiKeys(ApiMessageType messageType, boolean clusterAction, boolean forwardable) {
        this(messageType, clusterAction, 0, forwardable);
    }

    private ApiKeys(ApiMessageType messageType, boolean clusterAction, byte minRequiredInterBrokerMagic, boolean forwardable) {
        this.messageType = messageType;
        this.id = messageType.apiKey();
        this.name = messageType.name;
        this.clusterAction = clusterAction;
        this.minRequiredInterBrokerMagic = minRequiredInterBrokerMagic;
        this.requiresDelayedAllocation = forwardable || ApiKeys.shouldRetainsBufferReference(messageType.requestSchemas());
        this.forwardable = forwardable;
    }

    private static boolean shouldRetainsBufferReference(Schema[] requestSchemas) {
        boolean requestRetainsBufferReference = false;
        for (Schema requestVersionSchema : requestSchemas) {
            if (!ApiKeys.retainsBufferReference(requestVersionSchema)) continue;
            requestRetainsBufferReference = true;
            break;
        }
        return requestRetainsBufferReference;
    }

    public static ApiKeys forId(int id) {
        ApiKeys apiKey = ID_TO_TYPE.get(id);
        if (apiKey == null) {
            throw new IllegalArgumentException("Unexpected api key: " + id);
        }
        return apiKey;
    }

    public static boolean hasId(int id) {
        return ID_TO_TYPE.containsKey(id);
    }

    public short latestVersion() {
        return this.messageType.highestSupportedVersion();
    }

    public short oldestVersion() {
        return this.messageType.lowestSupportedVersion();
    }

    public List<Short> allVersions() {
        ArrayList<Short> versions = new ArrayList<Short>(this.latestVersion() - this.oldestVersion() + 1);
        for (short version = this.oldestVersion(); version <= this.latestVersion(); version = (short)(version + 1)) {
            versions.add(version);
        }
        return versions;
    }

    public boolean isVersionSupported(short apiVersion) {
        return apiVersion >= this.oldestVersion() && apiVersion <= this.latestVersion();
    }

    public short requestHeaderVersion(short apiVersion) {
        return this.messageType.requestHeaderVersion(apiVersion);
    }

    public short responseHeaderVersion(short apiVersion) {
        return this.messageType.responseHeaderVersion(apiVersion);
    }

    public static ApiKeys findByName(String name) {
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (!apiKey.name.equals(name)) continue;
            return apiKey;
        }
        return null;
    }

    public boolean inScope(ApiMessageType.ListenerType listener) {
        return this.messageType.listeners().contains((Object)listener);
    }

    private static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Name</th>\n");
        b.append("<th>Key</th>\n");
        b.append("</tr>");
        for (ApiKeys key : ApiKeys.zkBrokerApis()) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append("<a href=\"#The_Messages_" + key.name + "\">" + key.name + "</a>");
            b.append("</td>");
            b.append("<td>");
            b.append(key.id);
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(ApiKeys.toHtml());
    }

    private static boolean retainsBufferReference(Schema schema) {
        final AtomicBoolean hasBuffer = new AtomicBoolean(false);
        Schema.Visitor detector = new Schema.Visitor(){

            @Override
            public void visit(Type field) {
                if (field == Type.BYTES || field == Type.NULLABLE_BYTES || field == Type.RECORDS || field == Type.COMPACT_BYTES || field == Type.COMPACT_NULLABLE_BYTES) {
                    hasBuffer.set(true);
                }
            }
        };
        schema.walk(detector);
        return hasBuffer.get();
    }

    public static EnumSet<ApiKeys> zkBrokerApis() {
        return ApiKeys.apisForListener(ApiMessageType.ListenerType.ZK_BROKER);
    }

    public static EnumSet<ApiKeys> apisForListener(ApiMessageType.ListenerType listener) {
        return APIS_BY_LISTENER.get((Object)listener);
    }

    private static EnumSet<ApiKeys> filterApisForListener(ApiMessageType.ListenerType listener) {
        List controllerApis = Arrays.stream(ApiKeys.values()).filter(apiKey -> apiKey.messageType.listeners().contains((Object)listener)).collect(Collectors.toList());
        return EnumSet.copyOf(controllerApis);
    }

    static {
        APIS_BY_LISTENER = new EnumMap<ApiMessageType.ListenerType, EnumSet<ApiKeys>>(ApiMessageType.ListenerType.class);
        for (ApiMessageType.ListenerType listenerType : ApiMessageType.ListenerType.values()) {
            APIS_BY_LISTENER.put(listenerType, ApiKeys.filterApisForListener(listenerType));
        }
        ID_TO_TYPE = Arrays.stream(ApiKeys.values()).collect(Collectors.toMap(key -> key.id, Function.identity()));
    }
}

