/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.Tlv;

public class ProxyProtocolV1Engine
implements ProxyProtocolEngine {
    private static final int MAX_LENGTH = 108;
    private static final String INVALID_PROTOCOL_HEADER = "Invalid Proxy Protocol Header.";
    private int byteCount;
    private InetAddress sourceAddress;
    private int sourcePort = -1;
    private StringBuilder stringBuilder = new StringBuilder();
    private boolean carriageReturnSeen = false;
    private boolean isIpv4 = false;
    private boolean proxyHeaderParsed = false;

    private IOException invalidProtocolHeaderException() {
        return new IOException("Invalid Proxy Protocol Header. Protocol Header:" + this.stringBuilder.toString());
    }

    private void decodeProxyProtoCol() throws IOException {
        boolean invalidHeader = false;
        if (this.proxyHeaderParsed) {
            return;
        }
        String[] tokens = this.stringBuilder.toString().split(" ");
        if (tokens.length < 1 || !tokens[0].equals("PROXY")) {
            throw this.invalidProtocolHeaderException();
        }
        switch (tokens[1]) {
            case "TCP4": {
                this.isIpv4 = true;
                if (tokens.length == 6) {
                    this.sourceAddress = Inet4Address.getByName(tokens[2]);
                    break;
                }
                throw this.invalidProtocolHeaderException();
            }
            case "TCP6": {
                if (tokens.length == 6) {
                    this.sourceAddress = Inet6Address.getByName(tokens[2]);
                    break;
                }
                throw this.invalidProtocolHeaderException();
            }
            case "UNKNOWN": {
                break;
            }
            default: {
                throw this.invalidProtocolHeaderException();
            }
        }
        if (this.sourceAddress != null) {
            try {
                this.sourcePort = Integer.parseInt(tokens[4]);
            }
            catch (NumberFormatException e) {
                throw this.invalidProtocolHeaderException();
            }
        }
        this.proxyHeaderParsed = true;
    }

    @Override
    public void processHeaders(ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            char c = (char)buf.get();
            if (this.carriageReturnSeen) {
                if (c == '\n') {
                    this.decodeProxyProtoCol();
                    break;
                }
                throw new IOException(INVALID_PROTOCOL_HEADER);
            }
            if (c == '\r') {
                this.carriageReturnSeen = true;
            } else {
                this.stringBuilder.append(c);
            }
            if (this.byteCount++ != 108) continue;
            throw new IOException(INVALID_PROTOCOL_HEADER);
        }
    }

    @Override
    public boolean hasClientInformation() {
        return this.sourceAddress != null;
    }

    @Override
    public InetAddress clientAddress() {
        return this.sourceAddress;
    }

    @Override
    public int clientPort() {
        return this.sourcePort;
    }

    @Override
    public boolean ready() {
        return this.proxyHeaderParsed;
    }

    @Override
    public Tlv getTlv(int type) {
        return null;
    }
}

