/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.TransportLayer;

public abstract class AbstractTransportLayer
implements TransportLayer {
    protected SelectionKey key;
    protected final SocketChannel socketChannel;
    protected final ProxyProtocolEngine proxyProtocolEngine;
    protected ByteBuffer netReadBuffer;

    public AbstractTransportLayer(SelectionKey key, ProxyProtocolEngine proxyProtocolEngine) {
        this.key = key;
        this.socketChannel = (SocketChannel)key.channel();
        this.proxyProtocolEngine = proxyProtocolEngine;
    }

    @Override
    public boolean finishConnect() throws IOException {
        boolean connected = this.socketChannel.finishConnect();
        if (connected) {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFF7 | 1);
        }
        return connected;
    }

    @Override
    public void disconnect() {
        this.key.cancel();
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public SelectionKey selectionKey() {
        return this.key;
    }

    @Override
    public InetAddress socketAddress() {
        if (this.proxyProtocolEngine.ready() && this.proxyProtocolEngine.hasClientInformation()) {
            return this.proxyProtocolEngine.clientAddress();
        }
        return this.socketChannel.socket().getInetAddress();
    }

    protected int readFromSocketChannel() throws IOException {
        return this.socketChannel.read(this.netReadBuffer);
    }

    protected int maybeReadAndProcessProxyHeaders() throws IOException {
        int read = 0;
        if (!this.proxyProtocolReady()) {
            read = this.readFromSocketChannel();
            this.netReadBuffer.flip();
            this.proxyProtocolEngine.processHeaders(this.netReadBuffer);
            this.netReadBuffer.compact();
        }
        return read;
    }

    protected boolean proxyProtocolReady() {
        return this.proxyProtocolEngine.ready();
    }
}

