/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.AbstractGaugeSuite;
import org.slf4j.Logger;

public final class IntCounterSuite<K>
extends AbstractGaugeSuite<K> {
    private final int maxEntries;
    private final Set<K> removable = new HashSet<K>();

    public IntCounterSuite(Logger log, String suiteName, Metrics metrics, Function<K, MetricName> metricNameCalculator, int maxEntries) {
        super(log, suiteName, metrics, metricNameCalculator);
        this.maxEntries = maxEntries;
        log.trace("{}: created new counter suite with maxEntries = {}.", (Object)suiteName, (Object)maxEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(K key) {
        IntCounterSuite intCounterSuite = this;
        synchronized (intCounterSuite) {
            if (this.closed) {
                this.log.warn("{}: Attempted to increment {}, but the GaugeSuite was closed.", (Object)this.suiteName, (Object)key.toString());
                return;
            }
            AbstractGaugeSuite.StoredIntGauge gauge = (AbstractGaugeSuite.StoredIntGauge)this.gauges.get(key);
            if (gauge != null) {
                if (gauge.increment() > 0) {
                    this.removable.remove(key);
                }
                return;
            }
            if (this.gauges.size() == this.maxEntries) {
                if (this.removable.isEmpty()) {
                    this.log.debug("{}: Attempted to increment {}, but there are already {} entries.", new Object[]{this.suiteName, key.toString(), this.maxEntries});
                    return;
                }
                Iterator<K> iter = this.removable.iterator();
                K keyToRemove = iter.next();
                iter.remove();
                this.removeGauge(keyToRemove);
            }
            this.addGauge(key, 1);
        }
        this.performPendingMetricsOperations();
    }

    public synchronized void decrement(K key) {
        if (this.closed) {
            this.log.warn("{}: Attempted to decrement {}, but the gauge suite was closed.", (Object)this.suiteName, (Object)key.toString());
            return;
        }
        AbstractGaugeSuite.StoredIntGauge gauge = (AbstractGaugeSuite.StoredIntGauge)this.gauges.get(key);
        if (gauge == null) {
            this.log.debug("{}: Attempted to decrement {}, but no such metric was registered.", (Object)this.suiteName, (Object)key.toString());
        } else {
            int cur = gauge.decrement();
            this.log.trace("{}: Removed a reference to {}. {} reference(s) remaining.", new Object[]{this.suiteName, key.toString(), cur});
            if (cur <= 0) {
                this.removable.add(key);
            }
        }
    }

    public int maxEntries() {
        return this.maxEntries;
    }
}

