/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ReplicaStatusResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<ReplicaStatusTopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."), new Field("topics", new ArrayOf(ReplicaStatusTopicResponse.SCHEMA_0), "Each topic in the response."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."), new Field("topics", new ArrayOf(ReplicaStatusTopicResponse.SCHEMA_1), "Each topic in the response."));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."), new Field("topics", new ArrayOf(ReplicaStatusTopicResponse.SCHEMA_2), "Each topic in the response."));
    public static final Schema SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."), new Field("topics", new ArrayOf(ReplicaStatusTopicResponse.SCHEMA_3), "Each topic in the response."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public ReplicaStatusResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ReplicaStatusResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.topics = new ArrayList<ReplicaStatusTopicResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10000;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<ReplicaStatusTopicResponse> newCollection = new ArrayList<ReplicaStatusTopicResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ReplicaStatusTopicResponse(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeInt(this.topics.size());
        for (ReplicaStatusTopicResponse topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(4);
        for (ReplicaStatusTopicResponse topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReplicaStatusResponseData)) {
            return false;
        }
        ReplicaStatusResponseData other = (ReplicaStatusResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public ReplicaStatusResponseData duplicate() {
        ReplicaStatusResponseData _duplicate = new ReplicaStatusResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<ReplicaStatusTopicResponse> newTopics = new ArrayList<ReplicaStatusTopicResponse>(this.topics.size());
        for (ReplicaStatusTopicResponse _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ReplicaStatusResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<ReplicaStatusTopicResponse> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ReplicaStatusResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ReplicaStatusResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ReplicaStatusResponseData setTopics(List<ReplicaStatusTopicResponse> v) {
        this.topics = v;
        return this;
    }

    public static class ReplicaStatusReplicaResponse
    implements Message {
        int id;
        boolean isLeader;
        boolean isObserver;
        boolean isIsrEligible;
        boolean isInIsr;
        boolean isCaughtUp;
        long logStartOffset;
        long logEndOffset;
        long lastCaughtUpTimeMs;
        long lastFetchTimeMs;
        String linkName;
        String mirrorState;
        long mirrorLastFetchTimeMs;
        long mirrorLastFetchSourceHighWatermark;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("id", Type.INT32, "The broker ID for the replica."), new Field("is_leader", Type.BOOLEAN, "Whether the replica is the ISR leader."), new Field("is_observer", Type.BOOLEAN, "Whether the replica is an observer, otherwise a sync replica."), new Field("is_isr_eligible", Type.BOOLEAN, "Whether the replica is a candidate for the ISR set."), new Field("is_in_isr", Type.BOOLEAN, "Whether the replica is in the ISR set."), new Field("is_caught_up", Type.BOOLEAN, "Whether the replica's log is considered to be caught up."), new Field("log_start_offset", Type.INT64, "The replica's starting log offset, or -1 if unknown."), new Field("log_end_offset", Type.INT64, "The replica's ending log offset, or -1 if unknown."), new Field("last_caught_up_time_ms", Type.INT64, "The time when the replica was caught up to the leader."), new Field("last_fetch_time_ms", Type.INT64, "The time when the leader processed the last fetch request from the replica."));
        public static final Schema SCHEMA_1 = new Schema(new Field("id", Type.INT32, "The broker ID for the replica."), new Field("is_leader", Type.BOOLEAN, "Whether the replica is the ISR leader."), new Field("is_observer", Type.BOOLEAN, "Whether the replica is an observer, otherwise a sync replica."), new Field("is_isr_eligible", Type.BOOLEAN, "Whether the replica is a candidate for the ISR set."), new Field("is_in_isr", Type.BOOLEAN, "Whether the replica is in the ISR set."), new Field("is_caught_up", Type.BOOLEAN, "Whether the replica's log is considered to be caught up."), new Field("log_start_offset", Type.INT64, "The replica's starting log offset, or -1 if unknown."), new Field("log_end_offset", Type.INT64, "The replica's ending log offset, or -1 if unknown."), new Field("last_caught_up_time_ms", Type.INT64, "The time when the replica was caught up to the leader."), new Field("last_fetch_time_ms", Type.INT64, "The time when the leader processed the last fetch request from the replica."), new Field("link_name", Type.NULLABLE_STRING, "The cluster link name over which the replica status was fetched, otherwise null if local."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public ReplicaStatusReplicaResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReplicaStatusReplicaResponse() {
            this.id = 0;
            this.isLeader = false;
            this.isObserver = false;
            this.isIsrEligible = false;
            this.isInIsr = false;
            this.isCaughtUp = false;
            this.logStartOffset = 0L;
            this.logEndOffset = 0L;
            this.lastCaughtUpTimeMs = 0L;
            this.lastFetchTimeMs = 0L;
            this.linkName = null;
            this.mirrorState = null;
            this.mirrorLastFetchTimeMs = -1L;
            this.mirrorLastFetchSourceHighWatermark = -1L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            short length;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaStatusReplicaResponse");
            }
            this.id = _readable.readInt();
            this.isLeader = _readable.readByte() != 0;
            this.isObserver = _readable.readByte() != 0;
            this.isIsrEligible = _readable.readByte() != 0;
            this.isInIsr = _readable.readByte() != 0;
            this.isCaughtUp = _readable.readByte() != 0;
            this.logStartOffset = _readable.readLong();
            this.logEndOffset = _readable.readLong();
            this.lastCaughtUpTimeMs = _readable.readLong();
            this.lastFetchTimeMs = _readable.readLong();
            if (_version >= 1) {
                length = _readable.readShort();
                if (length < 0) {
                    this.linkName = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field linkName had invalid length " + length);
                    }
                    this.linkName = _readable.readString(length);
                }
            } else {
                this.linkName = null;
            }
            if (_version >= 2) {
                length = _readable.readShort();
                if (length < 0) {
                    this.mirrorState = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field mirrorState had invalid length " + length);
                    }
                    this.mirrorState = _readable.readString(length);
                }
            } else {
                this.mirrorState = null;
            }
            this.mirrorLastFetchTimeMs = _version >= 2 ? _readable.readLong() : -1L;
            this.mirrorLastFetchSourceHighWatermark = _version >= 2 ? _readable.readLong() : -1L;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            RawTaggedFieldWriter _rawWriter;
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.id);
            _writable.writeByte(this.isLeader ? (byte)1 : 0);
            _writable.writeByte(this.isObserver ? (byte)1 : 0);
            _writable.writeByte(this.isIsrEligible ? (byte)1 : 0);
            _writable.writeByte(this.isInIsr ? (byte)1 : 0);
            _writable.writeByte(this.isCaughtUp ? (byte)1 : 0);
            _writable.writeLong(this.logStartOffset);
            _writable.writeLong(this.logEndOffset);
            _writable.writeLong(this.lastCaughtUpTimeMs);
            _writable.writeLong(this.lastFetchTimeMs);
            if (_version >= 1) {
                if (this.linkName == null) {
                    _writable.writeShort((short)-1);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.linkName);
                    _writable.writeShort((short)_stringBytes.length);
                    _writable.writeByteArray(_stringBytes);
                }
            }
            if (_version >= 2) {
                if (this.mirrorState == null) {
                    _writable.writeShort((short)-1);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.mirrorState);
                    _writable.writeShort((short)_stringBytes.length);
                    _writable.writeByteArray(_stringBytes);
                }
            }
            if (_version >= 2) {
                _writable.writeLong(this.mirrorLastFetchTimeMs);
            }
            if (_version >= 2) {
                _writable.writeLong(this.mirrorLastFetchSourceHighWatermark);
            }
            if ((_numTaggedFields += (_rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields)).numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReplicaStatusReplicaResponse");
            }
            _size.addBytes(4);
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            if (_version >= 1) {
                if (this.linkName == null) {
                    _size.addBytes(2);
                } else {
                    _stringBytes = this.linkName.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'linkName' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.linkName, _stringBytes);
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 2) {
                if (this.mirrorState == null) {
                    _size.addBytes(2);
                } else {
                    _stringBytes = this.mirrorState.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'mirrorState' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.mirrorState, _stringBytes);
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 2) {
                _size.addBytes(8);
            }
            if (_version >= 2) {
                _size.addBytes(8);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaStatusReplicaResponse)) {
                return false;
            }
            ReplicaStatusReplicaResponse other = (ReplicaStatusReplicaResponse)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.isLeader != other.isLeader) {
                return false;
            }
            if (this.isObserver != other.isObserver) {
                return false;
            }
            if (this.isIsrEligible != other.isIsrEligible) {
                return false;
            }
            if (this.isInIsr != other.isInIsr) {
                return false;
            }
            if (this.isCaughtUp != other.isCaughtUp) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.logEndOffset != other.logEndOffset) {
                return false;
            }
            if (this.lastCaughtUpTimeMs != other.lastCaughtUpTimeMs) {
                return false;
            }
            if (this.lastFetchTimeMs != other.lastFetchTimeMs) {
                return false;
            }
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (this.mirrorState == null ? other.mirrorState != null : !this.mirrorState.equals(other.mirrorState)) {
                return false;
            }
            if (this.mirrorLastFetchTimeMs != other.mirrorLastFetchTimeMs) {
                return false;
            }
            if (this.mirrorLastFetchSourceHighWatermark != other.mirrorLastFetchSourceHighWatermark) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.id;
            hashCode = 31 * hashCode + (this.isLeader ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.isObserver ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.isIsrEligible ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.isInIsr ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.isCaughtUp ? 1231 : 1237);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + ((int)(this.logEndOffset >> 32) ^ (int)this.logEndOffset);
            hashCode = 31 * hashCode + ((int)(this.lastCaughtUpTimeMs >> 32) ^ (int)this.lastCaughtUpTimeMs);
            hashCode = 31 * hashCode + ((int)(this.lastFetchTimeMs >> 32) ^ (int)this.lastFetchTimeMs);
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + (this.mirrorState == null ? 0 : this.mirrorState.hashCode());
            hashCode = 31 * hashCode + ((int)(this.mirrorLastFetchTimeMs >> 32) ^ (int)this.mirrorLastFetchTimeMs);
            hashCode = 31 * hashCode + ((int)(this.mirrorLastFetchSourceHighWatermark >> 32) ^ (int)this.mirrorLastFetchSourceHighWatermark);
            return hashCode;
        }

        @Override
        public ReplicaStatusReplicaResponse duplicate() {
            ReplicaStatusReplicaResponse _duplicate = new ReplicaStatusReplicaResponse();
            _duplicate.id = this.id;
            _duplicate.isLeader = this.isLeader;
            _duplicate.isObserver = this.isObserver;
            _duplicate.isIsrEligible = this.isIsrEligible;
            _duplicate.isInIsr = this.isInIsr;
            _duplicate.isCaughtUp = this.isCaughtUp;
            _duplicate.logStartOffset = this.logStartOffset;
            _duplicate.logEndOffset = this.logEndOffset;
            _duplicate.lastCaughtUpTimeMs = this.lastCaughtUpTimeMs;
            _duplicate.lastFetchTimeMs = this.lastFetchTimeMs;
            _duplicate.linkName = this.linkName == null ? null : this.linkName;
            _duplicate.mirrorState = this.mirrorState == null ? null : this.mirrorState;
            _duplicate.mirrorLastFetchTimeMs = this.mirrorLastFetchTimeMs;
            _duplicate.mirrorLastFetchSourceHighWatermark = this.mirrorLastFetchSourceHighWatermark;
            return _duplicate;
        }

        public String toString() {
            return "ReplicaStatusReplicaResponse(id=" + this.id + ", isLeader=" + (this.isLeader ? "true" : "false") + ", isObserver=" + (this.isObserver ? "true" : "false") + ", isIsrEligible=" + (this.isIsrEligible ? "true" : "false") + ", isInIsr=" + (this.isInIsr ? "true" : "false") + ", isCaughtUp=" + (this.isCaughtUp ? "true" : "false") + ", logStartOffset=" + this.logStartOffset + ", logEndOffset=" + this.logEndOffset + ", lastCaughtUpTimeMs=" + this.lastCaughtUpTimeMs + ", lastFetchTimeMs=" + this.lastFetchTimeMs + ", linkName=" + (this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", mirrorState=" + (this.mirrorState == null ? "null" : "'" + this.mirrorState.toString() + "'") + ", mirrorLastFetchTimeMs=" + this.mirrorLastFetchTimeMs + ", mirrorLastFetchSourceHighWatermark=" + this.mirrorLastFetchSourceHighWatermark + ")";
        }

        public int id() {
            return this.id;
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public boolean isObserver() {
            return this.isObserver;
        }

        public boolean isIsrEligible() {
            return this.isIsrEligible;
        }

        public boolean isInIsr() {
            return this.isInIsr;
        }

        public boolean isCaughtUp() {
            return this.isCaughtUp;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public long logEndOffset() {
            return this.logEndOffset;
        }

        public long lastCaughtUpTimeMs() {
            return this.lastCaughtUpTimeMs;
        }

        public long lastFetchTimeMs() {
            return this.lastFetchTimeMs;
        }

        public String linkName() {
            return this.linkName;
        }

        public String mirrorState() {
            return this.mirrorState;
        }

        public long mirrorLastFetchTimeMs() {
            return this.mirrorLastFetchTimeMs;
        }

        public long mirrorLastFetchSourceHighWatermark() {
            return this.mirrorLastFetchSourceHighWatermark;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReplicaStatusReplicaResponse setId(int v) {
            this.id = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setIsLeader(boolean v) {
            this.isLeader = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setIsObserver(boolean v) {
            this.isObserver = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setIsIsrEligible(boolean v) {
            this.isIsrEligible = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setIsInIsr(boolean v) {
            this.isInIsr = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setIsCaughtUp(boolean v) {
            this.isCaughtUp = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setLogEndOffset(long v) {
            this.logEndOffset = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setLastCaughtUpTimeMs(long v) {
            this.lastCaughtUpTimeMs = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setLastFetchTimeMs(long v) {
            this.lastFetchTimeMs = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setMirrorState(String v) {
            this.mirrorState = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setMirrorLastFetchTimeMs(long v) {
            this.mirrorLastFetchTimeMs = v;
            return this;
        }

        public ReplicaStatusReplicaResponse setMirrorLastFetchSourceHighWatermark(long v) {
            this.mirrorLastFetchSourceHighWatermark = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("id", Type.INT32, "The broker ID for the replica."), new Field("is_leader", Type.BOOLEAN, "Whether the replica is the ISR leader."), new Field("is_observer", Type.BOOLEAN, "Whether the replica is an observer, otherwise a sync replica."), new Field("is_isr_eligible", Type.BOOLEAN, "Whether the replica is a candidate for the ISR set."), new Field("is_in_isr", Type.BOOLEAN, "Whether the replica is in the ISR set."), new Field("is_caught_up", Type.BOOLEAN, "Whether the replica's log is considered to be caught up."), new Field("log_start_offset", Type.INT64, "The replica's starting log offset, or -1 if unknown."), new Field("log_end_offset", Type.INT64, "The replica's ending log offset, or -1 if unknown."), new Field("last_caught_up_time_ms", Type.INT64, "The time when the replica was caught up to the leader."), new Field("last_fetch_time_ms", Type.INT64, "The time when the leader processed the last fetch request from the replica."), new Field("link_name", Type.NULLABLE_STRING, "The cluster link name over which the replica status was fetched, otherwise null if local."), new Field("mirror_state", Type.NULLABLE_STRING, "The partition's mirror state, or null if not mirrored."), new Field("mirror_last_fetch_time_ms", Type.INT64, "The time of the last successful fetch in milliseconds from epoch, or -1 if unknown or not mirrored."), new Field("mirror_last_fetch_source_high_watermark", Type.INT64, "The source partition's high watermark from the last fetch, or -1 if unknown or not mirrored."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class ReplicaStatusPartitionResponse
    implements Message {
        int partitionIndex;
        short errorCode;
        int leaderEpoch;
        int leaderId;
        List<ReplicaStatusReplicaResponse> replicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error. On error, the replica data will be null."), new Field("replicas", ArrayOf.nullable(ReplicaStatusReplicaResponse.SCHEMA_0), "The replica for the partition."));
        public static final Schema SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error. On error, the replica data will be null."), new Field("replicas", ArrayOf.nullable(ReplicaStatusReplicaResponse.SCHEMA_1), "The replica for the partition."));
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error. On error, the replica data will be null."), new Field("replicas", ArrayOf.nullable(ReplicaStatusReplicaResponse.SCHEMA_2), "The replica for the partition."));
        public static final Schema SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error. On error, the replica data will be null."), new Field("leader_epoch", Type.INT32, "The leader partition epoch information."), new Field("leader_id", Type.INT32, "The partition leader id. This value is the brokerId of the leader replica."), new Field("replicas", ArrayOf.nullable(ReplicaStatusReplicaResponse.SCHEMA_2), "The replica for the partition."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public ReplicaStatusPartitionResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReplicaStatusPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.leaderEpoch = -1;
            this.leaderId = -1;
            this.replicas = new ArrayList<ReplicaStatusReplicaResponse>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaStatusPartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.leaderEpoch = _version >= 3 ? _readable.readInt() : -1;
            this.leaderId = _version >= 3 ? _readable.readInt() : -1;
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.replicas = null;
            } else {
                ArrayList<ReplicaStatusReplicaResponse> newCollection = new ArrayList<ReplicaStatusReplicaResponse>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new ReplicaStatusReplicaResponse(_readable, _version, _context));
                }
                this.replicas = newCollection;
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (_version >= 3) {
                _writable.writeInt(this.leaderEpoch);
            }
            if (_version >= 3) {
                _writable.writeInt(this.leaderId);
            }
            if (this.replicas == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.replicas.size());
                for (ReplicaStatusReplicaResponse replicasElement : this.replicas) {
                    replicasElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReplicaStatusPartitionResponse");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (_version >= 3) {
                _size.addBytes(4);
            }
            if (_version >= 3) {
                _size.addBytes(4);
            }
            if (this.replicas == null) {
                _size.addBytes(4);
            } else {
                _size.addBytes(4);
                for (ReplicaStatusReplicaResponse replicasElement : this.replicas) {
                    replicasElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaStatusPartitionResponse)) {
                return false;
            }
            ReplicaStatusPartitionResponse other = (ReplicaStatusPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            return hashCode;
        }

        @Override
        public ReplicaStatusPartitionResponse duplicate() {
            ReplicaStatusPartitionResponse _duplicate = new ReplicaStatusPartitionResponse();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.leaderId = this.leaderId;
            if (this.replicas == null) {
                _duplicate.replicas = null;
            } else {
                ArrayList<ReplicaStatusReplicaResponse> newReplicas = new ArrayList<ReplicaStatusReplicaResponse>(this.replicas.size());
                for (ReplicaStatusReplicaResponse _element : this.replicas) {
                    newReplicas.add(_element.duplicate());
                }
                _duplicate.replicas = newReplicas;
            }
            return _duplicate;
        }

        public String toString() {
            return "ReplicaStatusPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", leaderEpoch=" + this.leaderEpoch + ", leaderId=" + this.leaderId + ", replicas=" + (this.replicas == null ? "null" : MessageUtil.deepToString(this.replicas.iterator())) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public List<ReplicaStatusReplicaResponse> replicas() {
            return this.replicas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReplicaStatusPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ReplicaStatusPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ReplicaStatusPartitionResponse setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public ReplicaStatusPartitionResponse setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public ReplicaStatusPartitionResponse setReplicas(List<ReplicaStatusReplicaResponse> v) {
            this.replicas = v;
            return this;
        }
    }

    public static class ReplicaStatusTopicResponse
    implements Message {
        String name;
        List<ReplicaStatusPartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ReplicaStatusPartitionResponse.SCHEMA_0), "Each partition in the response."));
        public static final Schema SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ReplicaStatusPartitionResponse.SCHEMA_1), "Each partition in the response."));
        public static final Schema SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ReplicaStatusPartitionResponse.SCHEMA_2), "Each partition in the response."));
        public static final Schema SCHEMA_3 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ReplicaStatusPartitionResponse.SCHEMA_3), "Each partition in the response."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public ReplicaStatusTopicResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReplicaStatusTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<ReplicaStatusPartitionResponse>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaStatusTopicResponse");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<ReplicaStatusPartitionResponse> newCollection = new ArrayList<ReplicaStatusPartitionResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaStatusPartitionResponse(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                ReplicaStatusPartitionResponse partitionsElement = (ReplicaStatusPartitionResponse)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReplicaStatusTopicResponse");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(4);
            for (ReplicaStatusPartitionResponse partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaStatusTopicResponse)) {
                return false;
            }
            ReplicaStatusTopicResponse other = (ReplicaStatusTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public ReplicaStatusTopicResponse duplicate() {
            ReplicaStatusTopicResponse _duplicate = new ReplicaStatusTopicResponse();
            _duplicate.name = this.name;
            ArrayList<ReplicaStatusPartitionResponse> newPartitions = new ArrayList<ReplicaStatusPartitionResponse>(this.partitions.size());
            for (ReplicaStatusPartitionResponse _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ReplicaStatusTopicResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ReplicaStatusPartitionResponse> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReplicaStatusTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public ReplicaStatusTopicResponse setPartitions(List<ReplicaStatusPartitionResponse> v) {
            this.partitions = v;
            return this;
        }
    }
}

