/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;

public class ReplicaExclusionUtils {
    public static final int MAX_REASON_STRING_LENGTH = 128;

    public static void validateReason(String reason) {
        if (reason.length() > 128) {
            throw new InvalidBrokerReplicaExclusionException(String.format("The given reason '%s' cannot be more than %d characters. Instead, it was %d. Please choose another reason", reason, 128, reason.length()));
        }
        if (reason.equals(".") || reason.equals("..")) {
            throw new InvalidBrokerReplicaExclusionException(String.format("A replica exclusion reason cannot be equal to '%s'. Please choose another reason", reason));
        }
        if (!ReplicaExclusionUtils.containsValidPattern(reason)) {
            throw new InvalidBrokerReplicaExclusionException(String.format("The replica exclusion reason `%s` contains invalid characters. Valid characters are the ASCII alphanumerics, `.`, `_` and `-`. Please choose another reason", reason));
        }
    }

    private static boolean containsValidPattern(String reason) {
        for (int i = 0; i < reason.length(); ++i) {
            boolean validChar;
            char c = reason.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-' || c == ' ';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

