/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SerializationTest {
    private final String topic = "testTopic";
    private final Map<Class<?>, List<Object>> testData = new HashMap<Class<?>, List<Object>>(){
        {
            this.put(String.class, Arrays.asList("my string"));
            this.put(Short.class, Arrays.asList((short)Short.MAX_VALUE, (short)Short.MIN_VALUE));
            this.put(Integer.class, Arrays.asList(423412424, -41243432));
            this.put(Long.class, Arrays.asList(0xCCCCCCCCCCCCCCCL, -922337203685477581L));
            this.put(Float.class, Arrays.asList(Float.valueOf(5678567.0f), Float.valueOf(-5678567.0f)));
            this.put(Double.class, Arrays.asList(5678567.12312, -5678567.12341));
            this.put(byte[].class, Arrays.asList(new Object[]{"my string".getBytes()}));
            this.put(ByteBuffer.class, Arrays.asList(ByteBuffer.allocate(10).put("my string".getBytes())));
            this.put(Bytes.class, Arrays.asList(new Bytes("my string".getBytes())));
            this.put(UUID.class, Arrays.asList(UUID.randomUUID()));
        }
    };

    @Test
    public void allSerdesShouldRoundtripInput() {
        for (Map.Entry<Class<?>, List<Object>> test : this.testData.entrySet()) {
            Serde serde = Serdes.serdeFrom(test.getKey());
            Throwable throwable = null;
            try {
                for (Object value : test.getValue()) {
                    Assertions.assertEquals((Object)value, (Object)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", value)), (String)("Should get the original " + test.getKey().getSimpleName() + " after serialization and deserialization"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serde == null) continue;
                if (throwable != null) {
                    try {
                        serde.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serde.close();
            }
        }
    }

    @Test
    public void allSerdesShouldSupportNull() {
        for (Class<?> cls : this.testData.keySet()) {
            Serde serde = Serdes.serdeFrom(cls);
            Throwable throwable = null;
            try {
                Assertions.assertNull((Object)serde.serializer().serialize("testTopic", null), (String)("Should support null in " + cls.getSimpleName() + " serialization"));
                Assertions.assertNull((Object)serde.deserializer().deserialize("testTopic", null), (String)("Should support null in " + cls.getSimpleName() + " deserialization"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serde == null) continue;
                if (throwable != null) {
                    try {
                        serde.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serde.close();
            }
        }
    }

    @Test
    public void testSerdeFromUnknown() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Serdes.serdeFrom(DummyClass.class));
    }

    @Test
    public void testSerdeFromNotNull() {
        try (Serde serde = Serdes.Long();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> Serdes.serdeFrom(null, (Deserializer)serde.deserializer()));
        }
    }

    @Test
    public void stringSerdeShouldSupportDifferentEncodings() {
        String str = "my string";
        List<String> encodings = Arrays.asList("UTF8", "UTF-16");
        for (String encoding : encodings) {
            Serde<String> serDeser = this.getStringSerde(encoding);
            Throwable throwable = null;
            try {
                Serializer serializer = serDeser.serializer();
                Deserializer deserializer = serDeser.deserializer();
                Assertions.assertEquals((Object)str, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)str)), (String)("Should get the original string after serialization and deserialization with encoding " + encoding));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serDeser == null) continue;
                if (throwable != null) {
                    try {
                        serDeser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serDeser.close();
            }
        }
    }

    @Test
    public void floatDeserializerShouldThrowSerializationExceptionOnZeroBytes() {
        try (Serde serde = Serdes.Float();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Float cfr_ignored_0 = (Float)serde.deserializer().deserialize("testTopic", new byte[0]);
            });
        }
    }

    @Test
    public void floatDeserializerShouldThrowSerializationExceptionOnTooFewBytes() {
        try (Serde serde = Serdes.Float();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Float cfr_ignored_0 = (Float)serde.deserializer().deserialize("testTopic", new byte[3]);
            });
        }
    }

    @Test
    public void floatDeserializerShouldThrowSerializationExceptionOnTooManyBytes() {
        try (Serde serde = Serdes.Float();){
            Assertions.assertThrows(SerializationException.class, () -> {
                Float cfr_ignored_0 = (Float)serde.deserializer().deserialize("testTopic", new byte[5]);
            });
        }
    }

    @Test
    public void floatSerdeShouldPreserveNaNValues() {
        int someNaNAsIntBits = 2139095041;
        float someNaN = Float.intBitsToFloat(someNaNAsIntBits);
        int anotherNaNAsIntBits = 2139095042;
        float anotherNaN = Float.intBitsToFloat(anotherNaNAsIntBits);
        try (Serde serde = Serdes.Float();){
            Float roundtrip = (Float)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", (Object)Float.valueOf(someNaN)));
            Assertions.assertEquals((int)someNaNAsIntBits, (int)Float.floatToRawIntBits(roundtrip.floatValue()));
            Float otherRoundtrip = (Float)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", (Object)Float.valueOf(anotherNaN)));
            Assertions.assertEquals((int)anotherNaNAsIntBits, (int)Float.floatToRawIntBits(otherRoundtrip.floatValue()));
        }
    }

    @Test
    public void testSerializeVoid() {
        try (Serde serde = Serdes.Void();){
            serde.serializer().serialize("testTopic", null);
        }
    }

    @Test
    public void testDeserializeVoid() {
        try (Serde serde = Serdes.Void();){
            serde.deserializer().deserialize("testTopic", null);
        }
    }

    @Test
    public void voidDeserializerShouldThrowOnNotNullValues() {
        try (Serde serde = Serdes.Void();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                Void cfr_ignored_0 = (Void)serde.deserializer().deserialize("testTopic", new byte[5]);
            });
        }
    }

    private Serde<String> getStringSerde(String encoder) {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", encoder);
        Serializer serializer = Serdes.String().serializer();
        serializer.configure(serializerConfigs, true);
        HashMap<String, String> deserializerConfigs = new HashMap<String, String>();
        deserializerConfigs.put("key.deserializer.encoding", encoder);
        Deserializer deserializer = Serdes.String().deserializer();
        deserializer.configure(deserializerConfigs, true);
        return Serdes.serdeFrom((Serializer)serializer, (Deserializer)deserializer);
    }

    private class DummyClass {
        private DummyClass() {
        }
    }
}

