/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetsForLeaderEpochRequestTest {
    @Test
    public void testForConsumerRequiresVersion3() {
        short version;
        OffsetsForLeaderEpochRequest.Builder builder = OffsetsForLeaderEpochRequest.Builder.forConsumer((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection());
        for (version = 0; version < 3; version = (short)(version + 1)) {
            short v = version;
            Assertions.assertThrows(UnsupportedVersionException.class, () -> builder.build(v));
        }
        for (version = 3; version < ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); version = (short)(version + 1)) {
            OffsetsForLeaderEpochRequest request = builder.build((short)3);
            Assertions.assertEquals((int)-1, (int)request.replicaId());
        }
    }

    @Test
    public void testDefaultReplicaId() {
        for (short version = 0; version < ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); version = (short)(version + 1)) {
            int replicaId = 1;
            OffsetsForLeaderEpochRequest.Builder builder = OffsetsForLeaderEpochRequest.Builder.forFollower((short)version, (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(), (int)replicaId);
            OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)builder.build();
            OffsetsForLeaderEpochRequest parsed = OffsetsForLeaderEpochRequest.parse((ByteBuffer)request.serialize(), (short)version);
            if (version < 3) {
                Assertions.assertEquals((int)-2, (int)parsed.replicaId());
                continue;
            }
            Assertions.assertEquals((int)replicaId, (int)parsed.replicaId());
        }
    }
}

