/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignorTest;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;

public class CooperativeStickyAssignorTest
extends AbstractStickyAssignorTest {
    @Override
    public AbstractStickyAssignor createAssignor() {
        return new CooperativeStickyAssignor();
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscription(List<String> topics, List<TopicPartition> partitions) {
        return new ConsumerPartitionAssignor.Subscription(topics, this.assignor.subscriptionUserData(new HashSet<String>(topics)), partitions);
    }

    @Override
    public void verifyValidityAndBalance(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments, Map<String, Integer> partitionsPerTopic) {
        int rebalances = 0;
        while (this.verifyCooperativeValidity(subscriptions, assignments)) {
            for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
                String consumer = entry.getKey();
                ConsumerPartitionAssignor.Subscription oldSubscription = subscriptions.get(consumer);
                subscriptions.put(consumer, this.buildSubscription(oldSubscription.topics(), entry.getValue()));
            }
            assignments.clear();
            assignments.putAll(this.assignor.assign(partitionsPerTopic, subscriptions));
            Assertions.assertTrue((++rebalances <= 4 ? 1 : 0) != 0);
        }
        super.verifyValidityAndBalance(subscriptions, assignments, partitionsPerTopic);
    }

    private boolean verifyCooperativeValidity(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        HashSet<TopicPartition> allAddedPartitions = new HashSet<TopicPartition>();
        HashSet allRevokedPartitions = new HashSet();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
            List ownedPartitions = subscriptions.get(entry.getKey()).ownedPartitions();
            List<TopicPartition> assignedPartitions = entry.getValue();
            HashSet revokedPartitions = new HashSet(ownedPartitions);
            revokedPartitions.removeAll(assignedPartitions);
            HashSet<TopicPartition> addedPartitions = new HashSet<TopicPartition>(assignedPartitions);
            addedPartitions.removeAll(ownedPartitions);
            allAddedPartitions.addAll(addedPartitions);
            allRevokedPartitions.addAll(revokedPartitions);
        }
        HashSet intersection = new HashSet(allAddedPartitions);
        intersection.retainAll(allRevokedPartitions);
        Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error: Some partitions were assigned to a new consumer during the same rebalance they are being revoked from their previous owner. Partitions: " + intersection));
        return !allRevokedPartitions.isEmpty();
    }
}

