/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerRecordTest {
    @Test
    public void testOldConstructor() {
        String topic = "topic";
        int partition = 0;
        long offset = 23L;
        String key = "key";
        String value = "value";
        ConsumerRecord record = new ConsumerRecord(topic, partition, offset, (Object)key, (Object)value);
        Assertions.assertEquals((Object)topic, (Object)record.topic());
        Assertions.assertEquals((int)partition, (int)record.partition());
        Assertions.assertEquals((long)offset, (long)record.offset());
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
        Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)record.timestampType());
        Assertions.assertEquals((long)-1L, (long)record.timestamp());
        Assertions.assertEquals((long)-1L, (long)record.checksum());
        Assertions.assertEquals((int)-1, (int)record.serializedKeySize());
        Assertions.assertEquals((int)-1, (int)record.serializedValueSize());
        Assertions.assertEquals(Optional.empty(), (Object)record.leaderEpoch());
        Assertions.assertEquals((Object)new RecordHeaders(), (Object)record.headers());
    }

    @Test
    public void testNullChecksumInConstructor() {
        String key = "key";
        String value = "value";
        long timestamp = 242341324L;
        ConsumerRecord record = new ConsumerRecord("topic", 0, 23L, timestamp, TimestampType.CREATE_TIME, null, key.length(), value.length(), (Object)key, (Object)value, (Headers)new RecordHeaders());
        Assertions.assertEquals((long)DefaultRecord.computePartialChecksum((long)timestamp, (int)key.length(), (int)value.length()), (long)record.checksum());
    }
}

