/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.interceptor;

import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkMetrics;
import org.apache.kafka.server.link.ClusterLinkRequestContext;

public class DefaultBrokerInterceptor
implements BrokerInterceptor {
    private final Time time;
    private ClusterLinkMetrics clusterLinkMetrics;

    public DefaultBrokerInterceptor() {
        this(Time.SYSTEM);
    }

    public DefaultBrokerInterceptor(Time time) {
        this.time = time;
    }

    @Override
    public void onAuthenticatedConnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
    }

    @Override
    public void onAuthenticatedDisconnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
    }

    @Override
    public RequestContext newContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Metrics metrics) {
        if (header.clusterLinkId().isPresent() || this.clusterLinkMetrics != null) {
            header.clusterLinkId().ifPresent(linkId -> {
                if (this.clusterLinkMetrics == null) {
                    this.clusterLinkMetrics = new ClusterLinkMetrics(metrics, (UUID)linkId);
                } else {
                    this.clusterLinkMetrics.ensureLinkId((UUID)linkId);
                }
            });
            return new ClusterLinkRequestContext(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation, this.time, this.clusterLinkMetrics);
        }
        return new RequestContext(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation);
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }

    ClusterLinkMetrics clusterLinkMetrics() {
        return this.clusterLinkMetrics;
    }
}

