/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractControlResponse;

public class StopReplicaResponse
extends AbstractControlResponse {
    private final StopReplicaResponseData data;

    public StopReplicaResponse(StopReplicaResponseData data) {
        this.data = data;
    }

    public StopReplicaResponse(Struct struct, short version) {
        this.data = new StopReplicaResponseData(struct, version);
    }

    public List<StopReplicaResponseData.StopReplicaPartitionError> partitions() {
        return this.data.partitionErrors();
    }

    @Override
    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<TopicPartition, Errors> partitionErrors() {
        HashMap<TopicPartition, Errors> partitionsErrors = new HashMap<TopicPartition, Errors>();
        this.data.partitionErrors().forEach(partitionError -> partitionsErrors.put(new TopicPartition(partitionError.topicName(), partitionError.partitionIndex()), Errors.forCode(partitionError.errorCode())));
        return partitionsErrors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(this.error(), this.data.partitionErrors().size());
        }
        return this.errorCounts(this.data.partitionErrors().stream().map(p -> Errors.forCode(p.errorCode())));
    }

    public static StopReplicaResponse parse(ByteBuffer buffer, short version) {
        return new StopReplicaResponse(ApiKeys.STOP_REPLICA.parseResponse(version, buffer), version);
    }

    public StopReplicaResponseData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

