/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.message.DescribeBrokerAdditionsRequestData;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsResponse;

public class DescribeBrokerAdditionsRequest
extends AbstractRequest {
    private DescribeBrokerAdditionsRequestData data;

    public DescribeBrokerAdditionsRequest(DescribeBrokerAdditionsRequestData data, short apiVersion) {
        super(ApiKeys.DESCRIBE_BROKER_ADDITIONS, apiVersion);
        this.data = data;
    }

    public DescribeBrokerAdditionsRequest(Struct struct, short apiVersion) {
        super(ApiKeys.DESCRIBE_BROKER_ADDITIONS, apiVersion);
        this.data = new DescribeBrokerAdditionsRequestData(struct, apiVersion);
    }

    public static DescribeBrokerAdditionsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeBrokerAdditionsRequest(ApiKeys.DESCRIBE_BROKER_ADDITIONS.parseRequest(version, buffer), version);
    }

    public DescribeBrokerAdditionsRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public DescribeBrokerAdditionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        DescribeBrokerAdditionsResponseData responseData = new DescribeBrokerAdditionsResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setBrokerAdditions(Collections.emptyList()).setThrottleTimeMs(throttleTimeMs);
        return new DescribeBrokerAdditionsResponse(responseData);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeBrokerAdditionsRequest> {
        private final DescribeBrokerAdditionsRequestData data = new DescribeBrokerAdditionsRequestData();

        public Builder() {
            super(ApiKeys.DESCRIBE_BROKER_ADDITIONS);
        }

        @Override
        public DescribeBrokerAdditionsRequest build(short version) {
            return new DescribeBrokerAdditionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

