/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteGroupsResponse
extends AbstractResponse {
    public final DeleteGroupsResponseData data;

    public DeleteGroupsResponse(DeleteGroupsResponseData data) {
        this.data = data;
    }

    public DeleteGroupsResponse(Struct struct, short version) {
        this.data = new DeleteGroupsResponseData(struct, version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errorMap = new HashMap<String, Errors>();
        for (DeleteGroupsResponseData.DeletableGroupResult result : this.data.results()) {
            errorMap.put(result.groupId(), Errors.forCode(result.errorCode()));
        }
        return errorMap;
    }

    public Errors get(String group) throws IllegalArgumentException {
        DeleteGroupsResponseData.DeletableGroupResult result = this.data.results().find(group);
        if (result == null) {
            throw new IllegalArgumentException("could not find group " + group + " in the delete group response");
        }
        return Errors.forCode(result.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> this.updateErrorCounts(counts, Errors.forCode(result.errorCode())));
        return counts;
    }

    public static DeleteGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsResponse(ApiKeys.DELETE_GROUPS.parseResponse(version, buffer), version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

