/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Optional;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerRemovalError;

public class BrokerRemovalDescription {
    private final Integer brokerId;
    private final BalancerOperationStatus generalOperationStatus;
    private final BrokerShutdownStatus brokerShutdownStatus;
    private final PartitionReassignmentsStatus partitionReassignmentsStatus;
    private final Optional<BrokerRemovalError> removalError;
    private final long createTimeMs;
    private final long lastUpdateTimeMs;

    @Deprecated
    public BrokerRemovalDescription(Integer brokerId, BrokerShutdownStatus brokerShutdownStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, Optional<BrokerRemovalError> removalError) {
        this(brokerId, null, brokerShutdownStatus.toNewStatus(), partitionReassignmentsStatus.toNewStatus(), removalError, -1L, -1L);
    }

    public BrokerRemovalDescription(Integer brokerId, BalancerOperationStatus generalOperationStatus, org.apache.kafka.clients.admin.BrokerShutdownStatus brokerShutdownStatus, org.apache.kafka.clients.admin.PartitionReassignmentsStatus partitionReassignmentsStatus, Optional<BrokerRemovalError> removalError, long createTimeMs, long lastUpdateTimeMs) {
        this.brokerId = brokerId;
        this.brokerShutdownStatus = brokerShutdownStatus.toOldStatus();
        this.partitionReassignmentsStatus = partitionReassignmentsStatus.toOldStatus();
        this.removalError = removalError;
        this.createTimeMs = createTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimeMs;
        this.generalOperationStatus = generalOperationStatus;
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    public long createTimeMs() {
        return this.createTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public BalancerOperationStatus generalOperationStatus() {
        return this.generalOperationStatus;
    }

    @Deprecated
    public BrokerShutdownStatus brokerShutdownStatus() {
        return this.brokerShutdownStatus;
    }

    public org.apache.kafka.clients.admin.BrokerShutdownStatus shutdownStatus() {
        return this.brokerShutdownStatus.toNewStatus();
    }

    @Deprecated
    public PartitionReassignmentsStatus partitionReassignmentsStatus() {
        return this.partitionReassignmentsStatus;
    }

    public org.apache.kafka.clients.admin.PartitionReassignmentsStatus reassignmentsStatus() {
        return this.partitionReassignmentsStatus.toNewStatus();
    }

    public Optional<BrokerRemovalError> removalError() {
        return this.removalError;
    }

    public Optional<BalancerOperationError> error() {
        return Optional.ofNullable(this.removalError.orElse(null));
    }

    public String toString() {
        return "BrokerRemovalDescription{brokerId=" + this.brokerId + ", brokerShutdownStatus=" + (Object)((Object)this.brokerShutdownStatus) + ", partitionReassignmentsStatus=" + (Object)((Object)this.partitionReassignmentsStatus) + ", removalError=" + this.removalError + ", createTime=" + ClientUtils.utcDateFor(this.createTimeMs) + ", updateTime=" + ClientUtils.utcDateFor(this.lastUpdateTimeMs) + "}";
    }

    @Deprecated
    public static enum PartitionReassignmentsStatus {
        CANCELED{

            @Override
            public org.apache.kafka.clients.admin.PartitionReassignmentsStatus toNewStatus() {
                return org.apache.kafka.clients.admin.PartitionReassignmentsStatus.CANCELED;
            }
        }
        ,
        FAILED{

            @Override
            public org.apache.kafka.clients.admin.PartitionReassignmentsStatus toNewStatus() {
                return org.apache.kafka.clients.admin.PartitionReassignmentsStatus.ERROR;
            }
        }
        ,
        PENDING{

            @Override
            public org.apache.kafka.clients.admin.PartitionReassignmentsStatus toNewStatus() {
                return org.apache.kafka.clients.admin.PartitionReassignmentsStatus.PENDING;
            }
        }
        ,
        IN_PROGRESS{

            @Override
            public org.apache.kafka.clients.admin.PartitionReassignmentsStatus toNewStatus() {
                return org.apache.kafka.clients.admin.PartitionReassignmentsStatus.IN_PROGRESS;
            }
        }
        ,
        COMPLETE{

            @Override
            public org.apache.kafka.clients.admin.PartitionReassignmentsStatus toNewStatus() {
                return org.apache.kafka.clients.admin.PartitionReassignmentsStatus.COMPLETED;
            }
        };


        public abstract org.apache.kafka.clients.admin.PartitionReassignmentsStatus toNewStatus();
    }

    @Deprecated
    public static enum BrokerShutdownStatus {
        FAILED{

            @Override
            public org.apache.kafka.clients.admin.BrokerShutdownStatus toNewStatus() {
                return org.apache.kafka.clients.admin.BrokerShutdownStatus.ERROR;
            }
        }
        ,
        CANCELED{

            @Override
            public org.apache.kafka.clients.admin.BrokerShutdownStatus toNewStatus() {
                return org.apache.kafka.clients.admin.BrokerShutdownStatus.CANCELED;
            }
        }
        ,
        PENDING{

            @Override
            public org.apache.kafka.clients.admin.BrokerShutdownStatus toNewStatus() {
                return org.apache.kafka.clients.admin.BrokerShutdownStatus.PENDING;
            }
        }
        ,
        COMPLETE{

            @Override
            public org.apache.kafka.clients.admin.BrokerShutdownStatus toNewStatus() {
                return org.apache.kafka.clients.admin.BrokerShutdownStatus.COMPLETED;
            }
        };


        public abstract org.apache.kafka.clients.admin.BrokerShutdownStatus toNewStatus();
    }
}

