/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;

public class DeleteClusterLinksRequest
extends AbstractRequest {
    private final DeleteClusterLinksRequestData data;

    public DeleteClusterLinksRequest(DeleteClusterLinksRequestData data, short version) {
        super(ApiKeys.DELETE_CLUSTER_LINKS, version);
        this.data = data;
    }

    public DeleteClusterLinksRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_CLUSTER_LINKS, version);
        this.data = new DeleteClusterLinksRequestData(struct, version);
    }

    public Collection<String> linkNames() {
        return this.data.linkNames();
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    public boolean force() {
        return this.data.force();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public DeleteClusterLinksResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DeleteClusterLinksResponse(this.data.linkNames(), throttleTimeMs, e);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteClusterLinksRequest> {
        private final DeleteClusterLinksRequestData data;

        public Builder(Collection<String> linkNames, boolean validateOnly, boolean force, int timeoutMs) {
            super(ApiKeys.DELETE_CLUSTER_LINKS);
            this.data = new DeleteClusterLinksRequestData().setLinkNames(new ArrayList<String>(linkNames)).setValidateOnly(validateOnly).setForce(force).setTimeoutMs(timeoutMs);
        }

        @Override
        public DeleteClusterLinksRequest build(short version) {
            return new DeleteClusterLinksRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

