/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class LeaderAndIsrRequestData
implements ApiMessage {
    private int controllerId;
    private int controllerEpoch;
    private long brokerEpoch;
    private List<LeaderAndIsrPartitionState> ungroupedPartitionStates;
    private List<LeaderAndIsrTopicState> topicStates;
    private List<LeaderAndIsrLiveLeader> liveLeaders;
    private boolean containsAllReplicas;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_0), "The state of each partition, in a v0 or v1 message."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_1), "The state of each partition, in a v0 or v1 message."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrTopicState.SCHEMA_2), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrTopicState.SCHEMA_3), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_4 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new CompactArrayOf(LeaderAndIsrTopicState.SCHEMA_4), "Each topic."), new Field("live_leaders", new CompactArrayOf(LeaderAndIsrLiveLeader.SCHEMA_4), "The current live leaders."), Field.TaggedFieldsSection.of(10000, new Field("contains_all_replicas", Type.BOOLEAN, "Whether this request contains all replicas hosted by the broker.")));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};

    public LeaderAndIsrRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaderAndIsrRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public LeaderAndIsrRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        this.topicStates = new ArrayList<LeaderAndIsrTopicState>(0);
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>(0);
        this.containsAllReplicas = false;
    }

    @Override
    public short apiKey() {
        return 4;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<LeaderAndIsrPartitionState> newCollection;
        int arrayLength;
        this.controllerId = _readable.readInt();
        this.controllerEpoch = _readable.readInt();
        this.brokerEpoch = _version >= 2 ? _readable.readLong() : -1L;
        if (_version <= 1) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ungroupedPartitionStates was serialized as null");
            }
            newCollection = new ArrayList<LeaderAndIsrPartitionState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
            }
            this.ungroupedPartitionStates = newCollection;
        } else {
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        }
        if (_version >= 2) {
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>(0);
        }
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveLeaders was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrLiveLeader(_readable, _version)));
            }
            this.liveLeaders = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveLeaders was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrLiveLeader(_readable, _version)));
            }
            this.liveLeaders = newCollection;
        }
        this.containsAllReplicas = false;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block8: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        this.containsAllReplicas = _readable.readByte() != 0;
                        continue block8;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        _writable.writeInt(this.controllerEpoch);
        if (_version >= 2) {
            _writable.writeLong(this.brokerEpoch);
        }
        if (_version <= 1) {
            _writable.writeInt(this.ungroupedPartitionStates.size());
            for (LeaderAndIsrPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.write(_writable, _cache, _version);
            }
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 2) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.topicStates.size() + 1);
                for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.topicStates.size());
                for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.liveLeaders.size() + 1);
            for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
                liveLeadersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.liveLeaders.size());
            for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
                liveLeadersElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 4 && this.containsAllReplicas) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (this.containsAllReplicas) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.containsAllReplicas ? (byte)1 : 0);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        Object[] _nestedObjects;
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.controllerId = struct.getInt("controller_id");
        this.controllerEpoch = struct.getInt("controller_epoch");
        this.brokerEpoch = _version >= 2 ? struct.getLong("broker_epoch") : -1L;
        if (_version <= 1) {
            _nestedObjects = struct.getArray("ungrouped_partition_states");
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.ungroupedPartitionStates.add(new LeaderAndIsrPartitionState((Struct)nestedObject, _version));
            }
        } else {
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        }
        if (_version >= 2) {
            _nestedObjects = struct.getArray("topic_states");
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topicStates.add(new LeaderAndIsrTopicState((Struct)nestedObject, _version));
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>(0);
        }
        _nestedObjects = struct.getArray("live_leaders");
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.liveLeaders.add(new LeaderAndIsrLiveLeader((Struct)nestedObject, _version));
        }
        this.containsAllReplicas = _version >= 4 ? (_taggedFields.containsKey(10000) ? (Boolean)_taggedFields.remove(10000) : false) : false;
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        int i;
        Struct[] _nestedObjects;
        TreeMap<Integer, Boolean> _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap<Integer, Boolean>();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("controller_id", (Object)this.controllerId);
        struct.set("controller_epoch", (Object)this.controllerEpoch);
        if (_version >= 2) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        if (_version <= 1) {
            _nestedObjects = new Struct[this.ungroupedPartitionStates.size()];
            i = 0;
            for (LeaderAndIsrPartitionState leaderAndIsrPartitionState : this.ungroupedPartitionStates) {
                _nestedObjects[i++] = leaderAndIsrPartitionState.toStruct(_version);
            }
            struct.set("ungrouped_partition_states", (Object)_nestedObjects);
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 2) {
            _nestedObjects = new Struct[this.topicStates.size()];
            i = 0;
            for (LeaderAndIsrTopicState leaderAndIsrTopicState : this.topicStates) {
                _nestedObjects[i++] = leaderAndIsrTopicState.toStruct(_version);
            }
            struct.set("topic_states", (Object)_nestedObjects);
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        _nestedObjects = new Struct[this.liveLeaders.size()];
        i = 0;
        for (LeaderAndIsrLiveLeader leaderAndIsrLiveLeader : this.liveLeaders) {
            _nestedObjects[i++] = leaderAndIsrLiveLeader.toStruct(_version);
        }
        struct.set("live_leaders", (Object)_nestedObjects);
        if (_version >= 4 && this.containsAllReplicas) {
            _taggedFields.put(10000, this.containsAllReplicas);
        }
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _arraySize;
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 4;
        if (_version >= 2) {
            _size += 8;
        }
        if (_version <= 1) {
            _arraySize = 0;
            _arraySize += 4;
            for (LeaderAndIsrPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                _arraySize += ungroupedPartitionStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 2) {
            _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topicStates.size() + 1)) : (_arraySize += 4);
            for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                _arraySize += topicStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        _arraySize = 0;
        _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.liveLeaders.size() + 1)) : (_arraySize += 4);
        for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
            _arraySize += liveLeadersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 4 && this.containsAllReplicas) {
            ++_numTaggedFields;
            _size += 2;
            ++_size;
            ++_size;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderAndIsrRequestData)) {
            return false;
        }
        LeaderAndIsrRequestData other = (LeaderAndIsrRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.ungroupedPartitionStates == null ? other.ungroupedPartitionStates != null : !this.ungroupedPartitionStates.equals(other.ungroupedPartitionStates)) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        if (this.liveLeaders == null ? other.liveLeaders != null : !this.liveLeaders.equals(other.liveLeaders)) {
            return false;
        }
        return this.containsAllReplicas == other.containsAllReplicas;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.ungroupedPartitionStates == null ? 0 : this.ungroupedPartitionStates.hashCode());
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.liveLeaders == null ? 0 : this.liveLeaders.hashCode());
        hashCode = 31 * hashCode + (this.containsAllReplicas ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public LeaderAndIsrRequestData duplicate() {
        LeaderAndIsrRequestData _duplicate = new LeaderAndIsrRequestData();
        _duplicate.controllerId = this.controllerId;
        _duplicate.controllerEpoch = this.controllerEpoch;
        _duplicate.brokerEpoch = this.brokerEpoch;
        ArrayList<LeaderAndIsrPartitionState> newUngroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(this.ungroupedPartitionStates.size());
        for (LeaderAndIsrPartitionState leaderAndIsrPartitionState : this.ungroupedPartitionStates) {
            newUngroupedPartitionStates.add(leaderAndIsrPartitionState.duplicate());
        }
        _duplicate.ungroupedPartitionStates = newUngroupedPartitionStates;
        ArrayList<LeaderAndIsrTopicState> newTopicStates = new ArrayList<LeaderAndIsrTopicState>(this.topicStates.size());
        for (LeaderAndIsrTopicState _element : this.topicStates) {
            newTopicStates.add(_element.duplicate());
        }
        _duplicate.topicStates = newTopicStates;
        ArrayList<LeaderAndIsrLiveLeader> arrayList = new ArrayList<LeaderAndIsrLiveLeader>(this.liveLeaders.size());
        for (LeaderAndIsrLiveLeader _element : this.liveLeaders) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.liveLeaders = arrayList;
        _duplicate.containsAllReplicas = this.containsAllReplicas;
        return _duplicate;
    }

    public String toString() {
        return "LeaderAndIsrRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", ungroupedPartitionStates=" + MessageUtil.deepToString(this.ungroupedPartitionStates.iterator()) + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", liveLeaders=" + MessageUtil.deepToString(this.liveLeaders.iterator()) + ", containsAllReplicas=" + (this.containsAllReplicas ? "true" : "false") + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<LeaderAndIsrPartitionState> ungroupedPartitionStates() {
        return this.ungroupedPartitionStates;
    }

    public List<LeaderAndIsrTopicState> topicStates() {
        return this.topicStates;
    }

    public List<LeaderAndIsrLiveLeader> liveLeaders() {
        return this.liveLeaders;
    }

    public boolean containsAllReplicas() {
        return this.containsAllReplicas;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaderAndIsrRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public LeaderAndIsrRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setUngroupedPartitionStates(List<LeaderAndIsrPartitionState> v) {
        this.ungroupedPartitionStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setTopicStates(List<LeaderAndIsrTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setLiveLeaders(List<LeaderAndIsrLiveLeader> v) {
        this.liveLeaders = v;
        return this;
    }

    public LeaderAndIsrRequestData setContainsAllReplicas(boolean v) {
        this.containsAllReplicas = v;
        return this;
    }

    public static class LeaderAndIsrPartitionState
    implements Message {
        private String topicName;
        private UUID topicId;
        private String clusterLinkId;
        private String clusterLinkTopicState;
        private int linkedLeaderEpoch;
        private int partitionIndex;
        private int controllerEpoch;
        private int leader;
        private boolean confluentIsUncleanLeader;
        private int leaderEpoch;
        private List<Integer> isr;
        private int zkVersion;
        private List<Integer> replicas;
        private List<Integer> observers;
        private List<Integer> addingReplicas;
        private List<Integer> removingReplicas;
        private boolean isNew;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name.  This is only present in v0 or v1."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.STRING, "The topic name.  This is only present in v0 or v1."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new ArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new ArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_4 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new CompactArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new CompactArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."), Field.TaggedFieldsSection.of(10001, new Field("topic_id", Type.UUID, "The topic ID"), 10003, new Field("cluster_link_id", Type.COMPACT_NULLABLE_STRING, "Cluster link ID if this topic is being mirrored."), 10004, new Field("cluster_link_topic_state", Type.COMPACT_NULLABLE_STRING, "Cluster link state if this topic is being mirrored."), 10005, new Field("linked_leader_epoch", Type.INT32, "Source leader epoch if this topic is being mirrored."), 10002, new Field("confluent_is_unclean_leader", Type.BOOLEAN, "Whether the elected leader is unclean."), 10000, new Field("observers", new CompactArrayOf(Type.INT32), "The brokers in Replicas that are observers in a partition.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};

        public LeaderAndIsrPartitionState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrPartitionState(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public LeaderAndIsrPartitionState() {
            this.topicName = "";
            this.topicId = MessageUtil.ZERO_UUID;
            this.clusterLinkId = null;
            this.clusterLinkTopicState = null;
            this.linkedLeaderEpoch = -1;
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.confluentIsUncleanLeader = false;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>(0);
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>(0);
            this.observers = new ArrayList<Integer>(0);
            this.addingReplicas = new ArrayList<Integer>(0);
            this.removingReplicas = new ArrayList<Integer>(0);
            this.isNew = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            if (_version <= 1) {
                short length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _readable.readString(length);
            } else {
                this.topicName = "";
            }
            this.topicId = MessageUtil.ZERO_UUID;
            this.clusterLinkId = null;
            this.clusterLinkTopicState = null;
            this.linkedLeaderEpoch = -1;
            this.partitionIndex = _readable.readInt();
            this.controllerEpoch = _readable.readInt();
            this.leader = _readable.readInt();
            this.confluentIsUncleanLeader = false;
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isr was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isr = newCollection;
            this.zkVersion = _readable.readInt();
            arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicas was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicas = newCollection;
            this.observers = new ArrayList<Integer>(0);
            if (_version >= 3) {
                arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field addingReplicas was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.addingReplicas = newCollection;
            } else {
                this.addingReplicas = new ArrayList<Integer>(0);
            }
            if (_version >= 3) {
                arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field removingReplicas was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.removingReplicas = newCollection;
            } else {
                this.removingReplicas = new ArrayList<Integer>(0);
            }
            this.isNew = _version >= 1 ? _readable.readByte() != 0 : false;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block12: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10001: {
                            this.topicId = _readable.readUUID();
                            continue block12;
                        }
                        case 10003: {
                            int length = _readable.readUnsignedVarint() - 1;
                            if (length < 0) {
                                this.clusterLinkId = null;
                                continue block12;
                            }
                            if (length > Short.MAX_VALUE) {
                                throw new RuntimeException("string field clusterLinkId had invalid length " + length);
                            }
                            this.clusterLinkId = _readable.readString(length);
                            continue block12;
                        }
                        case 10004: {
                            int length = _readable.readUnsignedVarint() - 1;
                            if (length < 0) {
                                this.clusterLinkTopicState = null;
                                continue block12;
                            }
                            if (length > Short.MAX_VALUE) {
                                throw new RuntimeException("string field clusterLinkTopicState had invalid length " + length);
                            }
                            this.clusterLinkTopicState = _readable.readString(length);
                            continue block12;
                        }
                        case 10005: {
                            this.linkedLeaderEpoch = _readable.readInt();
                            continue block12;
                        }
                        case 10002: {
                            this.confluentIsUncleanLeader = _readable.readByte() != 0;
                            continue block12;
                        }
                        case 10000: {
                            int arrayLength2 = _readable.readUnsignedVarint() - 1;
                            if (arrayLength2 < 0) {
                                throw new RuntimeException("non-nullable field observers was serialized as null");
                            }
                            ArrayList<Integer> newCollection2 = new ArrayList<Integer>(arrayLength2);
                            for (int i2 = 0; i2 < arrayLength2; ++i2) {
                                newCollection2.add(_readable.readInt());
                            }
                            this.observers = newCollection2;
                            continue block12;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 1) {
                _stringBytes = _cache.getSerializedValue(this.topicName);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 4 && this.topicId != MessageUtil.ZERO_UUID) {
                ++_numTaggedFields;
            }
            if (_version >= 4 && this.clusterLinkId != null) {
                ++_numTaggedFields;
            }
            if (_version >= 4) {
                if (this.clusterLinkTopicState != null) {
                    ++_numTaggedFields;
                }
            } else if (this.clusterLinkTopicState != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clusterLinkTopicState at version " + _version);
            }
            if (_version >= 4) {
                if (this.linkedLeaderEpoch != -1) {
                    ++_numTaggedFields;
                }
            } else if (this.linkedLeaderEpoch != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default linkedLeaderEpoch at version " + _version);
            }
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.controllerEpoch);
            _writable.writeInt(this.leader);
            if (_version >= 4 && this.confluentIsUncleanLeader) {
                ++_numTaggedFields;
            }
            _writable.writeInt(this.leaderEpoch);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.isr.size() + 1);
            } else {
                _writable.writeInt(this.isr.size());
            }
            _stringBytes = this.isr.iterator();
            while (_stringBytes.hasNext()) {
                Integer n = (Integer)_stringBytes.next();
                _writable.writeInt(n);
            }
            _writable.writeInt(this.zkVersion);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.replicas.size() + 1);
            } else {
                _writable.writeInt(this.replicas.size());
            }
            for (Integer n : this.replicas) {
                _writable.writeInt(n);
            }
            if (_version >= 4 && !this.observers.isEmpty()) {
                ++_numTaggedFields;
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.addingReplicas.size());
                }
                for (Integer n : this.addingReplicas) {
                    _writable.writeInt(n);
                }
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.removingReplicas.size());
                }
                for (Integer n : this.removingReplicas) {
                    _writable.writeInt(n);
                }
            }
            if (_version >= 1) {
                _writable.writeByte(this.isNew ? (byte)1 : 0);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.observers.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers));
                    _writable.writeUnsignedVarint(this.observers.size() + 1);
                    for (Integer observersElement : this.observers) {
                        _writable.writeInt(observersElement);
                    }
                }
                if (this.topicId != MessageUtil.ZERO_UUID) {
                    _writable.writeUnsignedVarint(10001);
                    _writable.writeUnsignedVarint(16);
                    _writable.writeUUID(this.topicId);
                }
                if (this.confluentIsUncleanLeader) {
                    _writable.writeUnsignedVarint(10002);
                    _writable.writeUnsignedVarint(1);
                    _writable.writeByte(this.confluentIsUncleanLeader ? (byte)1 : 0);
                }
                if (this.clusterLinkId != null) {
                    _writable.writeUnsignedVarint(10003);
                    byte[] byArray = _cache.getSerializedValue(this.clusterLinkId);
                    _writable.writeUnsignedVarint(byArray.length + ByteUtils.sizeOfUnsignedVarint(byArray.length + 1));
                    _writable.writeUnsignedVarint(byArray.length + 1);
                    _writable.writeByteArray(byArray);
                }
                if (this.clusterLinkTopicState != null) {
                    _writable.writeUnsignedVarint(10004);
                    byte[] byArray = _cache.getSerializedValue(this.clusterLinkTopicState);
                    _writable.writeUnsignedVarint(byArray.length + ByteUtils.sizeOfUnsignedVarint(byArray.length + 1));
                    _writable.writeUnsignedVarint(byArray.length + 1);
                    _writable.writeByteArray(byArray);
                }
                if (this.linkedLeaderEpoch != -1) {
                    _writable.writeUnsignedVarint(10005);
                    _writable.writeUnsignedVarint(4);
                    _writable.writeInt(this.linkedLeaderEpoch);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = _version <= 1 ? struct.getString("topic_name") : "";
            this.topicId = _version >= 4 ? (_taggedFields.containsKey(10001) ? (UUID)_taggedFields.remove(10001) : MessageUtil.ZERO_UUID) : MessageUtil.ZERO_UUID;
            this.clusterLinkId = _version >= 4 ? (_taggedFields.containsKey(10003) ? (String)_taggedFields.remove(10003) : null) : null;
            this.clusterLinkTopicState = _version >= 4 ? (_taggedFields.containsKey(10004) ? (String)_taggedFields.remove(10004) : null) : null;
            this.linkedLeaderEpoch = _version >= 4 ? (_taggedFields.containsKey(10005) ? (Integer)_taggedFields.remove(10005) : -1) : -1;
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leader = struct.getInt("leader");
            this.confluentIsUncleanLeader = _version >= 4 ? (_taggedFields.containsKey(10002) ? (Boolean)_taggedFields.remove(10002) : false) : false;
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] _nestedObjects = struct.getArray("isr");
            this.isr = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.isr.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            _nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            if (_version >= 4) {
                if (_taggedFields.containsKey(10000)) {
                    _nestedObjects = (Object[])_taggedFields.remove(10000);
                    this.observers = new ArrayList<Integer>(_nestedObjects.length);
                    for (Object nestedObject : _nestedObjects) {
                        this.observers.add((Integer)nestedObject);
                    }
                } else {
                    this.observers = new ArrayList<Integer>(0);
                }
            } else {
                this.observers = new ArrayList<Integer>(0);
            }
            if (_version >= 3) {
                _nestedObjects = struct.getArray("adding_replicas");
                this.addingReplicas = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.addingReplicas.add((Integer)nestedObject);
                }
            } else {
                this.addingReplicas = new ArrayList<Integer>(0);
            }
            if (_version >= 3) {
                _nestedObjects = struct.getArray("removing_replicas");
                this.removingReplicas = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.removingReplicas.add((Integer)nestedObject);
                }
            } else {
                this.removingReplicas = new ArrayList<Integer>(0);
            }
            this.isNew = _version >= 1 ? struct.getBoolean("is_new") : false;
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            TreeMap<Integer, Object> _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap<Integer, Object>();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            if (_version <= 1) {
                struct.set("topic_name", (Object)this.topicName);
            }
            if (_version >= 4 && this.topicId != MessageUtil.ZERO_UUID) {
                _taggedFields.put(10001, this.topicId);
            }
            if (_version >= 4 && this.clusterLinkId != null) {
                _taggedFields.put(10003, this.clusterLinkId);
            }
            if (_version >= 4) {
                if (this.clusterLinkTopicState != null) {
                    _taggedFields.put(10004, this.clusterLinkTopicState);
                }
            } else if (this.clusterLinkTopicState != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clusterLinkTopicState at version " + _version);
            }
            if (_version >= 4) {
                if (this.linkedLeaderEpoch != -1) {
                    _taggedFields.put(10005, this.linkedLeaderEpoch);
                }
            } else if (this.linkedLeaderEpoch != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default linkedLeaderEpoch at version " + _version);
            }
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader", (Object)this.leader);
            if (_version >= 4 && this.confluentIsUncleanLeader) {
                _taggedFields.put(10002, this.confluentIsUncleanLeader);
            }
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] _nestedObjects = new Integer[this.isr.size()];
            int i = 0;
            for (Integer element : this.isr) {
                _nestedObjects[i++] = element;
            }
            struct.set("isr", (Object)_nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            _nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                _nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)_nestedObjects);
            if (_version >= 4 && !this.observers.isEmpty()) {
                _nestedObjects = new Integer[this.observers.size()];
                i = 0;
                for (Integer element : this.observers) {
                    _nestedObjects[i++] = element;
                }
                _taggedFields.put(10000, _nestedObjects);
            }
            if (_version >= 3) {
                _nestedObjects = new Integer[this.addingReplicas.size()];
                i = 0;
                for (Integer element : this.addingReplicas) {
                    _nestedObjects[i++] = element;
                }
                struct.set("adding_replicas", (Object)_nestedObjects);
            }
            if (_version >= 3) {
                _nestedObjects = new Integer[this.removingReplicas.size()];
                i = 0;
                for (Integer element : this.removingReplicas) {
                    _nestedObjects[i++] = element;
                }
                struct.set("removing_replicas", (Object)_nestedObjects);
            }
            if (_version >= 1) {
                struct.set("is_new", (Object)this.isNew);
            }
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _stringPrefixSize;
            byte[] _stringBytes;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version <= 1) {
                _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (_version >= 4 && this.topicId != MessageUtil.ZERO_UUID) {
                ++_numTaggedFields;
                _size += 2;
                ++_size;
                _size += 16;
            }
            if (_version >= 4 && this.clusterLinkId != null) {
                ++_numTaggedFields;
                _size += 2;
                _stringBytes = this.clusterLinkId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterLinkId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterLinkId, _stringBytes);
                _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize);
            }
            if (_version >= 4 && this.clusterLinkTopicState != null) {
                ++_numTaggedFields;
                _size += 2;
                _stringBytes = this.clusterLinkTopicState.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterLinkTopicState' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterLinkTopicState, _stringBytes);
                _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize);
            }
            if (_version >= 4 && this.linkedLeaderEpoch != -1) {
                ++_numTaggedFields;
                _size += 2;
                ++_size;
                _size += 4;
            }
            _size += 4;
            _size += 4;
            _size += 4;
            if (_version >= 4 && this.confluentIsUncleanLeader) {
                ++_numTaggedFields;
                _size += 2;
                ++_size;
                ++_size;
            }
            _size += 4;
            int _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.isr.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.isr.size() * 4);
            _size += 4;
            _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.replicas.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.replicas.size() * 4);
            if (_version >= 4 && !this.observers.isEmpty()) {
                ++_numTaggedFields;
                _size += 2;
                _arraySize = 0;
                _arraySize += ByteUtils.sizeOfUnsignedVarint(this.observers.size() + 1);
                _cache.setArraySizeInBytes(this.observers, _arraySize += this.observers.size() * 4);
                _size += _arraySize + ByteUtils.sizeOfUnsignedVarint(_arraySize);
            }
            if (_version >= 3) {
                _arraySize = 0;
                _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.addingReplicas.size() + 1)) : (_arraySize += 4);
                _size += (_arraySize += this.addingReplicas.size() * 4);
            }
            if (_version >= 3) {
                _arraySize = 0;
                _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.removingReplicas.size() + 1)) : (_arraySize += 4);
                _size += (_arraySize += this.removingReplicas.size() * 4);
            }
            if (_version >= 1) {
                ++_size;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrPartitionState)) {
                return false;
            }
            LeaderAndIsrPartitionState other = (LeaderAndIsrPartitionState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.clusterLinkId == null ? other.clusterLinkId != null : !this.clusterLinkId.equals(other.clusterLinkId)) {
                return false;
            }
            if (this.clusterLinkTopicState == null ? other.clusterLinkTopicState != null : !this.clusterLinkTopicState.equals(other.clusterLinkTopicState)) {
                return false;
            }
            if (this.linkedLeaderEpoch != other.linkedLeaderEpoch) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.confluentIsUncleanLeader != other.confluentIsUncleanLeader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
                return false;
            }
            if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
                return false;
            }
            return this.isNew == other.isNew;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.clusterLinkId == null ? 0 : this.clusterLinkId.hashCode());
            hashCode = 31 * hashCode + (this.clusterLinkTopicState == null ? 0 : this.clusterLinkTopicState.hashCode());
            hashCode = 31 * hashCode + this.linkedLeaderEpoch;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + (this.confluentIsUncleanLeader ? 1231 : 1237);
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.isNew ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public LeaderAndIsrPartitionState duplicate() {
            LeaderAndIsrPartitionState _duplicate = new LeaderAndIsrPartitionState();
            _duplicate.topicName = this.topicName;
            _duplicate.topicId = this.topicId;
            _duplicate.clusterLinkId = this.clusterLinkId == null ? null : this.clusterLinkId;
            _duplicate.clusterLinkTopicState = this.clusterLinkTopicState == null ? null : this.clusterLinkTopicState;
            _duplicate.linkedLeaderEpoch = this.linkedLeaderEpoch;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.controllerEpoch = this.controllerEpoch;
            _duplicate.leader = this.leader;
            _duplicate.confluentIsUncleanLeader = this.confluentIsUncleanLeader;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
            for (Integer n : this.isr) {
                newIsr.add(n);
            }
            _duplicate.isr = newIsr;
            _duplicate.zkVersion = this.zkVersion;
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer n : this.replicas) {
                newReplicas.add(n);
            }
            _duplicate.replicas = newReplicas;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.observers.size());
            for (Integer n : this.observers) {
                arrayList.add(n);
            }
            _duplicate.observers = arrayList;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.addingReplicas.size());
            for (Integer _element : this.addingReplicas) {
                arrayList2.add(_element);
            }
            _duplicate.addingReplicas = arrayList2;
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(this.removingReplicas.size());
            for (Integer _element : this.removingReplicas) {
                arrayList3.add(_element);
            }
            _duplicate.removingReplicas = arrayList3;
            _duplicate.isNew = this.isNew;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrPartitionState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", clusterLinkId=" + (this.clusterLinkId == null ? "null" : "'" + this.clusterLinkId.toString() + "'") + ", clusterLinkTopicState=" + (this.clusterLinkTopicState == null ? "null" : "'" + this.clusterLinkTopicState.toString() + "'") + ", linkedLeaderEpoch=" + this.linkedLeaderEpoch + ", partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", confluentIsUncleanLeader=" + (this.confluentIsUncleanLeader ? "true" : "false") + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ", isNew=" + (this.isNew ? "true" : "false") + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public UUID topicId() {
            return this.topicId;
        }

        public String clusterLinkId() {
            return this.clusterLinkId;
        }

        public String clusterLinkTopicState() {
            return this.clusterLinkTopicState;
        }

        public int linkedLeaderEpoch() {
            return this.linkedLeaderEpoch;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public boolean confluentIsUncleanLeader() {
            return this.confluentIsUncleanLeader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<Integer> addingReplicas() {
            return this.addingReplicas;
        }

        public List<Integer> removingReplicas() {
            return this.removingReplicas;
        }

        public boolean isNew() {
            return this.isNew;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrPartitionState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrPartitionState setTopicId(UUID v) {
            this.topicId = v;
            return this;
        }

        public LeaderAndIsrPartitionState setClusterLinkId(String v) {
            this.clusterLinkId = v;
            return this;
        }

        public LeaderAndIsrPartitionState setClusterLinkTopicState(String v) {
            this.clusterLinkTopicState = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLinkedLeaderEpoch(int v) {
            this.linkedLeaderEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public LeaderAndIsrPartitionState setConfluentIsUncleanLeader(boolean v) {
            this.confluentIsUncleanLeader = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public LeaderAndIsrPartitionState setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public LeaderAndIsrPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }

        public LeaderAndIsrPartitionState setAddingReplicas(List<Integer> v) {
            this.addingReplicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setRemovingReplicas(List<Integer> v) {
            this.removingReplicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setIsNew(boolean v) {
            this.isNew = v;
            return this;
        }
    }

    public static class LeaderAndIsrLiveLeader
    implements Message {
        private int brokerId;
        private String hostName;
        private int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;

        public LeaderAndIsrLiveLeader(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrLiveLeader(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public LeaderAndIsrLiveLeader() {
            this.brokerId = 0;
            this.hostName = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrLiveLeader");
            }
            this.brokerId = _readable.readInt();
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field hostName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field hostName had invalid length " + length);
            }
            this.hostName = _readable.readString(length);
            this.port = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue(this.hostName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrLiveLeader");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.brokerId = struct.getInt("broker_id");
            this.hostName = struct.getString("host_name");
            this.port = struct.getInt("port");
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrLiveLeader");
            }
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("broker_id", (Object)this.brokerId);
            struct.set("host_name", (Object)this.hostName);
            struct.set("port", (Object)this.port);
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrLiveLeader");
            }
            _size += 4;
            byte[] _stringBytes = this.hostName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'hostName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.hostName, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrLiveLeader)) {
                return false;
            }
            LeaderAndIsrLiveLeader other = (LeaderAndIsrLiveLeader)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
                return false;
            }
            return this.port == other.port;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.hostName == null ? 0 : this.hostName.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        @Override
        public LeaderAndIsrLiveLeader duplicate() {
            LeaderAndIsrLiveLeader _duplicate = new LeaderAndIsrLiveLeader();
            _duplicate.brokerId = this.brokerId;
            _duplicate.hostName = this.hostName;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrLiveLeader(brokerId=" + this.brokerId + ", hostName=" + (this.hostName == null ? "null" : "'" + this.hostName.toString() + "'") + ", port=" + this.port + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String hostName() {
            return this.hostName;
        }

        public int port() {
            return this.port;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrLiveLeader setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setHostName(String v) {
            this.hostName = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setPort(int v) {
            this.port = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port."))));
            SCHEMA_4 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.COMPACT_STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class LeaderAndIsrTopicState
    implements Message {
        private String topicName;
        private UUID topicId;
        private String clusterLinkId;
        private String clusterLinkTopicState;
        private List<LeaderAndIsrPartitionState> partitionStates;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_2), "The state of each partition"));
        public static final Schema SCHEMA_3 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_3), "The state of each partition"));
        public static final Schema SCHEMA_4 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_states", new CompactArrayOf(LeaderAndIsrPartitionState.SCHEMA_4), "The state of each partition"), Field.TaggedFieldsSection.of(10000, new Field("topic_id", Type.UUID, "The topic ID"), 10001, new Field("cluster_link_id", Type.COMPACT_NULLABLE_STRING, "Cluster link ID if this topic is being mirrored."), 10002, new Field("cluster_link_topic_state", Type.COMPACT_NULLABLE_STRING, "Cluster link state if this topic is being mirrored.")));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2, SCHEMA_3, SCHEMA_4};

        public LeaderAndIsrTopicState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrTopicState(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public LeaderAndIsrTopicState() {
            this.topicName = "";
            this.topicId = MessageUtil.ZERO_UUID;
            this.clusterLinkId = null;
            this.clusterLinkTopicState = null;
            this.partitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<LeaderAndIsrPartitionState> newCollection;
            int arrayLength;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrTopicState");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            this.topicId = MessageUtil.ZERO_UUID;
            this.clusterLinkId = null;
            this.clusterLinkTopicState = null;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                newCollection = new ArrayList<LeaderAndIsrPartitionState>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            this.topicId = _readable.readUUID();
                            continue block7;
                        }
                        case 10001: {
                            int length2 = _readable.readUnsignedVarint() - 1;
                            if (length2 < 0) {
                                this.clusterLinkId = null;
                                continue block7;
                            }
                            if (length2 > Short.MAX_VALUE) {
                                throw new RuntimeException("string field clusterLinkId had invalid length " + length2);
                            }
                            this.clusterLinkId = _readable.readString(length2);
                            continue block7;
                        }
                        case 10002: {
                            int length2 = _readable.readUnsignedVarint() - 1;
                            if (length2 < 0) {
                                this.clusterLinkTopicState = null;
                                continue block7;
                            }
                            if (length2 > Short.MAX_VALUE) {
                                throw new RuntimeException("string field clusterLinkTopicState had invalid length " + length2);
                            }
                            this.clusterLinkTopicState = _readable.readString(length2);
                            continue block7;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            LeaderAndIsrPartitionState partitionStatesElement;
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrTopicState");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 4 && this.topicId != MessageUtil.ZERO_UUID) {
                ++_numTaggedFields;
            }
            if (_version >= 4 && this.clusterLinkId != null) {
                ++_numTaggedFields;
            }
            if (_version >= 4) {
                if (this.clusterLinkTopicState != null) {
                    ++_numTaggedFields;
                }
            } else if (this.clusterLinkTopicState != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clusterLinkTopicState at version " + _version);
            }
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.partitionStates.size() + 1);
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    partitionStatesElement = (LeaderAndIsrPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionStates.size());
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    partitionStatesElement = (LeaderAndIsrPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                byte[] _stringBytes2;
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (this.topicId != MessageUtil.ZERO_UUID) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(16);
                    _writable.writeUUID(this.topicId);
                }
                if (this.clusterLinkId != null) {
                    _writable.writeUnsignedVarint(10001);
                    _stringBytes2 = _cache.getSerializedValue(this.clusterLinkId);
                    _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
                    _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                    _writable.writeByteArray(_stringBytes2);
                }
                if (this.clusterLinkTopicState != null) {
                    _writable.writeUnsignedVarint(10002);
                    _stringBytes2 = _cache.getSerializedValue(this.clusterLinkTopicState);
                    _writable.writeUnsignedVarint(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
                    _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                    _writable.writeByteArray(_stringBytes2);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrTopicState");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = struct.getString("topic_name");
            this.topicId = _version >= 4 ? (_taggedFields.containsKey(10000) ? (UUID)_taggedFields.remove(10000) : MessageUtil.ZERO_UUID) : MessageUtil.ZERO_UUID;
            this.clusterLinkId = _version >= 4 ? (_taggedFields.containsKey(10001) ? (String)_taggedFields.remove(10001) : null) : null;
            this.clusterLinkTopicState = _version >= 4 ? (_taggedFields.containsKey(10002) ? (String)_taggedFields.remove(10002) : null) : null;
            Object[] _nestedObjects = struct.getArray("partition_states");
            this.partitionStates = new ArrayList<LeaderAndIsrPartitionState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionStates.add(new LeaderAndIsrPartitionState((Struct)nestedObject, _version));
            }
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrTopicState");
            }
            TreeMap<Integer, Object> _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap<Integer, Object>();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_name", (Object)this.topicName);
            if (_version >= 4 && this.topicId != MessageUtil.ZERO_UUID) {
                _taggedFields.put(10000, this.topicId);
            }
            if (_version >= 4 && this.clusterLinkId != null) {
                _taggedFields.put(10001, this.clusterLinkId);
            }
            if (_version >= 4) {
                if (this.clusterLinkTopicState != null) {
                    _taggedFields.put(10002, this.clusterLinkTopicState);
                }
            } else if (this.clusterLinkTopicState != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clusterLinkTopicState at version " + _version);
            }
            Struct[] _nestedObjects = new Struct[this.partitionStates.size()];
            int i = 0;
            for (LeaderAndIsrPartitionState element : this.partitionStates) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partition_states", (Object)_nestedObjects);
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _stringPrefixSize;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrTopicState");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (_version >= 4 && this.topicId != MessageUtil.ZERO_UUID) {
                ++_numTaggedFields;
                _size += 2;
                ++_size;
                _size += 16;
            }
            if (_version >= 4 && this.clusterLinkId != null) {
                ++_numTaggedFields;
                _size += 2;
                _stringBytes = this.clusterLinkId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterLinkId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterLinkId, _stringBytes);
                _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize);
            }
            if (_version >= 4 && this.clusterLinkTopicState != null) {
                ++_numTaggedFields;
                _size += 2;
                _stringBytes = this.clusterLinkTopicState.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterLinkTopicState' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterLinkTopicState, _stringBytes);
                _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize);
            }
            int _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitionStates.size() + 1)) : (_arraySize += 4);
            for (LeaderAndIsrPartitionState partitionStatesElement : this.partitionStates) {
                _arraySize += partitionStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrTopicState)) {
                return false;
            }
            LeaderAndIsrTopicState other = (LeaderAndIsrTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.clusterLinkId == null ? other.clusterLinkId != null : !this.clusterLinkId.equals(other.clusterLinkId)) {
                return false;
            }
            if (this.clusterLinkTopicState == null ? other.clusterLinkTopicState != null : !this.clusterLinkTopicState.equals(other.clusterLinkTopicState)) {
                return false;
            }
            return !(this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.clusterLinkId == null ? 0 : this.clusterLinkId.hashCode());
            hashCode = 31 * hashCode + (this.clusterLinkTopicState == null ? 0 : this.clusterLinkTopicState.hashCode());
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        @Override
        public LeaderAndIsrTopicState duplicate() {
            LeaderAndIsrTopicState _duplicate = new LeaderAndIsrTopicState();
            _duplicate.topicName = this.topicName;
            _duplicate.topicId = this.topicId;
            _duplicate.clusterLinkId = this.clusterLinkId == null ? null : this.clusterLinkId;
            _duplicate.clusterLinkTopicState = this.clusterLinkTopicState == null ? null : this.clusterLinkTopicState;
            ArrayList<LeaderAndIsrPartitionState> newPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(this.partitionStates.size());
            for (LeaderAndIsrPartitionState _element : this.partitionStates) {
                newPartitionStates.add(_element.duplicate());
            }
            _duplicate.partitionStates = newPartitionStates;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrTopicState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", clusterLinkId=" + (this.clusterLinkId == null ? "null" : "'" + this.clusterLinkId.toString() + "'") + ", clusterLinkTopicState=" + (this.clusterLinkTopicState == null ? "null" : "'" + this.clusterLinkTopicState.toString() + "'") + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public UUID topicId() {
            return this.topicId;
        }

        public String clusterLinkId() {
            return this.clusterLinkId;
        }

        public String clusterLinkTopicState() {
            return this.clusterLinkTopicState;
        }

        public List<LeaderAndIsrPartitionState> partitionStates() {
            return this.partitionStates;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrTopicState setTopicId(UUID v) {
            this.topicId = v;
            return this;
        }

        public LeaderAndIsrTopicState setClusterLinkId(String v) {
            this.clusterLinkId = v;
            return this;
        }

        public LeaderAndIsrTopicState setClusterLinkTopicState(String v) {
            this.clusterLinkTopicState = v;
            return this;
        }

        public LeaderAndIsrTopicState setPartitionStates(List<LeaderAndIsrPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }
}

