/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteClusterLinksResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<EntryData> entries;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("entries", new CompactArrayOf(EntryData.SCHEMA_0), "The cluster link deletion results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public DeleteClusterLinksResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteClusterLinksResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DeleteClusterLinksResponseData() {
        this.throttleTimeMs = 0;
        this.entries = new ArrayList<EntryData>(0);
    }

    @Override
    public short apiKey() {
        return 10004;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field entries was serialized as null");
        }
        ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new EntryData(_readable, _version));
        }
        this.entries = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.entries.size() + 1);
        for (EntryData entriesElement : this.entries) {
            entriesElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] _nestedObjects = struct.getArray("entries");
        this.entries = new ArrayList<EntryData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.entries.add(new EntryData((Struct)nestedObject, _version));
        }
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] _nestedObjects = new Struct[this.entries.size()];
        int i = 0;
        for (EntryData element : this.entries) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("entries", (Object)_nestedObjects);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint(this.entries.size() + 1);
        for (EntryData entriesElement : this.entries) {
            _arraySize += entriesElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteClusterLinksResponseData)) {
            return false;
        }
        DeleteClusterLinksResponseData other = (DeleteClusterLinksResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        return hashCode;
    }

    @Override
    public DeleteClusterLinksResponseData duplicate() {
        DeleteClusterLinksResponseData _duplicate = new DeleteClusterLinksResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
        for (EntryData _element : this.entries) {
            newEntries.add(_element.duplicate());
        }
        _duplicate.entries = newEntries;
        return _duplicate;
    }

    public String toString() {
        return "DeleteClusterLinksResponseData(throttleTimeMs=" + this.throttleTimeMs + ", entries=" + MessageUtil.deepToString(this.entries.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteClusterLinksResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteClusterLinksResponseData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    public static class EntryData
    implements Message {
        private short errorCode;
        private String errorMessage;
        private String linkName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the link deletion succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link deletion succeeded."), new Field("link_name", Type.COMPACT_STRING, "The name that was assigned to the cluster link."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public EntryData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntryData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public EntryData() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.linkName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            this.linkName = struct.getString("link_name");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EntryData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            struct.set("link_name", (Object)this.linkName);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            _size += 2;
            if (this.errorMessage == null) {
                ++_size;
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
            _stringBytes = this.linkName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return !(this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            return hashCode;
        }

        @Override
        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.linkName = this.linkName;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", linkName=" + (this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String linkName() {
            return this.linkName;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public EntryData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public EntryData setLinkName(String v) {
            this.linkName = v;
            return this;
        }
    }
}

