/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteAclsRequestData
implements ApiMessage {
    private List<DeleteAclsFilter> filters;
    private String clusterId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("filters", new ArrayOf(DeleteAclsFilter.SCHEMA_0), "The filters to use when deleting ACLs."));
    public static final Schema SCHEMA_1 = new Schema(new Field("filters", new ArrayOf(DeleteAclsFilter.SCHEMA_1), "The filters to use when deleting ACLs."));
    public static final Schema SCHEMA_2 = new Schema(new Field("filters", new CompactArrayOf(DeleteAclsFilter.SCHEMA_2), "The filters to use when deleting ACLs."), Field.TaggedFieldsSection.of(10000, new Field("cluster_id", Type.COMPACT_STRING, "Optional cluster-id for centralized ACLs.")));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public DeleteAclsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteAclsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DeleteAclsRequestData() {
        this.filters = new ArrayList<DeleteAclsFilter>(0);
        this.clusterId = "";
    }

    @Override
    public short apiKey() {
        return 31;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DeleteAclsFilter> newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filters was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilter(_readable, _version));
            }
            this.filters = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filters was serialized as null");
            }
            newCollection = new ArrayList<DeleteAclsFilter>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilter(_readable, _version));
            }
            this.filters = newCollection;
        }
        this.clusterId = "";
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int length = _readable.readUnsignedVarint() - 1;
                        if (length < 0) {
                            throw new RuntimeException("non-nullable field clusterId was serialized as null");
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field clusterId had invalid length " + length);
                        }
                        this.clusterId = _readable.readString(length);
                        continue block5;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.filters.size() + 1);
            for (DeleteAclsFilter filtersElement : this.filters) {
                filtersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.filters.size());
            for (DeleteAclsFilter filtersElement : this.filters) {
                filtersElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 2) {
            if (!this.clusterId.equals("")) {
                ++_numTaggedFields;
            }
        } else if (!this.clusterId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterId at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.clusterId.equals("")) {
                _writable.writeUnsignedVarint(10000);
                byte[] _stringBytes = _cache.getSerializedValue(this.clusterId);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        Object[] _nestedObjects = struct.getArray("filters");
        this.filters = new ArrayList<DeleteAclsFilter>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.filters.add(new DeleteAclsFilter((Struct)nestedObject, _version));
        }
        this.clusterId = _version >= 2 ? (_taggedFields.containsKey(10000) ? (String)_taggedFields.remove(10000) : "") : "";
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap<Integer, String> _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap<Integer, String>();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.filters.size()];
        int i = 0;
        for (DeleteAclsFilter element : this.filters) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("filters", (Object)_nestedObjects);
        if (_version >= 2) {
            if (!this.clusterId.equals("")) {
                _taggedFields.put(10000, this.clusterId);
            }
        } else if (!this.clusterId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterId at version " + _version);
        }
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.filters.size() + 1)) : (_arraySize += 4);
        for (DeleteAclsFilter filtersElement : this.filters) {
            _arraySize += filtersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 2 && !this.clusterId.equals("")) {
            ++_numTaggedFields;
            _size += 2;
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsRequestData)) {
            return false;
        }
        DeleteAclsRequestData other = (DeleteAclsRequestData)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        return !(this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.filters == null ? 0 : this.filters.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        return hashCode;
    }

    @Override
    public DeleteAclsRequestData duplicate() {
        DeleteAclsRequestData _duplicate = new DeleteAclsRequestData();
        ArrayList<DeleteAclsFilter> newFilters = new ArrayList<DeleteAclsFilter>(this.filters.size());
        for (DeleteAclsFilter _element : this.filters) {
            newFilters.add(_element.duplicate());
        }
        _duplicate.filters = newFilters;
        _duplicate.clusterId = this.clusterId;
        return _duplicate;
    }

    public String toString() {
        return "DeleteAclsRequestData(filters=" + MessageUtil.deepToString(this.filters.iterator()) + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ")";
    }

    public List<DeleteAclsFilter> filters() {
        return this.filters;
    }

    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteAclsRequestData setFilters(List<DeleteAclsFilter> v) {
        this.filters = v;
        return this;
    }

    public DeleteAclsRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public static class DeleteAclsFilter
    implements Message {
        private byte resourceTypeFilter;
        private String resourceNameFilter;
        private byte patternTypeFilter;
        private String principalFilter;
        private String hostFilter;
        private byte operation;
        private byte permissionType;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The permission type."));
        public static final Schema SCHEMA_1 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", Type.INT8, "The pattern type."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The permission type."));
        public static final Schema SCHEMA_2 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.COMPACT_NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", Type.INT8, "The pattern type."), new Field("principal_filter", Type.COMPACT_NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", Type.COMPACT_NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The permission type."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

        public DeleteAclsFilter(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteAclsFilter(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DeleteAclsFilter() {
            this.resourceTypeFilter = 0;
            this.resourceNameFilter = "";
            this.patternTypeFilter = (byte)3;
            this.principalFilter = "";
            this.hostFilter = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilter");
            }
            this.resourceTypeFilter = _readable.readByte();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.resourceNameFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field resourceNameFilter had invalid length " + length);
                }
                this.resourceNameFilter = _readable.readString(length);
            }
            this.patternTypeFilter = _version >= 1 ? _readable.readByte() : (byte)3;
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.principalFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field principalFilter had invalid length " + length);
                }
                this.principalFilter = _readable.readString(length);
            }
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.hostFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field hostFilter had invalid length " + length);
                }
                this.hostFilter = _readable.readString(length);
            }
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceTypeFilter);
            if (this.resourceNameFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.resourceNameFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 1) {
                _writable.writeByte(this.patternTypeFilter);
            } else if (this.patternTypeFilter != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
            }
            if (this.principalFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.principalFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (this.hostFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.hostFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilter");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.resourceTypeFilter = struct.getByte("resource_type_filter");
            this.resourceNameFilter = struct.getString("resource_name_filter");
            this.patternTypeFilter = _version >= 1 ? struct.getByte("pattern_type_filter") : (byte)3;
            this.principalFilter = struct.getString("principal_filter");
            this.hostFilter = struct.getString("host_filter");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteAclsFilter");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("resource_type_filter", (Object)this.resourceTypeFilter);
            struct.set("resource_name_filter", (Object)this.resourceNameFilter);
            if (_version >= 1) {
                struct.set("pattern_type_filter", (Object)this.patternTypeFilter);
            } else if (this.patternTypeFilter != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
            }
            struct.set("principal_filter", (Object)this.principalFilter);
            struct.set("host_filter", (Object)this.hostFilter);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsFilter");
            }
            ++_size;
            if (this.resourceNameFilter == null) {
                _size = _version >= 2 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.resourceNameFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'resourceNameFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.resourceNameFilter, _stringBytes);
                _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            if (_version >= 1) {
                ++_size;
            }
            if (this.principalFilter == null) {
                _size = _version >= 2 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.principalFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'principalFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.principalFilter, _stringBytes);
                _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            if (this.hostFilter == null) {
                _size = _version >= 2 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.hostFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'hostFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.hostFilter, _stringBytes);
                _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            ++_size;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilter)) {
                return false;
            }
            DeleteAclsFilter other = (DeleteAclsFilter)obj;
            if (this.resourceTypeFilter != other.resourceTypeFilter) {
                return false;
            }
            if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
                return false;
            }
            if (this.patternTypeFilter != other.patternTypeFilter) {
                return false;
            }
            if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
                return false;
            }
            if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceTypeFilter;
            hashCode = 31 * hashCode + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
            hashCode = 31 * hashCode + this.patternTypeFilter;
            hashCode = 31 * hashCode + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
            hashCode = 31 * hashCode + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        @Override
        public DeleteAclsFilter duplicate() {
            DeleteAclsFilter _duplicate = new DeleteAclsFilter();
            _duplicate.resourceTypeFilter = this.resourceTypeFilter;
            _duplicate.resourceNameFilter = this.resourceNameFilter == null ? null : this.resourceNameFilter;
            _duplicate.patternTypeFilter = this.patternTypeFilter;
            _duplicate.principalFilter = this.principalFilter == null ? null : this.principalFilter;
            _duplicate.hostFilter = this.hostFilter == null ? null : this.hostFilter;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            return _duplicate;
        }

        public String toString() {
            return "DeleteAclsFilter(resourceTypeFilter=" + this.resourceTypeFilter + ", resourceNameFilter=" + (this.resourceNameFilter == null ? "null" : "'" + this.resourceNameFilter.toString() + "'") + ", patternTypeFilter=" + this.patternTypeFilter + ", principalFilter=" + (this.principalFilter == null ? "null" : "'" + this.principalFilter.toString() + "'") + ", hostFilter=" + (this.hostFilter == null ? "null" : "'" + this.hostFilter.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public byte resourceTypeFilter() {
            return this.resourceTypeFilter;
        }

        public String resourceNameFilter() {
            return this.resourceNameFilter;
        }

        public byte patternTypeFilter() {
            return this.patternTypeFilter;
        }

        public String principalFilter() {
            return this.principalFilter;
        }

        public String hostFilter() {
            return this.hostFilter;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsFilter setResourceTypeFilter(byte v) {
            this.resourceTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setResourceNameFilter(String v) {
            this.resourceNameFilter = v;
            return this;
        }

        public DeleteAclsFilter setPatternTypeFilter(byte v) {
            this.patternTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setPrincipalFilter(String v) {
            this.principalFilter = v;
            return this;
        }

        public DeleteAclsFilter setHostFilter(String v) {
            this.hostFilter = v;
            return this;
        }

        public DeleteAclsFilter setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsFilter setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }
    }
}

