/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ControlledShutdownRequestData
implements ApiMessage {
    private int brokerId;
    private long brokerEpoch;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public ControlledShutdownRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ControlledShutdownRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ControlledShutdownRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
    }

    @Override
    public short apiKey() {
        return 7;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _version >= 2 ? _readable.readLong() : -1L;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        if (_version >= 2) {
            _writable.writeLong(this.brokerEpoch);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.brokerId = struct.getInt("broker_id");
        this.brokerEpoch = _version >= 2 ? struct.getLong("broker_epoch") : -1L;
        if (_version >= 3 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 3) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("broker_id", (Object)this.brokerId);
        if (_version >= 2) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        if (_version >= 3) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        if (_version >= 2) {
            _size += 8;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 3) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ControlledShutdownRequestData)) {
            return false;
        }
        ControlledShutdownRequestData other = (ControlledShutdownRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        return this.brokerEpoch == other.brokerEpoch;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        return hashCode;
    }

    @Override
    public ControlledShutdownRequestData duplicate() {
        ControlledShutdownRequestData _duplicate = new ControlledShutdownRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        return _duplicate;
    }

    public String toString() {
        return "ControlledShutdownRequestData(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ControlledShutdownRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public ControlledShutdownRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The id of the broker for which controlled shutdown has been requested."));
        SCHEMA_2 = new Schema(new Field("broker_id", Type.INT32, "The id of the broker for which controlled shutdown has been requested."), new Field("broker_epoch", Type.INT64, "The broker epoch."));
        SCHEMA_3 = new Schema(new Field("broker_id", Type.INT32, "The id of the broker for which controlled shutdown has been requested."), new Field("broker_epoch", Type.INT64, "The broker epoch."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

