/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollectionTest;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ImplicitLinkedHashMultiCollectionTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testNullForbidden() {
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection();
        Assert.assertFalse((boolean)multiSet.add(null));
    }

    @Test
    public void testFindFindAllContainsRemoveOnEmptyCollection() {
        ImplicitLinkedHashMultiCollection coll = new ImplicitLinkedHashMultiCollection();
        Assert.assertNull((Object)coll.find((ImplicitLinkedHashCollection.Element)new ImplicitLinkedHashCollectionTest.TestElement(2)));
        Assert.assertFalse((boolean)coll.contains((Object)new ImplicitLinkedHashCollectionTest.TestElement(2)));
        Assert.assertFalse((boolean)coll.remove((Object)new ImplicitLinkedHashCollectionTest.TestElement(2)));
        Assert.assertTrue((boolean)coll.findAll((ImplicitLinkedHashCollection.Element)new ImplicitLinkedHashCollectionTest.TestElement(2)).isEmpty());
    }

    @Test
    public void testInsertDelete() {
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection(100);
        ImplicitLinkedHashCollectionTest.TestElement e1 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e2 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e3 = new ImplicitLinkedHashCollectionTest.TestElement(2);
        multiSet.mustAdd((ImplicitLinkedHashCollection.Element)e1);
        multiSet.mustAdd((ImplicitLinkedHashCollection.Element)e2);
        multiSet.mustAdd((ImplicitLinkedHashCollection.Element)e3);
        Assert.assertFalse((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e3));
        Assert.assertEquals((long)3L, (long)multiSet.size());
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashCollection.Element)e1).iterator(), e1, e2);
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashCollection.Element)e3).iterator(), e3);
        multiSet.remove((Object)e2);
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashCollection.Element)e1).iterator(), e1);
        Assert.assertTrue((boolean)multiSet.contains((Object)e2));
    }

    @Test
    public void testTraversal() {
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection();
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), new ImplicitLinkedHashCollectionTest.TestElement[0]);
        ImplicitLinkedHashCollectionTest.TestElement e1 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e2 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e3 = new ImplicitLinkedHashCollectionTest.TestElement(2);
        Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e1));
        Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e2));
        Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e3));
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), e1, e2, e3);
        Assert.assertTrue((boolean)multiSet.remove((Object)e2));
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), e1, e3);
        Assert.assertTrue((boolean)multiSet.remove((Object)e1));
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), e3);
    }

    static void expectExactTraversal(Iterator<ImplicitLinkedHashCollectionTest.TestElement> iterator, ImplicitLinkedHashCollectionTest.TestElement ... sequence) {
        int i = 0;
        while (iterator.hasNext()) {
            ImplicitLinkedHashCollectionTest.TestElement element = iterator.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + sequence.length + " were expected."), (i < sequence.length ? 1 : 0) != 0);
            if (sequence[i] != element) {
                Assert.fail((String)("Iterator value number " + (i + 1) + " was incorrect."));
            }
            ++i;
        }
        Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but " + sequence.length + " were expected."), (i == sequence.length ? 1 : 0) != 0);
    }

    @Test
    public void testEnlargement() {
        int i;
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection(5);
        Assert.assertEquals((long)11L, (long)multiSet.numSlots());
        ImplicitLinkedHashCollectionTest.TestElement[] testElements = new ImplicitLinkedHashCollectionTest.TestElement[]{new ImplicitLinkedHashCollectionTest.TestElement(100), new ImplicitLinkedHashCollectionTest.TestElement(101), new ImplicitLinkedHashCollectionTest.TestElement(102), new ImplicitLinkedHashCollectionTest.TestElement(100), new ImplicitLinkedHashCollectionTest.TestElement(101), new ImplicitLinkedHashCollectionTest.TestElement(105)};
        for (i = 0; i < testElements.length; ++i) {
            Assert.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)testElements[i]));
        }
        for (i = 0; i < testElements.length; ++i) {
            Assert.assertFalse((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)testElements[i]));
        }
        Assert.assertEquals((long)23L, (long)multiSet.numSlots());
        Assert.assertEquals((long)testElements.length, (long)multiSet.size());
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), testElements);
        multiSet.remove((Object)testElements[1]);
        Assert.assertEquals((long)23L, (long)multiSet.numSlots());
        Assert.assertEquals((long)5L, (long)multiSet.size());
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), testElements[0], testElements[2], testElements[3], testElements[4], testElements[5]);
    }

    @Test
    public void testManyInsertsAndDeletes() {
        Random random = new Random(123L);
        LinkedList<ImplicitLinkedHashCollectionTest.TestElement> existing = new LinkedList<ImplicitLinkedHashCollectionTest.TestElement>();
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection();
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 4; ++j) {
                ImplicitLinkedHashCollectionTest.TestElement testElement = new ImplicitLinkedHashCollectionTest.TestElement(random.nextInt());
                multiSet.mustAdd((ImplicitLinkedHashCollection.Element)testElement);
                existing.add(testElement);
            }
            int elementToRemove = random.nextInt(multiSet.size());
            Iterator iter1 = multiSet.iterator();
            Iterator iter2 = existing.iterator();
            for (int j = 0; j <= elementToRemove; ++j) {
                iter1.next();
                iter2.next();
            }
            iter1.remove();
            iter2.remove();
            this.expectTraversal(multiSet.iterator(), existing.iterator());
        }
    }

    void expectTraversal(Iterator<ImplicitLinkedHashCollectionTest.TestElement> iter, Iterator<ImplicitLinkedHashCollectionTest.TestElement> expectedIter) {
        int i = 0;
        while (iter.hasNext()) {
            ImplicitLinkedHashCollectionTest.TestElement element = iter.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + i + " were expected."), (boolean)expectedIter.hasNext());
            ImplicitLinkedHashCollectionTest.TestElement expected = expectedIter.next();
            Assert.assertTrue((String)("Iterator value number " + (i + 1) + " was incorrect."), (expected == element ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertFalse((String)("Iterator yieled " + i + " elements, but at least " + (i + 1) + " were expected."), (boolean)expectedIter.hasNext());
    }
}

