/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.utils.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUtilsTest {
    @Test
    public void testSubtractMapRemovesSecondMapsKeys() {
        HashMap<String, String> mainMap = new HashMap<String, String>();
        mainMap.put("one", "1");
        mainMap.put("two", "2");
        mainMap.put("three", "3");
        HashMap<String, String> secondaryMap = new HashMap<String, String>();
        secondaryMap.put("one", "4");
        secondaryMap.put("two", "5");
        Map newMap = CollectionUtils.subtractMap(mainMap, secondaryMap);
        Assert.assertEquals((long)3L, (long)mainMap.size());
        Assert.assertEquals((long)1L, (long)newMap.size());
        Assert.assertTrue((boolean)newMap.containsKey("three"));
        Assert.assertEquals((Object)"3", newMap.get("three"));
    }

    @Test
    public void testSubtractMapDoesntRemoveAnythingWhenEmptyMap() {
        HashMap<String, String> mainMap = new HashMap<String, String>();
        mainMap.put("one", "1");
        mainMap.put("two", "2");
        mainMap.put("three", "3");
        HashMap secondaryMap = new HashMap();
        Map newMap = CollectionUtils.subtractMap(mainMap, secondaryMap);
        Assert.assertEquals((long)3L, (long)newMap.size());
        Assert.assertEquals((Object)"1", newMap.get("one"));
        Assert.assertEquals((Object)"2", newMap.get("two"));
        Assert.assertEquals((Object)"3", newMap.get("three"));
        Assert.assertNotSame((Object)newMap, mainMap);
    }
}

