/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OffsetFetchResponseTest {
    private final int throttleTimeMs = 10;
    private final int offset = 100;
    private final String metadata = "metadata";
    private final String topicOne = "topic1";
    private final int partitionOne = 1;
    private final Optional<Integer> leaderEpochOne = Optional.of(1);
    private final String topicTwo = "topic2";
    private final int partitionTwo = 2;
    private final Optional<Integer> leaderEpochTwo = Optional.of(2);
    private Map<TopicPartition, OffsetFetchResponse.PartitionData> partitionDataMap;

    @Before
    public void setUp() {
        this.partitionDataMap = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochOne, "metadata", Errors.TOPIC_AUTHORIZATION_FAILED));
        this.partitionDataMap.put(new TopicPartition("topic2", 2), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochTwo, "metadata", Errors.UNKNOWN_TOPIC_OR_PARTITION));
    }

    @Test
    public void testConstructor() {
        OffsetFetchResponse response = new OffsetFetchResponse(10, Errors.NOT_COORDINATOR, this.partitionDataMap);
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)response.error());
        Assert.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 1), (Object)response.errorCounts());
        Assert.assertEquals((long)10L, (long)response.throttleTimeMs());
        Map responseData = response.responseData();
        Assert.assertEquals(this.partitionDataMap, (Object)responseData);
        responseData.forEach((tp, data) -> Assert.assertTrue((boolean)data.hasError()));
    }

    @Test
    public void testStructBuild() {
        this.partitionDataMap.put(new TopicPartition("topic2", 2), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochTwo, "metadata", Errors.GROUP_AUTHORIZATION_FAILED));
        OffsetFetchResponse latestResponse = new OffsetFetchResponse(10, Errors.NONE, this.partitionDataMap);
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            Struct struct = latestResponse.data.toStruct(version);
            OffsetFetchResponse oldResponse = new OffsetFetchResponse(struct, version);
            if (version <= 1) {
                Assert.assertFalse((boolean)struct.hasField((Field)CommonFields.ERROR_CODE));
                Assert.assertEquals((Object)Errors.GROUP_AUTHORIZATION_FAILED, (Object)oldResponse.error());
                Assert.assertEquals(Collections.singletonMap(Errors.GROUP_AUTHORIZATION_FAILED, 1), (Object)oldResponse.errorCounts());
            } else {
                Assert.assertTrue((boolean)struct.hasField((Field)CommonFields.ERROR_CODE));
                Assert.assertEquals((Object)Errors.NONE, (Object)oldResponse.error());
                Assert.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)oldResponse.errorCounts());
            }
            if (version <= 2) {
                Assert.assertEquals((long)0L, (long)oldResponse.throttleTimeMs());
            } else {
                Assert.assertEquals((long)10L, (long)oldResponse.throttleTimeMs());
            }
            HashMap<TopicPartition, OffsetFetchResponse.PartitionData> expectedDataMap = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
            for (Map.Entry<TopicPartition, OffsetFetchResponse.PartitionData> entry : this.partitionDataMap.entrySet()) {
                OffsetFetchResponse.PartitionData partitionData = entry.getValue();
                expectedDataMap.put(entry.getKey(), new OffsetFetchResponse.PartitionData(partitionData.offset, version <= 4 ? Optional.empty() : partitionData.leaderEpoch, partitionData.metadata, partitionData.error));
            }
            Map responseData = oldResponse.responseData();
            Assert.assertEquals(expectedDataMap, (Object)responseData);
            responseData.forEach((tp, data) -> Assert.assertTrue((boolean)data.hasError()));
        }
    }

    @Test
    public void testShouldThrottle() {
        OffsetFetchResponse response = new OffsetFetchResponse(10, Errors.NONE, this.partitionDataMap);
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            if (version >= 4) {
                Assert.assertTrue((boolean)response.shouldClientThrottle(version));
                continue;
            }
            Assert.assertFalse((boolean)response.shouldClientThrottle(version));
        }
    }

    @Test
    public void testNullableMetadata() {
        this.partitionDataMap.clear();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, this.leaderEpochOne, null, Errors.UNKNOWN_TOPIC_OR_PARTITION));
        OffsetFetchResponse response = new OffsetFetchResponse(10, Errors.GROUP_AUTHORIZATION_FAILED, this.partitionDataMap);
        OffsetFetchResponseData expectedData = new OffsetFetchResponseData().setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code()).setThrottleTimeMs(10).setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("topic1").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(1).setCommittedOffset(100L).setCommittedLeaderEpoch(this.leaderEpochOne.orElse(-1)).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setMetadata(null)))));
        Assert.assertEquals((Object)expectedData, (Object)response.data);
    }

    @Test
    public void testUseDefaultLeaderEpoch() {
        Optional emptyLeaderEpoch = Optional.empty();
        this.partitionDataMap.clear();
        this.partitionDataMap.put(new TopicPartition("topic1", 1), new OffsetFetchResponse.PartitionData(100L, emptyLeaderEpoch, "metadata", Errors.UNKNOWN_TOPIC_OR_PARTITION));
        OffsetFetchResponse response = new OffsetFetchResponse(10, Errors.NOT_COORDINATOR, this.partitionDataMap);
        OffsetFetchResponseData expectedData = new OffsetFetchResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10).setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("topic1").setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(1).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setMetadata("metadata")))));
        Assert.assertEquals((Object)expectedData, (Object)response.data);
    }
}

