/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.junit.Assert;
import org.junit.Test;

public class EpochEndOffsetTest {
    @Test
    public void testConstructor() {
        int leaderEpoch = 5;
        long endOffset = 10L;
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.FENCED_LEADER_EPOCH, leaderEpoch, endOffset);
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)endOffset, (long)epochEndOffset.endOffset());
        Assert.assertTrue((boolean)epochEndOffset.hasError());
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)epochEndOffset.error());
        Assert.assertFalse((boolean)epochEndOffset.hasUndefinedEpochOrOffset());
    }

    @Test
    public void testWithUndefinedEpoch() {
        EpochEndOffset epochEndOffset = new EpochEndOffset(-1, 2L);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)2L, (long)epochEndOffset.endOffset());
        Assert.assertFalse((boolean)epochEndOffset.hasError());
        Assert.assertEquals((Object)Errors.NONE, (Object)epochEndOffset.error());
        Assert.assertTrue((boolean)epochEndOffset.hasUndefinedEpochOrOffset());
    }

    @Test
    public void testWithUndefinedEndOffset() {
        EpochEndOffset epochEndOffset = new EpochEndOffset(3, -1L);
        Assert.assertEquals((long)3L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertFalse((boolean)epochEndOffset.hasError());
        Assert.assertEquals((Object)Errors.NONE, (Object)epochEndOffset.error());
        Assert.assertTrue((boolean)epochEndOffset.hasUndefinedEpochOrOffset());
    }
}

