/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.junit.Assert;
import org.junit.Test;

public class EndTxnResponseTest {
    @Test
    public void testConstructorWithStruct() {
        int throttleTimeMs = 10;
        EndTxnResponseData data = new EndTxnResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(throttleTimeMs);
        Map<Errors, Integer> expectedErrorCounts = Collections.singletonMap(Errors.NOT_COORDINATOR, 1);
        for (short version = 0; version <= ApiKeys.END_TXN.latestVersion(); version = (short)(version + 1)) {
            EndTxnResponse response = new EndTxnResponse(data.toStruct(version), version);
            Assert.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
            Assert.assertEquals((long)throttleTimeMs, (long)response.throttleTimeMs());
            Assert.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)response.shouldClientThrottle(version));
        }
    }
}

