/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.KafkaLZ4BlockInputStream;
import org.apache.kafka.common.record.KafkaLZ4BlockOutputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class CompressionTypeTest {
    @Test
    public void testLZ4FramingMagicV0() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        KafkaLZ4BlockOutputStream out = (KafkaLZ4BlockOutputStream)CompressionType.LZ4.wrapForOutput(new ByteBufferOutputStream(buffer), (byte)0);
        Assert.assertTrue((boolean)out.useBrokenFlagDescriptorChecksum());
        buffer.rewind();
        KafkaLZ4BlockInputStream in = (KafkaLZ4BlockInputStream)CompressionType.LZ4.wrapForInput(buffer, (byte)0, BufferSupplier.NO_CACHING);
        Assert.assertTrue((boolean)in.ignoreFlagDescriptorChecksum());
    }

    @Test
    public void testLZ4FramingMagicV1() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        KafkaLZ4BlockOutputStream out = (KafkaLZ4BlockOutputStream)CompressionType.LZ4.wrapForOutput(new ByteBufferOutputStream(buffer), (byte)1);
        Assert.assertFalse((boolean)out.useBrokenFlagDescriptorChecksum());
        buffer.rewind();
        KafkaLZ4BlockInputStream in = (KafkaLZ4BlockInputStream)CompressionType.LZ4.wrapForInput(buffer, (byte)1, BufferSupplier.create());
        Assert.assertFalse((boolean)in.ignoreFlagDescriptorChecksum());
    }
}

