/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.OffsetsForLeaderEpochClient;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class OffsetForLeaderEpochClientTest {
    private ConsumerNetworkClient consumerClient;
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private MockClient client;
    private Time time;
    private TopicPartition tp0 = new TopicPartition("topic", 0);

    @Test
    public void testEmptyResponse() {
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), Collections.emptyMap());
        OffsetsForLeaderEpochResponse resp = new OffsetsForLeaderEpochResponse(Collections.emptyMap());
        this.client.prepareResponse((AbstractResponse)resp);
        this.consumerClient.pollNoWakeup();
        OffsetsForLeaderEpochClient.OffsetForEpochResult result = (OffsetsForLeaderEpochClient.OffsetForEpochResult)future.value();
        Assert.assertTrue((boolean)result.partitionsToRetry().isEmpty());
        Assert.assertTrue((boolean)result.endOffsets().isEmpty());
    }

    @Test
    public void testUnexpectedEmptyResponse() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        OffsetsForLeaderEpochResponse resp = new OffsetsForLeaderEpochResponse(Collections.emptyMap());
        this.client.prepareResponse((AbstractResponse)resp);
        this.consumerClient.pollNoWakeup();
        OffsetsForLeaderEpochClient.OffsetForEpochResult result = (OffsetsForLeaderEpochClient.OffsetForEpochResult)future.value();
        Assert.assertFalse((boolean)result.partitionsToRetry().isEmpty());
        Assert.assertTrue((boolean)result.endOffsets().isEmpty());
    }

    @Test
    public void testOkResponse() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        HashMap<TopicPartition, EpochEndOffset> endOffsetMap = new HashMap<TopicPartition, EpochEndOffset>();
        endOffsetMap.put(this.tp0, new EpochEndOffset(Errors.NONE, 1, 10L));
        this.client.prepareResponse((AbstractResponse)new OffsetsForLeaderEpochResponse(endOffsetMap));
        this.consumerClient.pollNoWakeup();
        OffsetsForLeaderEpochClient.OffsetForEpochResult result = (OffsetsForLeaderEpochClient.OffsetForEpochResult)future.value();
        Assert.assertTrue((boolean)result.partitionsToRetry().isEmpty());
        Assert.assertTrue((boolean)result.endOffsets().containsKey(this.tp0));
        Assert.assertEquals((Object)((EpochEndOffset)result.endOffsets().get(this.tp0)).error(), (Object)Errors.NONE);
        Assert.assertEquals((long)((EpochEndOffset)result.endOffsets().get(this.tp0)).leaderEpoch(), (long)1L);
        Assert.assertEquals((long)((EpochEndOffset)result.endOffsets().get(this.tp0)).endOffset(), (long)10L);
    }

    @Test
    public void testUnauthorizedTopic() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        HashMap<TopicPartition, EpochEndOffset> endOffsetMap = new HashMap<TopicPartition, EpochEndOffset>();
        endOffsetMap.put(this.tp0, new EpochEndOffset(Errors.TOPIC_AUTHORIZATION_FAILED, -1, -1L));
        this.client.prepareResponse((AbstractResponse)new OffsetsForLeaderEpochResponse(endOffsetMap));
        this.consumerClient.pollNoWakeup();
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals(future.exception().getClass(), TopicAuthorizationException.class);
        Assert.assertTrue((boolean)((TopicAuthorizationException)((Object)future.exception())).unauthorizedTopics().contains(this.tp0.topic()));
    }

    @Test
    public void testRetriableError() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        HashMap<TopicPartition, EpochEndOffset> endOffsetMap = new HashMap<TopicPartition, EpochEndOffset>();
        endOffsetMap.put(this.tp0, new EpochEndOffset(Errors.LEADER_NOT_AVAILABLE, -1, -1L));
        this.client.prepareResponse((AbstractResponse)new OffsetsForLeaderEpochResponse(endOffsetMap));
        this.consumerClient.pollNoWakeup();
        Assert.assertFalse((boolean)future.failed());
        OffsetsForLeaderEpochClient.OffsetForEpochResult result = (OffsetsForLeaderEpochClient.OffsetForEpochResult)future.value();
        Assert.assertTrue((boolean)result.partitionsToRetry().contains(this.tp0));
        Assert.assertFalse((boolean)result.endOffsets().containsKey(this.tp0));
    }

    private OffsetsForLeaderEpochClient newOffsetClient() {
        this.buildDependencies(OffsetResetStrategy.EARLIEST);
        return new OffsetsForLeaderEpochClient(this.consumerClient, new LogContext());
    }

    private void buildDependencies(OffsetResetStrategy offsetResetStrategy) {
        LogContext logContext = new LogContext();
        this.time = new MockTime(1L);
        this.subscriptions = new SubscriptionState(logContext, offsetResetStrategy);
        this.metadata = new ConsumerMetadata(0L, Long.MAX_VALUE, false, false, this.subscriptions, logContext, new ClusterResourceListeners());
        this.client = new MockClient(this.time, this.metadata);
        this.consumerClient = new ConsumerNetworkClient(logContext, (KafkaClient)this.client, this.metadata, this.time, 100L, 1000, Integer.MAX_VALUE);
    }
}

