/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTest {
    private static final ConfigEntry E1 = new ConfigEntry("a", "b");
    private static final ConfigEntry E2 = new ConfigEntry("c", "d");
    private Config config;

    @Before
    public void setUp() {
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        entries.add(E1);
        entries.add(E2);
        this.config = new Config(entries);
    }

    @Test
    public void shouldGetEntry() {
        MatcherAssert.assertThat((Object)this.config.get("a"), (Matcher)CoreMatchers.is((Object)E1));
        MatcherAssert.assertThat((Object)this.config.get("c"), (Matcher)CoreMatchers.is((Object)E2));
    }

    @Test
    public void shouldReturnNullOnGetUnknownEntry() {
        MatcherAssert.assertThat((Object)this.config.get("unknown"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldGetAllEntries() {
        MatcherAssert.assertThat((Object)this.config.entries().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.config.entries(), (Matcher)CoreMatchers.hasItems((Object[])new ConfigEntry[]{E1, E2}));
    }

    @Test
    public void shouldImplementEqualsProperly() {
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        entries.add(E1);
        MatcherAssert.assertThat((Object)this.config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.config)));
        MatcherAssert.assertThat((Object)this.config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new Config(this.config.entries()))));
        MatcherAssert.assertThat((Object)this.config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)new Config(entries)))));
        MatcherAssert.assertThat((Object)this.config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"this"))));
    }

    @Test
    public void shouldImplementHashCodeProperly() {
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        entries.add(E1);
        MatcherAssert.assertThat((Object)this.config.hashCode(), (Matcher)CoreMatchers.is((Object)this.config.hashCode()));
        MatcherAssert.assertThat((Object)this.config.hashCode(), (Matcher)CoreMatchers.is((Object)new Config(this.config.entries()).hashCode()));
        MatcherAssert.assertThat((Object)this.config.hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)new Config(entries).hashCode())));
    }

    @Test
    public void shouldImplementToStringProperly() {
        MatcherAssert.assertThat((Object)this.config.toString(), (Matcher)CoreMatchers.containsString((String)E1.toString()));
        MatcherAssert.assertThat((Object)this.config.toString(), (Matcher)CoreMatchers.containsString((String)E2.toString()));
    }

    public static ConfigEntry newConfigEntry(String name, String value, ConfigEntry.ConfigSource source, boolean isSensitive, boolean isReadOnly, List<ConfigEntry.ConfigSynonym> synonyms) {
        return new ConfigEntry(name, value, source, isSensitive, isReadOnly, synonyms, ConfigEntry.ConfigType.UNKNOWN, null);
    }
}

