/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigUtilsTest {
    private static final ConfigDef CONFIG = new ConfigDef().define("myPassword", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "").define("myString", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "").define("myInt", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "").define("myString2", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "");

    @Test
    public void testConfigMapToRedactedStringForEmptyMap() {
        Assertions.assertEquals((Object)"{}", (Object)ConfigUtils.configMapToRedactedString(Collections.emptyMap(), (ConfigDef)CONFIG));
    }

    @Test
    public void testConfigMapToRedactedStringWithSecrets() {
        HashMap<String, Object> testMap1 = new HashMap<String, Object>();
        testMap1.put("myString", "whatever");
        testMap1.put("myInt", 123);
        testMap1.put("myPassword", "foosecret");
        testMap1.put("myString2", null);
        testMap1.put("myUnknown", 456);
        Assertions.assertEquals((Object)"{myInt=123, myPassword=(redacted), myString=\"whatever\", myString2=null, myUnknown=(redacted)}", (Object)ConfigUtils.configMapToRedactedString(testMap1, (ConfigDef)CONFIG));
    }

    @Test
    public void testGetBoolean() {
        String key = "test.key";
        boolean defaultValue = true;
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("some.other.key", false);
        Assertions.assertEquals((Object)defaultValue, (Object)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, false);
        Assertions.assertFalse((boolean)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, "false");
        Assertions.assertFalse((boolean)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, "not-a-boolean");
        Assertions.assertFalse((boolean)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, 5);
        Assertions.assertEquals((Object)defaultValue, (Object)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
    }
}

