/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class EndTxnRequestTest {
    @Test
    public void testConstructor() {
        short producerEpoch = 0;
        int producerId = 1;
        String transactionId = "txn_id";
        int throttleTimeMs = 10;
        boolean isTransactionV2Enabled = true;
        EndTxnRequest.Builder builder = new EndTxnRequest.Builder(new EndTxnRequestData().setCommitted(true).setProducerEpoch(producerEpoch).setProducerId((long)producerId).setTransactionalId(transactionId), isTransactionV2Enabled);
        Iterator iterator = ApiKeys.END_TXN.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            EndTxnRequest request = builder.build(version);
            EndTxnResponse response = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.NOT_COORDINATOR.exception());
            Assertions.assertEquals(Collections.singletonMap(Errors.NOT_COORDINATOR, 1), (Object)response.errorCounts());
            Assertions.assertEquals((Object)TransactionResult.COMMIT, (Object)request.result());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testEndTxnRequestWithParameterizedTransactionsV2(boolean isTransactionV2Enabled) {
        short latestVersion = ApiKeys.END_TXN.latestVersion();
        EndTxnRequestData requestData = new EndTxnRequestData().setTransactionalId("txn_id").setCommitted(true).setProducerId(1L).setProducerEpoch((short)0);
        EndTxnRequest.Builder builder = new EndTxnRequest.Builder(requestData, false, isTransactionV2Enabled);
        EndTxnRequest request = builder.build(latestVersion);
        short expectedVersion = isTransactionV2Enabled ? latestVersion : (short)4;
        Assertions.assertEquals((short)expectedVersion, (short)request.version());
        Assertions.assertEquals((long)1L, (long)request.data().producerId());
        Assertions.assertEquals((short)0, (short)request.data().producerEpoch());
    }
}

