/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class ApiVersionsResponseTest {
    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void shouldHaveCorrectDefaultApiVersionsResponse(ApiMessageType.ListenerType scope) {
        ApiVersionsResponse defaultResponse = TestUtils.defaultApiVersionsResponse(scope);
        Assertions.assertEquals((int)ApiKeys.apisForListener((ApiMessageType.ListenerType)scope).size(), (int)defaultResponse.data().apiKeys().size(), (String)"API versions for all API keys must be maintained.");
        for (ApiKeys key : ApiKeys.apisForListener((ApiMessageType.ListenerType)scope)) {
            int minVersion;
            ApiVersionsResponseData.ApiVersion version = defaultResponse.apiVersion(key.id);
            Assertions.assertNotNull((Object)version, (String)("Could not find ApiVersion for API " + key.name));
            if (key == ApiKeys.PRODUCE) {
                Assertions.assertEquals((short)0, (short)version.minVersion(), (String)("Incorrect min version for Api " + key.name));
            } else {
                Assertions.assertEquals((short)key.oldestVersion(), (short)version.minVersion(), (String)("Incorrect min version for Api " + key.name));
            }
            Assertions.assertEquals((short)key.latestVersion(), (short)version.maxVersion(), (String)("Incorrect max version for Api " + key.name));
            for (int i = 0; i < version.minVersion(); ++i) {
                Assertions.assertNull((Object)key.messageType.requestSchemas()[i], (String)("Request version " + i + " for API " + version.apiKey() + " must be null"));
                Assertions.assertNull((Object)key.messageType.responseSchemas()[i], (String)("Response version " + i + " for API " + version.apiKey() + " must be null"));
            }
            for (int i = minVersion = (int)(key == ApiKeys.PRODUCE && scope == ApiMessageType.ListenerType.BROKER ? ApiKeys.PRODUCE.oldestVersion() : version.minVersion()); i <= version.maxVersion(); ++i) {
                Assertions.assertNotNull((Object)key.messageType.requestSchemas()[i], (String)("Request version " + i + " for API " + version.apiKey() + " must not be null"));
                Assertions.assertNotNull((Object)key.messageType.responseSchemas()[i], (String)("Response version " + i + " for API " + version.apiKey() + " must not be null"));
            }
        }
        Assertions.assertTrue((boolean)defaultResponse.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)defaultResponse.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)defaultResponse.data().finalizedFeaturesEpoch());
    }

    @Test
    public void shouldHaveCommonlyAgreedApiVersionResponseWithControllerOnForwardableAPIs() {
        ApiKeys forwardableAPIKey = ApiKeys.CREATE_ACLS;
        ApiKeys nonForwardableAPIKey = ApiKeys.JOIN_GROUP;
        int minVersion = 2;
        int maxVersion = 3;
        Map activeControllerApiVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)forwardableAPIKey, (Object)new ApiVersionsResponseData.ApiVersion().setApiKey(forwardableAPIKey.id).setMinVersion((short)2).setMaxVersion((short)3)), Utils.mkEntry((Object)nonForwardableAPIKey, (Object)new ApiVersionsResponseData.ApiVersion().setApiKey(nonForwardableAPIKey.id).setMinVersion((short)2).setMaxVersion((short)3))});
        ApiVersionsResponseData.ApiVersionCollection commonResponse = ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (Map)activeControllerApiVersions, (boolean)true, (boolean)false);
        this.verifyVersions(forwardableAPIKey.id, (short)2, (short)3, commonResponse);
        this.verifyVersions(nonForwardableAPIKey.id, ApiKeys.JOIN_GROUP.oldestVersion(), ApiKeys.JOIN_GROUP.latestVersion(), commonResponse);
    }

    @Test
    public void shouldReturnAllKeysWhenThrottleMsIsDefaultThrottle() {
        ApiVersionsResponse response = new ApiVersionsResponse.Builder().setThrottleTimeMs(0).setApiVersions(ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (boolean)true, (boolean)true)).setSupportedFeatures(Features.emptySupportedFeatures()).setFinalizedFeatures(Collections.emptyMap()).setFinalizedFeaturesEpoch(-1L).build();
        Assertions.assertEquals(new HashSet(ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER)), this.apiKeysInResponse(response));
        Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
        Assertions.assertTrue((boolean)response.data().supportedFeatures().isEmpty());
        Assertions.assertTrue((boolean)response.data().finalizedFeatures().isEmpty());
        Assertions.assertEquals((long)-1L, (long)response.data().finalizedFeaturesEpoch());
    }

    @Test
    public void shouldCreateApiResponseWithTelemetryWhenEnabled() {
        ApiVersionsResponse response = new ApiVersionsResponse.Builder().setThrottleTimeMs(10).setApiVersions(ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (boolean)true, (boolean)true)).setSupportedFeatures(Features.emptySupportedFeatures()).setFinalizedFeatures(Collections.emptyMap()).setFinalizedFeaturesEpoch(-1L).build();
        this.verifyApiKeysForTelemetry(response, 2);
    }

    @Test
    public void shouldNotCreateApiResponseWithTelemetryWhenDisabled() {
        ApiVersionsResponse response = new ApiVersionsResponse.Builder().setThrottleTimeMs(10).setApiVersions(ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (boolean)true, (boolean)false)).setSupportedFeatures(Features.emptySupportedFeatures()).setFinalizedFeatures(Collections.emptyMap()).setFinalizedFeaturesEpoch(-1L).build();
        this.verifyApiKeysForTelemetry(response, 0);
    }

    @Test
    public void testBrokerApisAreEnabled() {
        ApiVersionsResponse response = new ApiVersionsResponse.Builder().setThrottleTimeMs(0).setApiVersions(ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (boolean)true, (boolean)true)).setSupportedFeatures(Features.emptySupportedFeatures()).setFinalizedFeatures(Collections.emptyMap()).setFinalizedFeaturesEpoch(-1L).build();
        HashSet<ApiKeys> exposed = this.apiKeysInResponse(response);
        Arrays.stream(ApiKeys.values()).filter(key -> key.messageType.listeners().contains(ApiMessageType.ListenerType.BROKER)).forEach(key -> Assertions.assertTrue((boolean)exposed.contains(key)));
        Arrays.stream(ApiKeys.values()).filter(key -> key.messageType.listeners().stream().noneMatch(listener -> listener == ApiMessageType.ListenerType.BROKER)).forEach(key -> Assertions.assertFalse((boolean)exposed.contains(key)));
    }

    @Test
    public void testIntersect() {
        Assertions.assertFalse((boolean)ApiVersionsResponse.intersect(null, null).isPresent());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)new ApiVersionsResponseData.ApiVersion().setApiKey((short)10), (ApiVersionsResponseData.ApiVersion)new ApiVersionsResponseData.ApiVersion().setApiKey((short)3)));
        short min = 0;
        short max = 10;
        ApiVersionsResponseData.ApiVersion thisVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FETCH.id).setMinVersion(min).setMaxVersion((short)Short.MAX_VALUE);
        ApiVersionsResponseData.ApiVersion other = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FETCH.id).setMinVersion((short)Short.MIN_VALUE).setMaxVersion(max);
        ApiVersionsResponseData.ApiVersion expected = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FETCH.id).setMinVersion(min).setMaxVersion(max);
        Assertions.assertFalse((boolean)ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)thisVersion, null).isPresent());
        Assertions.assertFalse((boolean)ApiVersionsResponse.intersect(null, (ApiVersionsResponseData.ApiVersion)other).isPresent());
        Assertions.assertEquals((Object)expected, ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)thisVersion, (ApiVersionsResponseData.ApiVersion)other).get());
        Assertions.assertEquals((Object)expected, ApiVersionsResponse.intersect((ApiVersionsResponseData.ApiVersion)other, (ApiVersionsResponseData.ApiVersion)thisVersion).get());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testAlterV0Features(boolean alterV0Features) {
        Features supported = Features.supportedFeatures(Collections.singletonMap("my.feature", new SupportedVersionRange(0, 1)));
        ApiVersionsResponse response = new ApiVersionsResponse.Builder().setApiVersions(ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (boolean)true, (boolean)true)).setSupportedFeatures(supported).setFinalizedFeatures(Collections.emptyMap()).setFinalizedFeaturesEpoch(-1L).setAlterFeatureLevel0(alterV0Features).build();
        if (alterV0Features) {
            Assertions.assertNull((Object)response.data().supportedFeatures().find("my.feature"));
        } else {
            Assertions.assertEquals((Object)new ApiVersionsResponseData.SupportedFeatureKey().setName("my.feature").setMinVersion((short)0).setMaxVersion((short)1), (Object)response.data().supportedFeatures().find("my.feature"));
        }
    }

    private void verifyVersions(short forwardableAPIKey, short minVersion, short maxVersion, ApiVersionsResponseData.ApiVersionCollection commonResponse) {
        ApiVersionsResponseData.ApiVersion expectedVersionsForForwardableAPI = new ApiVersionsResponseData.ApiVersion().setApiKey(forwardableAPIKey).setMinVersion(minVersion).setMaxVersion(maxVersion);
        Assertions.assertEquals((Object)expectedVersionsForForwardableAPI, (Object)commonResponse.find(forwardableAPIKey));
    }

    private void verifyApiKeysForTelemetry(ApiVersionsResponse response, int expectedCount) {
        int count = 0;
        for (ApiVersionsResponseData.ApiVersion version : response.data().apiKeys()) {
            if (version.apiKey() != ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS.id && version.apiKey() != ApiKeys.PUSH_TELEMETRY.id) continue;
            ++count;
        }
        Assertions.assertEquals((int)expectedCount, (int)count);
    }

    private HashSet<ApiKeys> apiKeysInResponse(ApiVersionsResponse apiVersions) {
        HashSet<ApiKeys> apiKeys = new HashSet<ApiKeys>();
        for (ApiVersionsResponseData.ApiVersion version : apiVersions.data().apiKeys()) {
            apiKeys.add(ApiKeys.forId((int)version.apiKey()));
        }
        return apiKeys;
    }
}

